/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.Configurable;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.factory.BrokerFactory;
import org.apache.activemq.artemis.factory.SecurityManagerFactory;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

@Command(name="run", description="runs the broker instance")
public class Run
extends Configurable {
    @Option(name={"--allow-kill"}, description="This will allow the server to kill itself. Useful for tests (failover tests for instance)")
    boolean allowKill;
    private Broker server;
    private ArrayList<ActiveMQComponent> components = new ArrayList();

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        Artemis.printBanner();
        this.createDirectories(this.getFileConfiguration());
        BrokerDTO broker = this.getBrokerDTO();
        this.addShutdownHook(broker.server.getConfigurationFile().getParentFile());
        ActiveMQSecurityManager security = SecurityManagerFactory.create(broker.security);
        this.server = BrokerFactory.createServer(broker.server, security);
        this.server.start();
        if (broker.web != null) {
            broker.components.add(broker.web);
        }
        for (ComponentDTO componentDTO : broker.components) {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(componentDTO.componentClassName);
            ExternalComponent component = (ExternalComponent)clazz.newInstance();
            component.configure(componentDTO, this.getBrokerInstance(), this.getBrokerHome());
            component.start();
            this.components.add(component);
        }
        return null;
    }

    private void createDirectories(FileConfiguration fileConfiguration) {
        new File(fileConfiguration.getBindingsDirectory()).mkdirs();
        new File(fileConfiguration.getJournalDirectory()).mkdirs();
        new File(fileConfiguration.getPagingDirectory()).mkdirs();
        new File(fileConfiguration.getLargeMessagesDirectory()).mkdirs();
    }

    private void addShutdownHook(File configurationDir) {
        File fileKill;
        final File file = new File(configurationDir, "STOP_ME");
        if (file.exists() && !file.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(file.getAbsolutePath());
        }
        if ((fileKill = new File(configurationDir, "KILL_ME")).exists() && !fileKill.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(fileKill.getAbsolutePath());
        }
        final Timer timer = new Timer("ActiveMQ Artemis Server Shutdown Timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (Run.this.allowKill && fileKill.exists()) {
                    try {
                        System.err.println("Halting by user request");
                        fileKill.delete();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    Runtime.getRuntime().halt(0);
                }
                if (file.exists()) {
                    try {
                        try {
                            Run.this.server.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        timer.cancel();
                    }
                    finally {
                        Runtime.getRuntime().exit(0);
                    }
                }
            }
        }, 500L, 500L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Run.this.server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

