/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp.v10;

import java.util.Map;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.FrameEventListener;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompDecoder;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.VersionedStompFrameHandler;
import org.apache.activemq.artemis.core.protocol.stomp.v10.StompFrameV10;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;

public class StompFrameHandlerV10
extends VersionedStompFrameHandler
implements FrameEventListener {
    public StompFrameHandlerV10(StompConnection connection) {
        super(connection);
        this.decoder = new StompDecoder();
        this.decoder.init();
        connection.addStompEventListener(this);
    }

    @Override
    public StompFrame onConnect(StompFrame frame) {
        StompFrameV10 response = null;
        Map<String, String> headers = frame.getHeadersMap();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientID = headers.get("client-id");
        String requestID = headers.get("request-id");
        if (this.connection.validateUser(login, passcode)) {
            this.connection.setClientID(clientID);
            this.connection.setValid(true);
            response = new StompFrameV10("CONNECTED");
            if (frame.hasHeader("accept-version")) {
                response.addHeader("version", "1.0");
            }
            response.addHeader("session", this.connection.getID().toString());
            if (requestID != null) {
                response.addHeader("response-id", requestID);
            }
        } else {
            response = new StompFrameV10("ERROR");
            response.addHeader("message", "Failed to connect");
            response.setBody("The login account is not valid.");
        }
        return response;
    }

    @Override
    public StompFrame onDisconnect(StompFrame frame) {
        return null;
    }

    @Override
    public StompFrame onUnsubscribe(StompFrame request) {
        StompFrame response = null;
        String destination = request.getHeader("destination");
        String id = request.getHeader("id");
        String durableSubscriberName = request.getHeader("durable-subscriber-name");
        String subscriptionID = null;
        if (id != null) {
            subscriptionID = id;
        } else {
            if (destination == null) {
                ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.needIDorDestination();
                response = error.getFrame();
                return response;
            }
            subscriptionID = "subscription/" + destination;
        }
        try {
            this.connection.unsubscribe(subscriptionID, durableSubscriberName);
        }
        catch (ActiveMQStompException e) {
            return e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onAck(StompFrame request) {
        StompFrame response = null;
        String messageID = request.getHeader("message-id");
        String txID = request.getHeader("transaction");
        if (txID != null) {
            ActiveMQServerLogger.LOGGER.stompTXAckNorSupported();
        }
        try {
            this.connection.acknowledge(messageID, null);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onStomp(StompFrame request) {
        return this.onUnknown(request.getCommand());
    }

    @Override
    public StompFrame onNack(StompFrame request) {
        return this.onUnknown(request.getCommand());
    }

    @Override
    public StompFrame createStompFrame(String command) {
        return new StompFrameV10(command);
    }

    @Override
    public void replySent(StompFrame reply) {
        if (reply.needsDisconnect()) {
            this.connection.destroy();
        }
    }

    @Override
    public void requestAccepted(StompFrame request) {
    }
}

