/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp.v12;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;

public class StompFrameV12
extends StompFrame {
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    private final List<StompFrame.Header> allHeaders = new ArrayList<StompFrame.Header>();

    public StompFrameV12(String command, Map<String, String> headers, byte[] content) {
        super(command, headers, content);
    }

    public StompFrameV12(String command) {
        super(command);
    }

    @Override
    public ActiveMQBuffer toActiveMQBuffer() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.bytesBody != null ? ActiveMQBuffers.dynamicBuffer((int)(this.bytesBody.length + 512)) : ActiveMQBuffers.dynamicBuffer((int)512);
            StringBuffer head = new StringBuffer();
            head.append(this.command);
            head.append("\n");
            for (StompFrame.Header h : this.allHeaders) {
                head.append(h.getEncodedKey());
                head.append(":");
                head.append(h.getEncodedValue());
                head.append("\n");
            }
            if (this.bytesBody != null && this.bytesBody.length > 0) {
                head.append("content-length");
                head.append(":");
                head.append(this.bytesBody.length);
                head.append("\n");
            }
            head.append("\n");
            this.buffer.writeBytes(head.toString().getBytes(StandardCharsets.UTF_8));
            if (this.bytesBody != null) {
                this.buffer.writeBytes(this.bytesBody);
            }
            this.buffer.writeBytes(END_OF_FRAME);
            this.size = this.buffer.writerIndex();
        }
        return this.buffer;
    }

    @Override
    public void addHeader(String key, String val) {
        if (!this.headers.containsKey(key)) {
            this.headers.put(key, val);
            this.allHeaders.add(new StompFrame.Header(this, key, val));
        } else if (!key.equals("content-length")) {
            this.allHeaders.add(new StompFrame.Header(this, key, val));
        }
    }
}

