/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.GeneralSecurityException;
import javax.net.ssl.X509KeyManager;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SSLClientCertificateConfiguration;

class SSLClientKeyManagerConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<X509KeyManager> keyManagerFactory;

    SSLClientKeyManagerConfiguration(AuthenticationConfiguration parent, SecurityFactory<X509KeyManager> keyManagerFactory) {
        super(parent.without(SSLClientCertificateConfiguration.class));
        this.keyManagerFactory = keyManagerFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SSLClientKeyManagerConfiguration(newParent, this.keyManagerFactory);
    }

    @Override
    SecurityFactory<X509KeyManager> getX509KeyManagerFactory() throws GeneralSecurityException {
        return this.keyManagerFactory;
    }
}

