/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetRealmAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final String realm;

    SetRealmAuthenticationConfiguration(AuthenticationConfiguration parent, String realm) {
        super(parent);
        this.realm = realm;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof RealmCallback) {
            RealmCallback realmCallback = (RealmCallback)callback;
            realmCallback.setText(this.realm);
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetRealmAuthenticationConfiguration(newParent, this.realm);
    }
}

