/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.HashPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.CodePointIterator;

public final class BasicPasswordSpecEncoding {
    private static final byte CLEAR_PASSWORD_SPEC_ID = 1;
    private static final byte DIGEST_PASSWORD_SPEC_ID = 2;
    private static final byte HASH_PASSWORD_SPEC_ID = 3;
    private static final byte SALTED_HASH_PASSWORD_SPEC_ID = 4;
    private static final byte ITERATED_SALTED_HASH_SPEC_ID = 5;

    private BasicPasswordSpecEncoding() {
    }

    public static byte[] encode(PasswordSpec passwordSpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (passwordSpec instanceof ClearPasswordSpec) {
            return BasicPasswordSpecEncoding.encodeClearPasswordSpec((ClearPasswordSpec)passwordSpec);
        }
        if (passwordSpec instanceof DigestPasswordSpec) {
            return BasicPasswordSpecEncoding.encodeDigestPasswordSpec((DigestPasswordSpec)passwordSpec);
        }
        if (passwordSpec instanceof SaltedHashPasswordSpec) {
            return BasicPasswordSpecEncoding.encodeSaltedHashPasswordSpec((SaltedHashPasswordSpec)passwordSpec);
        }
        if (passwordSpec instanceof IteratedSaltedHashPasswordSpec) {
            return BasicPasswordSpecEncoding.encodeIteratedSaltedHashSpec((IteratedSaltedHashPasswordSpec)passwordSpec);
        }
        if (passwordSpec instanceof HashPasswordSpec) {
            return BasicPasswordSpecEncoding.encodeHashPasswordSpec((HashPasswordSpec)passwordSpec);
        }
        return null;
    }

    public static byte[] encode(Password password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
        if (passwordFactory.convertibleToKeySpec(password, ClearPasswordSpec.class)) {
            return BasicPasswordSpecEncoding.encodeClearPasswordSpec(passwordFactory.getKeySpec(password, ClearPasswordSpec.class));
        }
        if (passwordFactory.convertibleToKeySpec(password, DigestPasswordSpec.class)) {
            return BasicPasswordSpecEncoding.encodeDigestPasswordSpec(passwordFactory.getKeySpec(password, DigestPasswordSpec.class));
        }
        if (passwordFactory.convertibleToKeySpec(password, SaltedHashPasswordSpec.class)) {
            return BasicPasswordSpecEncoding.encodeSaltedHashPasswordSpec(passwordFactory.getKeySpec(password, SaltedHashPasswordSpec.class));
        }
        if (passwordFactory.convertibleToKeySpec(password, IteratedSaltedHashPasswordSpec.class)) {
            return BasicPasswordSpecEncoding.encodeIteratedSaltedHashSpec(passwordFactory.getKeySpec(password, IteratedSaltedHashPasswordSpec.class));
        }
        if (passwordFactory.convertibleToKeySpec(password, HashPasswordSpec.class)) {
            return BasicPasswordSpecEncoding.encodeHashPasswordSpec(passwordFactory.getKeySpec(password, HashPasswordSpec.class));
        }
        return null;
    }

    public static PasswordSpec decode(byte[] encoded) {
        int identifier;
        ByteIterator iterator = ByteIterator.ofBytes(encoded);
        try {
            identifier = iterator.next();
        }
        catch (Exception e) {
            throw ElytronMessages.log.couldNotObtainKeySpecEncodingIdentifier();
        }
        switch (identifier) {
            case 1: {
                return BasicPasswordSpecEncoding.decodeClearPasswordSpec(iterator);
            }
            case 2: {
                return BasicPasswordSpecEncoding.decodeDigestPasswordSpec(iterator);
            }
            case 3: {
                return BasicPasswordSpecEncoding.decodeHashPasswordSpec(iterator);
            }
            case 4: {
                return BasicPasswordSpecEncoding.decodeSaltedHashPasswordSpec(iterator);
            }
            case 5: {
                return BasicPasswordSpecEncoding.decodeIteratedSaltedHashPasswordSpec(iterator);
            }
        }
        return null;
    }

    private static byte[] encodeIteratedSaltedHashSpec(IteratedSaltedHashPasswordSpec keySpec) throws InvalidKeySpecException {
        byte[] salt = keySpec.getSalt();
        return new ByteStringBuilder().append((byte)5).appendPackedUnsignedBE(keySpec.getIterationCount()).appendPackedUnsignedBE(salt.length).append(salt).append(keySpec.getHash()).toArray();
    }

    private static PasswordSpec decodeIteratedSaltedHashPasswordSpec(ByteIterator iterator) {
        int iterationCount = iterator.getPackedBE32();
        byte[] salt = iterator.drain(iterator.getPackedBE32());
        byte[] hash = iterator.drain();
        return new IteratedSaltedHashPasswordSpec(hash, salt, iterationCount);
    }

    private static byte[] encodeSaltedHashPasswordSpec(SaltedHashPasswordSpec keySpec) throws InvalidKeySpecException {
        byte[] salt = keySpec.getSalt();
        return new ByteStringBuilder().append((byte)4).appendPackedUnsignedBE(salt.length).append(salt).append(keySpec.getHash()).toArray();
    }

    private static PasswordSpec decodeSaltedHashPasswordSpec(ByteIterator iterator) {
        byte[] salt = iterator.drain(iterator.getPackedBE32());
        byte[] hash = iterator.drain();
        return new SaltedHashPasswordSpec(hash, salt);
    }

    private static byte[] encodeHashPasswordSpec(HashPasswordSpec keySpec) throws InvalidKeySpecException {
        return new ByteStringBuilder().append((byte)3).append(keySpec.getDigest()).toArray();
    }

    private static PasswordSpec decodeHashPasswordSpec(ByteIterator iterator) {
        return new HashPasswordSpec(iterator.drain());
    }

    private static byte[] encodeDigestPasswordSpec(DigestPasswordSpec keySpec) throws InvalidKeySpecException {
        byte[] u = keySpec.getUsername().getBytes(StandardCharsets.UTF_8);
        byte[] r = keySpec.getRealm().getBytes(StandardCharsets.UTF_8);
        return new ByteStringBuilder().append((byte)2).appendPackedUnsignedBE(u.length).append(u).appendPackedUnsignedBE(r.length).append(r).append(keySpec.getDigest()).toArray();
    }

    private static PasswordSpec decodeDigestPasswordSpec(ByteIterator iterator) {
        String username = iterator.drainToUtf8(iterator.getPackedBE32());
        String realm = iterator.drainToUtf8(iterator.getPackedBE32());
        byte[] digest = iterator.drain();
        return new DigestPasswordSpec(username, realm, digest);
    }

    private static byte[] encodeClearPasswordSpec(ClearPasswordSpec keySpec) throws InvalidKeySpecException {
        byte[] passwordBytes = CodePointIterator.ofChars(keySpec.getEncodedPassword()).asUtf8().drain();
        return new ByteStringBuilder().append((byte)1).append(passwordBytes).toArray();
    }

    private static PasswordSpec decodeClearPasswordSpec(ByteIterator iterator) {
        return new ClearPasswordSpec(iterator.asUtf8String().drainToString().toCharArray());
    }
}

