/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.sasl.digest.AbstractDigestMechanism;
import org.wildfly.security.sasl.digest.SaslQuote;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.util.ByteStringBuilder;

class DigestSaslServer
extends AbstractDigestMechanism
implements SaslServer {
    private final MessageDigest messageDigest;
    private static final byte STEP_ONE = 1;
    private static final byte STEP_THREE = 3;
    private String[] realms;
    private String supportedCiphers;
    private int receivingMaxBuffSize = 65536;
    private String[] qops;
    private int nonceCount = -1;

    DigestSaslServer(String[] realms, String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, Charset charset, String[] qops, String[] ciphers) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler, AbstractDigestMechanism.FORMAT.SERVER, charset, ciphers);
        this.realms = realms;
        this.supportedCiphers = DigestSaslServer.getSupportedCiphers(ciphers);
        this.qops = qops;
        try {
            this.messageDigest = MessageDigest.getInstance(DigestUtil.messageDigestAlgorithm(mechanismName));
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.saslMacAlgorithmNotSupported(this.getMechanismName(), e);
        }
    }

    private byte[] generateChallenge() {
        ByteStringBuilder challenge = new ByteStringBuilder();
        StringBuilder sb = new StringBuilder();
        for (String realm : this.realms) {
            sb.append("realm=\"").append(SaslQuote.quote(realm)).append("\"").append(',');
        }
        challenge.append(sb.toString().getBytes(this.getCharset()));
        assert (this.nonce == null);
        this.nonce = DigestSaslServer.generateNonce();
        challenge.append("nonce=\"");
        challenge.append(SaslQuote.quote(this.nonce));
        challenge.append("\"").append(',');
        if (this.qops != null) {
            challenge.append("qop=\"");
            boolean first = true;
            for (String qop : this.qops) {
                if (!first) {
                    challenge.append(',');
                }
                first = false;
                challenge.append(SaslQuote.quote(qop));
            }
            challenge.append("\"").append(',');
        }
        if (this.receivingMaxBuffSize != 65536) {
            challenge.append("maxbuf=");
            challenge.append(String.valueOf(this.receivingMaxBuffSize));
            challenge.append(',');
        }
        if (StandardCharsets.UTF_8.equals(this.getCharset())) {
            challenge.append("charset=");
            challenge.append("utf-8");
            challenge.append(',');
        }
        if (this.supportedCiphers != null && this.qops != null && this.arrayContains(this.qops, "auth-conf")) {
            challenge.append("cipher=\"");
            challenge.append(this.supportedCiphers);
            challenge.append("\"").append(',');
        }
        challenge.append("algorithm=md5-sess");
        return challenge.toArray();
    }

    private void noteDigestResponseData(HashMap<String, byte[]> parsedDigestResponse) {
        byte[] data = parsedDigestResponse.get("nc");
        this.nonceCount = data != null ? Integer.parseInt(new String(data, StandardCharsets.UTF_8)) : -1;
        data = parsedDigestResponse.get("cipher");
        this.cipher = data != null ? new String(data, StandardCharsets.UTF_8) : "";
        data = parsedDigestResponse.get("authzid");
        this.authzid = data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] validateDigestResponse(HashMap<String, byte[]> parsedDigestResponse) throws SaslException {
        byte[] digest_urp;
        AuthorizeCallback authorizeCallback;
        String userName;
        Charset clientCharset;
        block16: {
            if (this.nonceCount != 1) {
                throw ElytronMessages.log.saslNonceCountMustEqual(this.getMechanismName(), 1, this.nonceCount);
            }
            clientCharset = StandardCharsets.ISO_8859_1;
            if (parsedDigestResponse.get("charset") != null) {
                String cCharset = new String(parsedDigestResponse.get("charset"), StandardCharsets.UTF_8);
                if (!cCharset.equals("utf-8")) throw ElytronMessages.log.saslUnknownCharset(this.getMechanismName());
                if (!StandardCharsets.UTF_8.equals(this.getCharset())) throw ElytronMessages.log.saslUnsupportedCharset(this.getMechanismName(), "UTF-8");
                clientCharset = StandardCharsets.UTF_8;
            }
            if (parsedDigestResponse.get("username") == null) {
                throw ElytronMessages.log.saslMissingDirective(this.getMechanismName(), "username");
            }
            userName = new String(parsedDigestResponse.get("username"), clientCharset);
            String clientRealm = parsedDigestResponse.get("realm") != null ? new String(parsedDigestResponse.get("realm"), clientCharset) : "";
            if (!this.arrayContains(this.realms, clientRealm)) {
                throw ElytronMessages.log.saslUnallowedClientRealm(this.getMechanismName(), clientRealm);
            }
            if (parsedDigestResponse.get("nonce") == null) {
                throw ElytronMessages.log.saslMissingDirective(this.getMechanismName(), "nonce");
            }
            byte[] nonceFromClient = parsedDigestResponse.get("nonce");
            if (!Arrays.equals(this.nonce, nonceFromClient)) {
                throw ElytronMessages.log.saslNoncesDoNotMatch(this.getMechanismName());
            }
            if (parsedDigestResponse.get("cnonce") == null) {
                throw ElytronMessages.log.saslMissingDirective(this.getMechanismName(), "cnonce");
            }
            this.cnonce = parsedDigestResponse.get("cnonce");
            if (parsedDigestResponse.get("nc") == null) {
                throw ElytronMessages.log.saslMissingDirective(this.getMechanismName(), "nc");
            }
            if (parsedDigestResponse.get("digest-uri") == null) throw ElytronMessages.log.saslMissingDirective(this.getMechanismName(), "digest-uri");
            String clientDigestURI = new String(parsedDigestResponse.get("digest-uri"), clientCharset);
            if (!clientDigestURI.equalsIgnoreCase(this.digestURI)) {
                throw ElytronMessages.log.saslMismatchedWrongDigestUri(this.getMechanismName(), clientDigestURI, this.digestURI);
            }
            this.qop = "auth";
            if (parsedDigestResponse.get("qop") != null) {
                this.qop = new String(parsedDigestResponse.get("qop"), clientCharset);
                if (!this.arrayContains(DigestUtil.QOP_VALUES, this.qop)) {
                    throw ElytronMessages.log.saslUnexpectedQop(this.getMechanismName(), this.qop);
                }
                if (this.qop != null && !this.qop.equals("auth")) {
                    this.setWrapper(new AbstractDigestMechanism.DigestWrapper(this.qop.equals("auth-conf")));
                }
            }
            NameCallback nameCallback = new NameCallback("User name", userName);
            CredentialCallback credentialCallback = new CredentialCallback(Collections.singletonMap(DigestPassword.class, Collections.singleton(this.passwordAlgorithm(this.getMechanismName()))));
            PasswordCallback passwordCallback = new PasswordCallback("User password", false);
            RealmCallback realmCallback = new RealmCallback("User realm", clientRealm);
            authorizeCallback = new AuthorizeCallback(userName, this.authzid == null ? userName : this.authzid);
            try {
                this.tryHandleCallbacks(realmCallback, nameCallback, credentialCallback, authorizeCallback);
                DigestPassword password = (DigestPassword)credentialCallback.getCredential();
                digest_urp = password.getDigest();
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() != credentialCallback) throw ElytronMessages.log.saslCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e);
                this.handleCallbacks(realmCallback, nameCallback, passwordCallback, authorizeCallback);
                char[] clearPassword = passwordCallback.getPassword();
                passwordCallback.clearPassword();
                digest_urp = DigestUtil.userRealmPasswordDigest(this.messageDigest, userName, clientRealm, clearPassword);
                if (clearPassword == null) break block16;
                Arrays.fill(clearPassword, '\u0000');
            }
        }
        if (digest_urp == null) {
            throw ElytronMessages.log.saslNotProvidedPreDigested(this.getMechanismName());
        }
        this.hA1 = DigestUtil.H_A1(this.messageDigest, digest_urp, this.nonce, this.cnonce, this.authzid, clientCharset);
        byte[] expectedResponse = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authzid, this.qop, this.digestURI, true);
        this.createCiphersAndKeys();
        if (parsedDigestResponse.get("response") == null) throw ElytronMessages.log.saslMissingDirective(this.getMechanismName(), "response");
        if (!Arrays.equals(expectedResponse, parsedDigestResponse.get("response"))) throw ElytronMessages.log.saslAuthenticationRejectedInvalidProof(this.getMechanismName());
        if (!authorizeCallback.isAuthorized()) {
            throw ElytronMessages.log.saslAuthorizationFailed(this.getMechanismName(), userName, this.authzid);
        }
        this.authzid = authorizeCallback.getAuthorizedID();
        return this.createResponseAuth(parsedDigestResponse);
    }

    private String passwordAlgorithm(String mechanismName) {
        switch (mechanismName) {
            case "DIGEST-SHA": {
                return "digest-sha";
            }
            case "DIGEST-SHA-256": {
                return "digest-sha-256";
            }
            case "DIGEST-SHA-384": {
                return "digest-sha-384";
            }
            case "DIGEST-SHA-512": {
                return "digest-sha-512";
            }
            case "DIGEST-MD5": {
                return "digest-md5";
            }
        }
        throw Assert.impossibleSwitchCase((Object)mechanismName);
    }

    private byte[] createResponseAuth(HashMap<String, byte[]> parsedDigestResponse) {
        ByteStringBuilder responseAuth = new ByteStringBuilder();
        responseAuth.append("rspauth=");
        byte[] response_value = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authzid, this.qop, this.digestURI, false);
        responseAuth.append(response_value);
        return responseAuth.toArray();
    }

    @Override
    public String getAuthorizationID() {
        return this.authzid;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.evaluateMessage(response);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message != null && message.length != 0) {
                    throw ElytronMessages.log.saslInitialChallengeMustBeEmpty(this.getMechanismName());
                }
                this.setNegotiationState(3);
                return this.generateChallenge();
            }
            case 3: {
                if (message == null || message.length == 0) {
                    throw ElytronMessages.log.saslClientRefusesToInitiateAuthentication(this.getMechanismName());
                }
                HashMap<String, byte[]> parsedDigestResponse = this.parseResponse(message);
                this.noteDigestResponseData(parsedDigestResponse);
                byte[] response = this.validateDigestResponse(parsedDigestResponse);
                this.negotiationComplete();
                return response;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

