/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.KeyTypeCallback;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.auth.callback.VerifyPeerTrustedCallback;
import org.wildfly.security.sasl.entity.Entity;
import org.wildfly.security.sasl.entity.EntityUtil;
import org.wildfly.security.sasl.entity.GeneralName;
import org.wildfly.security.sasl.entity.TrustedAuthority;
import org.wildfly.security.sasl.util.AbstractSaslClient;
import org.wildfly.security.util.ByteStringBuilder;

final class EntitySaslClient
extends AbstractSaslClient {
    private static final int ST_CHALLENGE_RESPONSE = 1;
    private static final int ST_RESPONSE_SENT = 2;
    private final SecureRandom secureRandom;
    private final Signature signature;
    private final boolean mutual;
    private final String serverName;
    private byte[] randomA;
    private byte[] randomB;
    private X509Certificate[] clientCertChain;
    private String clientCertUrl;

    EntitySaslClient(String mechanismName, boolean mutual, Signature signature, SecureRandom secureRandom, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId, Map<String, ?> props) {
        super(mechanismName, protocol, serverName, callbackHandler, authorizationId, false);
        this.signature = signature;
        this.secureRandom = secureRandom;
        this.mutual = mutual;
        this.serverName = serverName;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] challenge) throws SaslException {
        switch (state) {
            case 1: {
                DERDecoder decoder = new DERDecoder(challenge);
                List<TrustedAuthority> trustedAuthorities = null;
                ArrayList<GeneralName> entityB = null;
                try {
                    decoder.startSequence();
                    this.randomB = decoder.decodeOctetString();
                    if (this.serverName != null && !this.serverName.isEmpty()) {
                        entityB = new ArrayList<GeneralName>(1);
                        entityB.add(new GeneralName.DNSName(this.serverName));
                    }
                    if (decoder.isNextType(128, 0, true)) {
                        decoder.decodeImplicit(0);
                        List<GeneralName> decodedEntityB = EntityUtil.decodeGeneralNames(decoder);
                        if (entityB != null && !EntityUtil.matchGeneralNames(decodedEntityB, entityB)) {
                            throw ElytronMessages.log.saslServerIdentifierMismatch(this.getMechanismName());
                        }
                    }
                    if (decoder.isNextType(128, 1, true)) {
                        decoder.decodeImplicit(1);
                        trustedAuthorities = EntityUtil.decodeTrustedAuthorities(decoder);
                    }
                    decoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.saslInvalidServerMessageWithCause(this.getMechanismName(), e);
                }
                ByteStringBuilder tokenAB = new ByteStringBuilder();
                DEREncoder encoder = new DEREncoder(tokenAB);
                try {
                    byte[] signatureBytes;
                    PrivateKey privateKey;
                    encoder.startSequence();
                    this.randomA = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    if (entityB != null) {
                        encoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(encoder, entityB);
                    }
                    encoder.startExplicit(1);
                    KeyTypeCallback keyTypeCallback = new KeyTypeCallback(Entity.keyType(this.signature.getAlgorithm()));
                    TrustedAuthoritiesCallback trustedAuthoritiesCallback = new TrustedAuthoritiesCallback();
                    trustedAuthoritiesCallback.setTrustedAuthorities(trustedAuthorities);
                    CredentialCallback credentialCallback = new CredentialCallback(Collections.singletonMap(X509Certificate[].class, Collections.emptySet()));
                    CredentialCallback privateKeyCallback = new CredentialCallback(Collections.singletonMap(PrivateKey.class, Collections.emptySet()));
                    this.handleCallbacks(keyTypeCallback, trustedAuthoritiesCallback, credentialCallback, privateKeyCallback);
                    this.clientCertChain = (X509Certificate[])credentialCallback.getCredential();
                    if (this.clientCertChain != null && this.clientCertChain.length > 0) {
                        EntityUtil.encodeX509CertificateChain(encoder, this.clientCertChain);
                    } else {
                        credentialCallback = new CredentialCallback(Collections.singletonMap(String.class, Collections.emptySet()));
                        this.handleCallbacks(keyTypeCallback, trustedAuthoritiesCallback, credentialCallback, privateKeyCallback);
                        this.clientCertUrl = (String)credentialCallback.getCredential();
                        if (this.clientCertUrl == null) {
                            throw ElytronMessages.log.saslCallbackHandlerNotProvidedClientCertificate(this.getMechanismName());
                        }
                        encoder.encodeIA5String(this.clientCertUrl);
                    }
                    encoder.endExplicit();
                    String authorizationId = this.getAuthorizationId();
                    ArrayList<GeneralName> authId = null;
                    if (authorizationId != null) {
                        encoder.encodeImplicit(2);
                        authId = new ArrayList<GeneralName>(1);
                        authId.add(new GeneralName.DirectoryName(authorizationId));
                        EntityUtil.encodeGeneralNames(encoder, authId);
                    }
                    if ((privateKey = (PrivateKey)privateKeyCallback.getCredential()) == null) {
                        throw ElytronMessages.log.saslCallbackHandlerNotProvidedPrivateKey(this.getMechanismName());
                    }
                    ByteStringBuilder tbsDataAB = new ByteStringBuilder();
                    DEREncoder tbsEncoder = new DEREncoder(tbsDataAB);
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(this.randomA);
                    tbsEncoder.encodeOctetString(this.randomB);
                    if (entityB != null) {
                        tbsEncoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(tbsEncoder, entityB);
                    }
                    if (authId != null) {
                        tbsEncoder.encodeImplicit(1);
                        EntityUtil.encodeGeneralNames(tbsEncoder, authId);
                    }
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initSign(privateKey);
                        this.signature.update(tbsDataAB.toArray());
                        signatureBytes = this.signature.sign();
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.log.saslUnableToCreateSignature(this.getMechanismName(), e);
                    }
                    encoder.startSequence();
                    EntityUtil.encodeAlgorithmIdentifier(encoder, this.signature.getAlgorithm());
                    encoder.encodeBitString(signatureBytes);
                    encoder.endSequence();
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.saslUnableToCreateResponseToken(this.getMechanismName(), e);
                }
                this.setNegotiationState(2);
                return tokenAB.toArray();
            }
            case 2: {
                if (this.mutual) {
                    DERDecoder decoder = new DERDecoder(challenge);
                    List<GeneralName> entityA = null;
                    try {
                        decoder.startSequence();
                        byte[] randomC = decoder.decodeOctetString();
                        if (decoder.isNextType(128, 0, true)) {
                            decoder.decodeImplicit(0);
                            entityA = EntityUtil.decodeGeneralNames(decoder);
                            if (!EntityUtil.matchGeneralNames(entityA, this.getClientCertificate())) {
                                throw ElytronMessages.log.saslClientIdentifierMismatch(this.getMechanismName());
                            }
                        }
                        decoder.startExplicit(1);
                        X509Certificate[] serverCertChain = EntityUtil.decodeCertificateData(decoder);
                        decoder.endExplicit();
                        X509Certificate serverCert = serverCertChain[0];
                        VerifyPeerTrustedCallback verifyPeerTrustedCallback = new VerifyPeerTrustedCallback(serverCertChain, serverCert.getPublicKey().getAlgorithm());
                        this.handleCallbacks(verifyPeerTrustedCallback);
                        if (!verifyPeerTrustedCallback.isVerified()) {
                            throw ElytronMessages.log.saslServerAuthenticityCannotBeVerified(this.getMechanismName());
                        }
                        decoder.startSequence();
                        decoder.skipElement();
                        byte[] serverSignature = decoder.decodeBitString();
                        decoder.endSequence();
                        ByteStringBuilder tbsDataBA = new ByteStringBuilder();
                        DEREncoder tbsEncoder = new DEREncoder(tbsDataBA);
                        tbsEncoder.startSequence();
                        tbsEncoder.encodeOctetString(this.randomB);
                        tbsEncoder.encodeOctetString(this.randomA);
                        tbsEncoder.encodeOctetString(randomC);
                        if (entityA != null) {
                            EntityUtil.encodeGeneralNames(tbsEncoder, entityA);
                        }
                        tbsEncoder.endSequence();
                        try {
                            this.signature.initVerify(serverCert);
                            this.signature.update(tbsDataBA.toArray());
                            if (!this.signature.verify(serverSignature)) {
                                this.setNegotiationState(-1);
                                throw ElytronMessages.log.saslServerAuthenticityCannotBeVerified(this.getMechanismName());
                            }
                        }
                        catch (InvalidKeyException | SignatureException e) {
                            throw ElytronMessages.log.saslUnableToVerifyServerSignature(this.getMechanismName(), e);
                        }
                        decoder.endSequence();
                    }
                    catch (ASN1Exception e) {
                        throw ElytronMessages.log.saslInvalidServerMessageWithCause(this.getMechanismName(), e);
                    }
                }
                if (challenge != null && challenge.length != 0) {
                    throw ElytronMessages.log.saslServerSentExtraMessage(this.getMechanismName());
                }
                this.negotiationComplete();
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }

    @Override
    public void dispose() throws SaslException {
        this.clientCertChain = null;
        this.clientCertUrl = null;
    }

    private X509Certificate getClientCertificate() throws SaslException {
        if (this.clientCertChain != null && this.clientCertChain.length > 0) {
            return this.clientCertChain[0];
        }
        if (this.clientCertUrl != null) {
            try {
                return EntityUtil.getCertificateFromUrl(this.clientCertUrl);
            }
            catch (IOException e) {
                throw ElytronMessages.log.saslUnableToObtainServerCertificate(this.getMechanismName(), this.clientCertUrl, e);
            }
        }
        throw ElytronMessages.log.saslCallbackHandlerNotProvidedServerCertificate(this.getMechanismName());
    }
}

