/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.Mac;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.scram.ScramSaslServer;

public final class ScramSaslServerFactory
implements SaslServerFactory {
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Mac mac;
        MessageDigest messageDigest;
        boolean plus = false;
        ChannelBindingCallback callback = new ChannelBindingCallback();
        try {
            cbh.handle(new Callback[]{callback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.log.saslFailedToDetermineChannelBindingStatus(e);
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        String bindingType = callback.getBindingType();
        byte[] bindingData = callback.getBindingData();
        boolean bindingOk = bindingType != null && bindingData != null;
        boolean bindingRequired = "true".equals(props.get("wildfly.sasl.channel-binding-required"));
        switch (mechanism) {
            case "SCRAM-SHA-1-PLUS": {
                if (!bindingOk) {
                    return null;
                }
                plus = true;
            }
            case "SCRAM-SHA-1": {
                if (bindingRequired && !plus) {
                    return null;
                }
                try {
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    mac = Mac.getInstance("HmacSHA1");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
            }
            case "SCRAM-SHA-256-PLUS": {
                if (!bindingOk) {
                    return null;
                }
                plus = true;
            }
            case "SCRAM-SHA-256": {
                if (bindingRequired && !plus) {
                    return null;
                }
                try {
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    mac = Mac.getInstance("HmacSHA256");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
            }
            case "SCRAM-SHA-384-PLUS": {
                if (!bindingOk) {
                    return null;
                }
                plus = true;
            }
            case "SCRAM-SHA-384": {
                if (bindingRequired && !plus) {
                    return null;
                }
                try {
                    messageDigest = MessageDigest.getInstance("SHA-384");
                    mac = Mac.getInstance("HmacSHA384");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
            }
            case "SCRAM-SHA-512-PLUS": {
                if (!bindingOk) {
                    return null;
                }
                plus = true;
            }
            case "SCRAM-SHA-512": {
                if (bindingRequired && !plus) {
                    return null;
                }
                try {
                    messageDigest = MessageDigest.getInstance("SHA-512");
                    mac = Mac.getInstance("HmacSHA512");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
            }
            default: {
                return null;
            }
        }
        Object propVal = props.get("wildfly.sasl.secure-rng");
        String rngName = propVal instanceof String ? (String)propVal : null;
        SecureRandom secureRandom = null;
        if (rngName != null) {
            try {
                secureRandom = SecureRandom.getInstance(rngName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        ScramSaslServer server = new ScramSaslServer(mechanism, protocol, serverName, cbh, plus, props, messageDigest, mac, secureRandom, bindingType, bindingData);
        server.init();
        return server;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (!"true".equals(props.get("wildfly.sasl.mechanism-query-all")) && "true".equals(props.get("wildfly.sasl.channel-binding-required"))) {
            return new String[]{"SCRAM-SHA-1-PLUS", "SCRAM-SHA-256-PLUS", "SCRAM-SHA-384-PLUS", "SCRAM-SHA-512-PLUS"};
        }
        return new String[]{"SCRAM-SHA-1", "SCRAM-SHA-1-PLUS", "SCRAM-SHA-256", "SCRAM-SHA-256-PLUS", "SCRAM-SHA-384", "SCRAM-SHA-384-PLUS", "SCRAM-SHA-512", "SCRAM-SHA-512-PLUS"};
    }
}

