/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.DeltaCompositeKeyUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(TxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private PartitionHandlingManager partitionHandlingManager;
    private boolean isPessimisticCache;
    private boolean useClusteredWriteSkewCheck;

    @Inject
    public void inject(PartitionHandlingManager partitionHandlingManager) {
        this.partitionHandlingManager = partitionHandlingManager;
    }

    @Start
    public void start() {
        this.isPessimisticCache = this.cacheConfiguration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.useClusteredWriteSkewCheck = Configurations.isVersioningEnabled(this.cacheConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            Object object = this.handleTxWriteCommand(ctx, command, command.getKey(), false);
            if (ctx.isOriginLocal()) {
                command.setValueMatcher(command.isSuccessful() ? ValueMatcher.MATCH_ALWAYS : ValueMatcher.MATCH_NEVER);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (ctx.isOriginLocal()) {
                command.setValueMatcher(command.isSuccessful() ? ValueMatcher.MATCH_ALWAYS : ValueMatcher.MATCH_NEVER);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            Object object = this.handleTxWriteCommand(ctx, command, command.getKey(), false);
            if (ctx.isOriginLocal()) {
                command.setValueMatcher(command.isSuccessful() ? ValueMatcher.MATCH_ALWAYS : ValueMatcher.MATCH_NEVER);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (ctx.isOriginLocal()) {
                command.setValueMatcher(command.isSuccessful() ? ValueMatcher.MATCH_ALWAYS : ValueMatcher.MATCH_NEVER);
            }
            throw throwable;
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.handleNonTxWriteCommand(ctx, command);
        }
        Object returnValue = this.handleTxWriteCommand(ctx, command, command.getKey(), command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER));
        if (ctx.isOriginLocal()) {
            command.setValueMatcher(command.isSuccessful() ? ValueMatcher.MATCH_ALWAYS : ValueMatcher.MATCH_NEVER);
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleTxWriteCommand(ctx, command, null, true);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            return this.visitGetCommand(ctx, command, false);
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        try {
            return this.visitGetCommand(ctx, command, false);
        }
        catch (SuspectException e) {
            return this.visitGetCacheEntryCommand(ctx, command);
        }
    }

    private Object visitGetCommand(InvocationContext ctx, AbstractDataCommand command, boolean isGetCacheEntry) throws Throwable {
        boolean skipRemoteGet;
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        boolean bl = skipRemoteGet = entry != null && entry.skipLookup();
        if (!skipRemoteGet && returnValue == null && ctx.isOriginLocal()) {
            InternalCacheEntry ice;
            Object key = DeltaCompositeKeyUtil.filterDeltaCompositeKey(command.getKey());
            if (this.needsRemoteGet(ctx, command) && (ice = this.remoteGet(ctx, key, false, command)) != null) {
                returnValue = ice.getValue();
            }
            if (returnValue == null && !ctx.isEntryRemovedInContext(command.getKey())) {
                returnValue = this.localGet(ctx, key, false, command, isGetCacheEntry);
            }
        }
        return returnValue;
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            List<Address> affectedNodes = this.cdl.getOwners(DeltaCompositeKeyUtil.filterDeltaCompositeKeys(command.getKeys()));
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(affectedNodes == null ? this.dm.getConsistentHash().getMembers() : affectedNodes);
            log.tracef("Registered remote locks acquired %s", affectedNodes);
            RpcOptions rpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE).build();
            Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(affectedNodes, command, rpcOptions);
            this.checkTxCommandResponses(responseMap, command, (LocalTxInvocationContext)ctx, ((LocalTxInvocationContext)ctx).getRemoteLocksAcquired());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            Collection<Address> recipients = this.getCommitNodes(ctx);
            Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(recipients, command, this.createCommitRpcOptions());
            this.checkTxCommandResponses(responseMap, command, (LocalTxInvocationContext)ctx, recipients);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            List<Address> recipients = this.cdl.getOwners(DeltaCompositeKeyUtil.getAffectedKeysFromContext(ctx));
            this.prepareOnAffectedNodes(ctx, command, recipients);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(recipients == null ? this.dm.getWriteConsistentHash().getMembers() : recipients);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareOnAffectedNodes(TxInvocationContext<?> ctx, PrepareCommand command, Collection<Address> recipients) {
        try {
            Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(recipients, command, this.createPrepareRpcOptions());
            this.checkTxCommandResponses(responseMap, command, (LocalTxInvocationContext)ctx, recipients);
        }
        finally {
            TxDistributionInterceptor.transactionRemotelyPrepared(ctx);
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            Collection<Address> recipients = this.getCommitNodes(ctx);
            Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(recipients, command, this.createRollbackRpcOptions());
            this.checkTxCommandResponses(responseMap, command, (LocalTxInvocationContext)ctx, recipients);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Collection<Address> getCommitNodes(TxInvocationContext ctx) {
        LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
        List<Address> affectedNodes = this.cdl.getOwners(DeltaCompositeKeyUtil.getAffectedKeysFromContext(ctx));
        List<Address> members = this.dm.getConsistentHash().getMembers();
        return localTx.getCommitNodes(affectedNodes, this.rpcManager.getTopologyId(), members);
    }

    protected void checkTxCommandResponses(Map<Address, Response> responseMap, TransactionBoundaryCommand command, LocalTxInvocationContext context, Collection<Address> recipients) {
        OutdatedTopologyException outdatedTopologyException = null;
        for (Map.Entry<Address, Response> e : responseMap.entrySet()) {
            Address recipient = e.getKey();
            Response response = e.getValue();
            if (response == CacheNotFoundResponse.INSTANCE) {
                if (command.getTopologyId() == this.stateTransferManager.getCacheTopology().getTopologyId() && !this.rpcManager.getMembers().contains(recipient)) {
                    if (!trace) continue;
                    log.tracef("Ignoring response from node not targeted %s", recipient);
                    continue;
                }
                if (this.checkCacheNotFoundResponseInPartitionHandling(command, context, recipients)) {
                    if (trace) {
                        log.tracef("Cache not running on node %s, or the node is missing. It will be handled by the PartitionHandlingManager", recipient);
                    }
                    return;
                }
                if (trace) {
                    log.tracef("Cache not running on node %s, or the node is missing", recipient);
                }
                outdatedTopologyException = new OutdatedTopologyException(String.format("Cache not running on node %s, or the node is missing", recipient));
                continue;
            }
            if (response != UnsureResponse.INSTANCE) continue;
            if (trace) {
                log.tracef("Node %s has a newer topology id", recipient);
            }
            outdatedTopologyException = new OutdatedTopologyException(String.format("Node %s has a newer topology id", recipient));
        }
        if (outdatedTopologyException != null) {
            throw outdatedTopologyException;
        }
    }

    private boolean checkCacheNotFoundResponseInPartitionHandling(TransactionBoundaryCommand command, LocalTxInvocationContext context, Collection<Address> recipients) {
        GlobalTransaction globalTransaction = command.getGlobalTransaction();
        Set<Object> lockedKeys = context.getLockedKeys();
        if (command instanceof RollbackCommand) {
            return this.partitionHandlingManager.addPartialRollbackTransaction(globalTransaction, recipients, lockedKeys);
        }
        if (command instanceof PrepareCommand) {
            if (((PrepareCommand)command).isOnePhaseCommit()) {
                return this.partitionHandlingManager.addPartialCommit1PCTransaction(globalTransaction, recipients, lockedKeys, Arrays.asList(((PrepareCommand)command).getModifications()));
            }
        } else if (command instanceof CommitCommand) {
            EntryVersionsMap newVersion = null;
            if (command instanceof VersionedCommitCommand) {
                newVersion = ((VersionedCommitCommand)command).getUpdatedVersions();
            }
            return this.partitionHandlingManager.addPartialCommit2PCTransaction(globalTransaction, recipients, lockedKeys, newVersion);
        }
        return false;
    }

    private boolean shouldFetchRemoteValuesForWriteSkewCheck(InvocationContext ctx, WriteCommand cmd) {
        if (this.useClusteredWriteSkewCheck && ctx.isInTxScope() && this.dm.isRehashInProgress()) {
            for (Object key : cmd.getAffectedKeys()) {
                boolean shouldPerformWriteSkewCheck = this.cdl.localNodeIsPrimaryOwner(key);
                if (!shouldPerformWriteSkewCheck || !this.dm.isAffectedByRehash(key) || this.dataContainer.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    private Object handleTxWriteCommand(InvocationContext ctx, WriteCommand command, Object key, boolean skipRemoteGet) throws Throwable {
        if (!skipRemoteGet && this.needValuesFromPreviousOwners(ctx, command)) {
            this.remoteGetBeforeWrite(ctx, command, key);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected boolean needValuesFromPreviousOwners(InvocationContext ctx, WriteCommand command) {
        if (ctx.isOriginLocal() && (this.isNeedReliableReturnValues(command) || command.isConditional())) {
            return true;
        }
        return !command.hasFlag(Flag.CACHE_MODE_LOCAL) && (this.shouldFetchRemoteValuesForWriteSkewCheck(ctx, command) || command.hasFlag(Flag.DELTA_WRITE));
    }

    private Object localGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command, boolean isGetCacheEntry) throws Throwable {
        InternalCacheEntry ice = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key);
        if (ice != null) {
            if (isWrite && this.isPessimisticCache && ctx.isInTxScope()) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (!ctx.replaceValue(key, ice)) {
                if (isWrite) {
                    this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command, false);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return isGetCacheEntry ? ice : ice.getValue();
        }
        return null;
    }

    @Override
    protected void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, Object key) throws Throwable {
        boolean skipRemoteGet;
        CacheEntry entry = ctx.lookupEntry(key);
        boolean bl = skipRemoteGet = entry != null && entry.skipLookup();
        if (skipRemoteGet) {
            return;
        }
        InternalCacheEntry ice = this.remoteGet(ctx, key, true, command);
        if (ice == null) {
            this.localGet(ctx, key, true, command, false);
        }
    }

    private InternalCacheEntry remoteGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isValueAvailableLocally(this.dm.getReadConsistentHash(), key) || this.dm.isAffectedByRehash(key) && !this.dataContainer.containsKey(key)) {
            if (trace) {
                log.tracef("Doing a remote get for key %s", key);
            }
            boolean acquireRemoteLock = false;
            if (ctx.isInTxScope() && ctx.isOriginLocal()) {
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                acquireRemoteLock = isWrite && this.isPessimisticCache && !txContext.getAffectedKeys().contains(key);
            }
            InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, acquireRemoteLock, command, isWrite);
            if (acquireRemoteLock) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (ice != null) {
                if (this.useClusteredWriteSkewCheck && ctx.isInTxScope()) {
                    ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).putLookedUpRemoteVersion(key, ice.getMetadata().version());
                }
                if (!ctx.replaceValue(key, ice)) {
                    if (isWrite) {
                        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command, false);
                    } else {
                        ctx.putLookedUpEntry(key, ice);
                        if (ctx.isInTxScope()) {
                            ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).replaceVersionRead(key, ice.getMetadata().version());
                        }
                    }
                }
                return ice;
            }
        } else if (trace) {
            log.tracef("Not doing a remote get for key %s since entry is mapped to current node (%s), or is in L1. Owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
        }
        return null;
    }

    private RpcOptions createCommitRpcOptions() {
        return this.createRpcOptionsFor2ndPhase(this.cacheConfiguration.transaction().syncCommitPhase());
    }

    private RpcOptions createRollbackRpcOptions() {
        return this.createRpcOptionsFor2ndPhase(this.cacheConfiguration.transaction().syncRollbackPhase());
    }

    private RpcOptions createRpcOptionsFor2ndPhase(boolean sync) {
        if (sync) {
            return this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE).build();
        }
        return this.rpcManager.getRpcOptionsBuilder(ResponseMode.ASYNCHRONOUS, DeliverOrder.NONE).build();
    }

    protected RpcOptions createPrepareRpcOptions() {
        return this.cacheConfiguration.clustering().cacheMode().isSynchronous() ? this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE).build() : this.rpcManager.getDefaultRpcOptions(false);
    }
}

