/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import java.util.List;
import java.util.Locale;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdBagCollectionType;
import org.hibernate.boot.model.source.internal.hbm.AbstractPluralAttributeSourceImpl;
import org.hibernate.boot.model.source.internal.hbm.Helper;
import org.hibernate.boot.model.source.internal.hbm.HibernateTypeSourceImpl;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.internal.hbm.RelationalValueSourceHelper;
import org.hibernate.boot.model.source.internal.hbm.XmlElementMetadata;
import org.hibernate.boot.model.source.spi.AttributeSourceContainer;
import org.hibernate.boot.model.source.spi.CollectionIdSource;
import org.hibernate.boot.model.source.spi.ColumnSource;
import org.hibernate.boot.model.source.spi.Orderable;
import org.hibernate.boot.model.source.spi.PluralAttributeNature;
import org.hibernate.boot.model.source.spi.RelationalValueSource;
import org.hibernate.boot.model.source.spi.SizeSource;
import org.hibernate.internal.util.StringHelper;

public class PluralAttributeSourceIdBagImpl
extends AbstractPluralAttributeSourceImpl
implements Orderable {
    private final JaxbHbmIdBagCollectionType idBagMapping;
    private final CollectionIdSource collectionIdSource;

    public PluralAttributeSourceIdBagImpl(MappingDocument mappingDocument, final JaxbHbmIdBagCollectionType idBagMapping, AttributeSourceContainer container) {
        super(mappingDocument, idBagMapping, container);
        this.idBagMapping = idBagMapping;
        RelationalValueSource collectionIdRelationalValueSource = RelationalValueSourceHelper.buildValueSource(this.sourceMappingDocument(), null, new RelationalValueSourceHelper.AbstractColumnsAndFormulasSource(){

            @Override
            public XmlElementMetadata getSourceType() {
                return XmlElementMetadata.COLLECTION_ID;
            }

            @Override
            public String getSourceName() {
                return null;
            }

            @Override
            public String getColumnAttribute() {
                return idBagMapping.getCollectionId().getColumnAttribute();
            }

            @Override
            public SizeSource getSizeSource() {
                return Helper.interpretSizeSource(idBagMapping.getCollectionId().getLength(), (Integer)null, null);
            }

            @Override
            public List getColumnOrFormulaElements() {
                return idBagMapping.getCollectionId().getColumn();
            }
        });
        if (!ColumnSource.class.isInstance(collectionIdRelationalValueSource)) {
            throw new MappingException(String.format(Locale.ENGLISH, "Expecting column for collection id (idbag), but found formula [%s.%s]", container.getAttributeRoleBase().getFullPath(), idBagMapping.getName()), this.sourceMappingDocument().getOrigin());
        }
        this.collectionIdSource = new CollectionIdSourceImpl((ColumnSource)collectionIdRelationalValueSource, new HibernateTypeSourceImpl(idBagMapping.getCollectionId().getType()), idBagMapping.getCollectionId().getGenerator().getClazz());
    }

    @Override
    public PluralAttributeNature getNature() {
        return PluralAttributeNature.ID_BAG;
    }

    @Override
    public CollectionIdSource getCollectionIdSource() {
        return this.collectionIdSource;
    }

    @Override
    public boolean isOrdered() {
        return StringHelper.isNotEmpty(this.getOrder());
    }

    @Override
    public String getOrder() {
        return this.idBagMapping.getOrderBy();
    }

    @Override
    public XmlElementMetadata getSourceType() {
        return XmlElementMetadata.ID_BAG;
    }

    @Override
    public String getXmlNodeName() {
        return this.idBagMapping.getNode();
    }

    private static class CollectionIdSourceImpl
    implements CollectionIdSource {
        private final ColumnSource columnSource;
        private final HibernateTypeSourceImpl typeSource;
        private final String generator;

        public CollectionIdSourceImpl(ColumnSource columnSource, HibernateTypeSourceImpl typeSource, String generator) {
            this.columnSource = columnSource;
            this.typeSource = typeSource;
            this.generator = generator;
        }

        @Override
        public ColumnSource getColumnSource() {
            return this.columnSource;
        }

        @Override
        public HibernateTypeSourceImpl getTypeInformation() {
            return this.typeSource;
        }

        @Override
        public String getGeneratorName() {
            return this.generator;
        }
    }
}

