/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class WebMigrateOperation
implements OperationStepHandler {
    private static final String UNDERTOW_EXTENSION = "org.wildfly.extension.undertow";
    private static final String IO_EXTENSION = "org.wildfly.extension.io";
    private static final String REALM_NAME = "jbossweb-migration-security-realm";
    private static final OperationStepHandler DESCRIBE_MIGRATION_INSTANCE = new WebMigrateOperation(true);
    private static final OperationStepHandler MIGRATE_INSTANCE = new WebMigrateOperation(false);
    public static final PathElement DEFAULT_SERVER_PATH = PathElement.pathElement((String)"server", (String)"default");
    private final boolean describe;

    private WebMigrateOperation(boolean describe) {
        this.describe = describe;
    }

    static void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("migrate", resourceDescriptionResolver).setRuntimeOnly().setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).build(), MIGRATE_INSTANCE);
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("describe-migration", resourceDescriptionResolver).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setRuntimeOnly().setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).build(), DESCRIBE_MIGRATION_INSTANCE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.describe && context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw UndertowLogger.ROOT_LOGGER.migrateOperationAllowedOnlyInAdminOnly();
        }
        final ModelNode legacyModelAddOps = new ModelNode();
        final TreeMap<PathAddress, ModelNode> migrationOperations = new TreeMap<PathAddress, ModelNode>(new Comparator<PathAddress>(){

            @Override
            public int compare(PathAddress o1, PathAddress o2) {
                int compare = Integer.compare(o1.size(), o2.size());
                if (compare != 0) {
                    return compare;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        this.describeLegacyWebResources(context, legacyModelAddOps);
        this.addExtension(context, migrationOperations, this.describe, UNDERTOW_EXTENSION);
        this.addExtension(context, migrationOperations, this.describe, IO_EXTENSION);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                WebMigrateOperation.this.addDefaultResources(migrationOperations, legacyModelAddOps);
                WebMigrateOperation.this.createIoSubsystem(context, migrationOperations);
                WebMigrateOperation.this.createWelcomeContentHandler(migrationOperations);
                WebMigrateOperation.this.transformResources(context, legacyModelAddOps, migrationOperations);
                WebMigrateOperation.this.removeWebSubsystem(migrationOperations);
                WebMigrateOperation.this.fixAddressesForDomainMode(PathAddress.pathAddress((ModelNode)operation.get("address")), migrationOperations);
                if (WebMigrateOperation.this.describe) {
                    context.getResult().set(migrationOperations.values());
                } else {
                    WebMigrateOperation.this.migrateSubsystems(context, migrationOperations);
                }
            }
        }, OperationContext.Stage.MODEL);
    }

    private SSLInformation createSecurityRealm(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, ModelNode legacyModelAddOps, String connector) {
        ModelNode legacyAddOp = WebMigrateOperation.findResource(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)WebExtension.CONNECTOR_PATH.getKey(), (String)connector), PathElement.pathElement((String)"configuration", (String)"ssl")}), legacyModelAddOps);
        if (legacyAddOp == null) {
            return null;
        }
        int counter = 1;
        String realmName = REALM_NAME + counter;
        boolean ok = false;
        do {
            Resource root;
            if ((root = context.readResourceFromRoot(PathAddress.pathAddress((String)"core-service", (String)"management"), false)).getChildrenNames("security-realm").contains(realmName)) {
                realmName = REALM_NAME + ++counter;
                continue;
            }
            ok = true;
        } while (!ok);
        PathAddress addres = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management"), PathElement.pathElement((String)"security-realm", (String)realmName)});
        migrationOperations.put(addres, Util.createAddOperation((PathAddress)addres));
        ModelNode keyAlias = legacyAddOp.get(WebSSLDefinition.KEY_ALIAS.getName());
        ModelNode password = legacyAddOp.get(WebSSLDefinition.PASSWORD.getName());
        ModelNode certificateKeyFile = legacyAddOp.get(WebSSLDefinition.CERTIFICATE_KEY_FILE.getName());
        ModelNode cipherSuite = legacyAddOp.get(WebSSLDefinition.CIPHER_SUITE.getName());
        ModelNode protocol = legacyAddOp.get(WebSSLDefinition.PROTOCOL.getName());
        ModelNode verifyClient = legacyAddOp.get(WebSSLDefinition.VERIFY_CLIENT.getName());
        ModelNode verifyDepth = legacyAddOp.get(WebSSLDefinition.VERIFY_DEPTH.getName());
        ModelNode certificateFile = legacyAddOp.get(WebSSLDefinition.CERTIFICATE_FILE.getName());
        ModelNode caCertificateFile = legacyAddOp.get(WebSSLDefinition.CA_CERTIFICATE_FILE.getName());
        ModelNode caCertificatePassword = legacyAddOp.get(WebSSLDefinition.CA_CERTIFICATE_PASSWORD.getName());
        ModelNode csRevocationURL = legacyAddOp.get(WebSSLDefinition.CA_REVOCATION_URL.getName());
        ModelNode trustStoreType = legacyAddOp.get(WebSSLDefinition.TRUSTSTORE_TYPE.getName());
        ModelNode keystoreType = legacyAddOp.get(WebSSLDefinition.KEYSTORE_TYPE.getName());
        ModelNode sessionCacheSize = legacyAddOp.get(WebSSLDefinition.SESSION_CACHE_SIZE.getName());
        ModelNode sessionTimeout = legacyAddOp.get(WebSSLDefinition.SESSION_TIMEOUT.getName());
        ModelNode sslProtocol = legacyAddOp.get(WebSSLDefinition.SSL_PROTOCOL.getName());
        addres = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management"), PathElement.pathElement((String)"security-realm", (String)realmName), PathElement.pathElement((String)"authentication", (String)"truststore")});
        ModelNode addOp = Util.createAddOperation((PathAddress)addres);
        addOp.get(KeystoreAttributes.KEYSTORE_PATH.getName()).set(caCertificateFile);
        addOp.get(KeystoreAttributes.KEYSTORE_PASSWORD.getName()).set(caCertificatePassword);
        addOp.get(KeystoreAttributes.KEYSTORE_PROVIDER.getName()).set(trustStoreType);
        migrationOperations.put(addres, addOp);
        addres = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management"), PathElement.pathElement((String)"security-realm", (String)realmName), PathElement.pathElement((String)"server-identity", (String)"ssl")});
        addOp = Util.createAddOperation((PathAddress)addres);
        addOp.get(KeystoreAttributes.KEYSTORE_PATH.getName()).set(certificateKeyFile);
        addOp.get(KeystoreAttributes.KEYSTORE_PASSWORD.getName()).set(password);
        addOp.get(KeystoreAttributes.KEYSTORE_PROVIDER.getName()).set(keystoreType);
        addOp.get(KeystoreAttributes.ALIAS.getName()).set(keyAlias);
        addOp.get("protocol").set(protocol);
        if (verifyDepth.isDefined()) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSLDefinition.VERIFY_DEPTH.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
        }
        if (certificateFile.isDefined()) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSLDefinition.CERTIFICATE_FILE.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
        }
        if (csRevocationURL.isDefined()) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSLDefinition.CA_REVOCATION_URL.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
        }
        migrationOperations.put(addres, addOp);
        return new SSLInformation(realmName, verifyClient, sessionCacheSize, sessionTimeout, sslProtocol, cipherSuite);
    }

    private void fixAddressesForDomainMode(PathAddress migrateAddress, Map<PathAddress, ModelNode> migrationOperations) {
        int i;
        for (i = 0; i < migrateAddress.size() && !migrateAddress.getElement(i).equals(WebExtension.SUBSYSTEM_PATH); ++i) {
        }
        if (i == 0) {
            return;
        }
        PathAddress prefix = migrateAddress.subAddress(0, i);
        HashMap<PathAddress, ModelNode> old = new HashMap<PathAddress, ModelNode>(migrationOperations);
        migrationOperations.clear();
        for (Map.Entry e : old.entrySet()) {
            if (((PathAddress)e.getKey()).getElement(0).getKey().equals("subsystem")) {
                PathAddress oldAddress = PathAddress.pathAddress((ModelNode)((ModelNode)e.getValue()).get("address"));
                ArrayList<PathElement> elements = new ArrayList<PathElement>();
                for (PathElement j : prefix) {
                    elements.add(j);
                }
                for (PathElement j : oldAddress) {
                    elements.add(j);
                }
                PathAddress newAddress = PathAddress.pathAddress(elements);
                ((ModelNode)e.getValue()).get("address").set(newAddress.toModelNode());
                migrationOperations.put(newAddress, (ModelNode)e.getValue());
                continue;
            }
            migrationOperations.put((PathAddress)e.getKey(), (ModelNode)e.getValue());
        }
    }

    private void createIoSubsystem(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) {
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        if (root.getChildrenNames("subsystem").contains("io")) {
            return;
        }
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"io")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"io"), PathElement.pathElement((String)"worker", (String)"default")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"io"), PathElement.pathElement((String)"buffer-pool", (String)"default")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
    }

    private void createWelcomeContentHandler(Map<PathAddress, ModelNode> migrationOperations) {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"configuration", (String)"handler")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"configuration", (String)"handler"), PathElement.pathElement((String)"file", (String)"welcome-content")});
        ModelNode add = Util.createAddOperation((PathAddress)address);
        add.get("path").set(new ModelNode(new ValueExpression("${jboss.home.dir}/welcome-content")));
        migrationOperations.put(address, add);
    }

    private void addDefaultResources(Map<PathAddress, ModelNode> migrationOperations, ModelNode legacyModelDescription) {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), DEFAULT_SERVER_PATH});
        ModelNode add = Util.createAddOperation((PathAddress)address);
        ModelNode defaultSessionTimeout = null;
        ModelNode directoryListing = null;
        ModelNode sendfile = null;
        ModelNode fileEncoding = null;
        ModelNode readOnly = null;
        ModelNode webdav = null;
        ModelNode secret = null;
        ModelNode maxDepth = null;
        ModelNode disabled = null;
        for (ModelNode legacyAddOp : legacyModelDescription.get("result").asList()) {
            PathAddress la = PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"));
            if (la.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH}))) {
                ModelNode sessionTimeout;
                ModelNode defaultHost = legacyAddOp.get(WebDefinition.DEFAULT_VIRTUAL_SERVER.getName());
                if (defaultHost.isDefined()) {
                    add.get("default-host").set(defaultHost.clone());
                }
                if (!(sessionTimeout = legacyAddOp.get(WebDefinition.DEFAULT_SESSION_TIMEOUT.getName())).isDefined()) continue;
                defaultSessionTimeout = sessionTimeout;
                continue;
            }
            if (!la.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.STATIC_RESOURCES_PATH}))) continue;
            ModelNode node = legacyAddOp.get(WebStaticResources.LISTINGS.getName());
            if (node.isDefined()) {
                directoryListing = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.SENDFILE.getName())).isDefined()) {
                UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.SENDFILE.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
                sendfile = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.FILE_ENCODING.getName())).isDefined()) {
                UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.FILE_ENCODING.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
                fileEncoding = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.READ_ONLY.getName())).isDefined()) {
                UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.READ_ONLY.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
                readOnly = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.WEBDAV.getName())).isDefined()) {
                UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.WEBDAV.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
                webdav = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.SECRET.getName())).isDefined()) {
                UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.SECRET.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
                secret = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.MAX_DEPTH.getName())).isDefined()) {
                UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.MAX_DEPTH.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
                maxDepth = node;
            }
            if (!(node = legacyAddOp.get(WebStaticResources.DISABLED.getName())).isDefined()) continue;
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.DISABLED.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address")));
            disabled = node;
        }
        migrationOperations.put(address, add);
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"servlet-container", (String)"default")});
        add = Util.createAddOperation((PathAddress)address);
        if (defaultSessionTimeout != null) {
            add.get("default-session-timeout").set(defaultSessionTimeout.clone());
        }
        if (directoryListing != null) {
            add.get("directory-listing").set(directoryListing);
        }
        migrationOperations.put(address, add);
    }

    private void addExtension(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, boolean describe, String extension) {
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        if (root.getChildrenNames("extension").contains(extension)) {
            return;
        }
        PathAddress extensionAddress = PathAddress.pathAddress((String)"extension", (String)extension);
        OperationEntry addEntry = context.getRootResourceRegistration().getOperationEntry(extensionAddress, "add");
        ModelNode addOperation = Util.createAddOperation((PathAddress)extensionAddress);
        addOperation.get("module").set(extension);
        if (describe) {
            migrationOperations.put(extensionAddress, addOperation);
        } else {
            context.addStep(context.getResult().get(extensionAddress.toString()), addOperation, addEntry.getOperationHandler(), OperationContext.Stage.MODEL);
        }
    }

    private void removeWebSubsystem(Map<PathAddress, ModelNode> migrationOperations) {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH});
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)subsystemAddress);
        migrationOperations.put(subsystemAddress, removeOperation);
    }

    private void migrateSubsystems(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) {
        ModelNode compositeOp = Util.createOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
        compositeOp.get("steps").set(migrationOperations.values());
        context.addStep(compositeOp, (OperationStepHandler)CompositeOperationHandler.INSTANCE, OperationContext.Stage.MODEL);
    }

    private void transformResources(OperationContext context, ModelNode legacyModelDescription, Map<PathAddress, ModelNode> newAddOperations) throws OperationFailedException {
        for (ModelNode legacyAddOp : legacyModelDescription.get("result").asList()) {
            ModelNode newAddOp = legacyAddOp.clone();
            PathAddress address = PathAddress.pathAddress((ModelNode)newAddOp.get("address"));
            if (address.size() == 1) {
                this.migrateSubsystem(newAddOperations, newAddOp);
                continue;
            }
            if (address.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.STATIC_RESOURCES_PATH}))) continue;
            if (address.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.JSP_CONFIGURATION_PATH}))) {
                this.migrateJSPConfig(newAddOperations, newAddOp);
                continue;
            }
            if (address.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.CONTAINER_PATH}))) {
                this.migrateMimeMapping(newAddOperations, newAddOp);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.CONNECTOR_PATH}))) {
                this.migrateConnector(context, newAddOperations, newAddOp, address, legacyModelDescription);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH}))) {
                this.migrateVirtualHost(newAddOperations, newAddOp, address);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH, WebExtension.ACCESS_LOG_PATH}))) {
                this.migrateAccessLog(newAddOperations, newAddOp, address, legacyModelDescription);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH, WebExtension.ACCESS_LOG_PATH, WebExtension.DIRECTORY_PATH}))) continue;
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH, WebExtension.SSO_PATH}))) {
                this.migrateSso(newAddOperations, newAddOp, address);
                continue;
            }
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(legacyAddOp);
        }
    }

    private void migrateSso(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address) {
        PathAddress newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host", (String)address.getElement(address.size() - 2).getValue()), UndertowExtension.PATH_SSO});
        ModelNode add = Util.createAddOperation((PathAddress)newAddress);
        add.get("domain").set(newAddOp.get(WebSSODefinition.DOMAIN.getName()).clone());
        add.get("http-only").set(newAddOp.get(WebSSODefinition.HTTP_ONLY.getName()).clone());
        if (newAddOp.hasDefined(WebSSODefinition.CACHE_CONTAINER.getName())) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSODefinition.CACHE_CONTAINER.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address")));
        }
        if (newAddOp.hasDefined(WebSSODefinition.REAUTHENTICATE.getName())) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSODefinition.REAUTHENTICATE.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address")));
        }
        if (newAddOp.hasDefined(WebSSODefinition.CACHE_NAME.getName())) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSODefinition.CACHE_NAME.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address")));
        }
        newAddOperations.put(newAddress, add);
    }

    private void migrateAccessLog(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address, ModelNode legacyAddOps) {
        ModelNode directory;
        PathAddress newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host", (String)address.getElement(address.size() - 2).getValue()), UndertowExtension.PATH_ACCESS_LOG});
        ModelNode add = Util.createAddOperation((PathAddress)newAddress);
        add.get("pattern").set(newAddOp.get(WebAccessLogDefinition.PATTERN.getName()).clone());
        add.get("prefix").set(newAddOp.get(WebAccessLogDefinition.PREFIX.getName()).clone());
        add.get("rotate").set(newAddOp.get(WebAccessLogDefinition.ROTATE.getName()).clone());
        if (newAddOp.hasDefined(WebAccessLogDefinition.RESOLVE_HOSTS.getName())) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebAccessLogDefinition.RESOLVE_HOSTS.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address")));
        }
        if (newAddOp.hasDefined(WebAccessLogDefinition.EXTENDED.getName())) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebAccessLogDefinition.EXTENDED.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address")));
        }
        if ((directory = WebMigrateOperation.findResource(PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)newAddOp.get("address")), (PathElement[])new PathElement[]{WebExtension.DIRECTORY_PATH}), legacyAddOps)) != null) {
            newAddOp.get("directory").set(directory.get("path"));
            newAddOp.get("relative-to").set(directory.get("relative-to"));
        }
        newAddOperations.put(newAddress, add);
    }

    private boolean wildcardEquals(PathAddress a1, PathAddress a2) {
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            PathElement p1 = a1.getElement(i);
            PathElement p2 = a2.getElement(i);
            if (!p1.getKey().equals(p2.getKey())) {
                return false;
            }
            if (p1.isWildcard() || p2.isWildcard() || p1.getValue().equals(p2.getValue())) continue;
            return false;
        }
        return true;
    }

    private void migrateVirtualHost(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address) {
        PathAddress newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host", (String)address.getLastElement().getValue())});
        ModelNode add = Util.createAddOperation((PathAddress)newAddress);
        if (newAddOp.hasDefined(WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.getName()) && newAddOp.get(WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.getName()).asBoolean()) {
            PathAddress welcomeAddress = PathAddress.pathAddress((PathAddress)newAddress, (PathElement[])new PathElement[]{PathElement.pathElement((String)"location", (String)"/")});
            ModelNode welcomeAdd = Util.createAddOperation((PathAddress)welcomeAddress);
            welcomeAdd.get("handler").set("welcome-content");
            newAddOperations.put(welcomeAddress, welcomeAdd);
        }
        add.get("alias").set(newAddOp.get(WebVirtualHostDefinition.ALIAS.getName()).clone());
        add.get("default-web-module").set(newAddOp.get(WebVirtualHostDefinition.DEFAULT_WEB_MODULE.getName()));
        newAddOperations.put(newAddress, add);
    }

    private void migrateConnector(OperationContext context, Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address, ModelNode legacyModelAddOps) throws OperationFailedException {
        ModelNode addConnector;
        PathAddress newAddress;
        String protocol = newAddOp.get(WebConnectorDefinition.PROTOCOL.getName()).asString();
        String scheme = null;
        if (newAddOp.hasDefined(WebConnectorDefinition.SCHEME.getName())) {
            scheme = newAddOp.get(WebConnectorDefinition.SCHEME.getName()).asString();
        }
        switch (protocol) {
            case "HTTP/1.1": {
                if (scheme == null || scheme.equals("http")) {
                    newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"http-listener", (String)address.getLastElement().getValue())});
                    addConnector = Util.createAddOperation((PathAddress)newAddress);
                    break;
                }
                if (scheme.equals("https")) {
                    newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"https-listener", (String)address.getLastElement().getValue())});
                    addConnector = Util.createAddOperation((PathAddress)newAddress);
                    SSLInformation sslInfo = this.createSecurityRealm(context, newAddOperations, legacyModelAddOps, newAddress.getLastElement().getValue());
                    if (sslInfo == null) {
                        throw UndertowLogger.ROOT_LOGGER.noSslConfig();
                    }
                    addConnector.get("security-realm").set(sslInfo.realmName);
                    addConnector.get("verify-client").set(sslInfo.verifyClient);
                    addConnector.get("ssl-session-cache-size").set(sslInfo.sessionCacheSize);
                    addConnector.get("ssl-session-timeout").set(sslInfo.sessionTimeout);
                    addConnector.get("enabled-protocols").set(sslInfo.sslProtocol);
                    addConnector.get("enabled-cipher-suites").set(sslInfo.cipherSuites);
                    break;
                }
                newAddress = null;
                addConnector = null;
                break;
            }
            case "AJP": {
                newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"ajp-listener", (String)address.getLastElement().getValue())});
                addConnector = Util.createAddOperation((PathAddress)newAddress);
                break;
            }
            default: {
                newAddress = null;
                addConnector = null;
            }
        }
        if (newAddress == null) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(newAddOp);
            return;
        }
        addConnector.get("socket-binding").set(newAddOp.get("socket-binding"));
        addConnector.get("secure").set(newAddOp.get(WebConnectorDefinition.SECURE.getName()));
        addConnector.get("redirect-socket").set(newAddOp.get(WebConnectorDefinition.REDIRECT_BINDING.getName()));
        addConnector.get("enabled").set(newAddOp.get(WebConnectorDefinition.ENABLED.getName()));
        addConnector.get("resolve-peer-address").set(newAddOp.get(WebConnectorDefinition.ENABLE_LOOKUPS.getName()));
        addConnector.get("max-post-size").set(newAddOp.get(WebConnectorDefinition.MAX_POST_SIZE.getName()));
        addConnector.get("redirect-socket").set(newAddOp.get(WebConnectorDefinition.REDIRECT_BINDING.getName()));
        addConnector.get("max-connections").set(newAddOp.get(WebConnectorDefinition.MAX_CONNECTIONS.getName()));
        if (newAddOp.hasDefined(WebConnectorDefinition.EXECUTOR.getName())) {
            UndertowLogger.ROOT_LOGGER.couldNotMigrateResource(WebConnectorDefinition.EXECUTOR.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address")));
        }
        newAddOperations.put(PathAddress.pathAddress((ModelNode)newAddOp.get("address")), addConnector);
    }

    private void migrateMimeMapping(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        this.migrateWelcomeFiles(newAddOperations, newAddOp);
        ModelNode mime = newAddOp.get("mime-mapping");
        if (mime.isDefined()) {
            for (ModelNode w : mime.asList()) {
                PathAddress wa = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)"servlet-container", (String)"default"), PathElement.pathElement((String)"mime-mapping", (String)w.asProperty().getName())}), (PathElement[])new PathElement[0]);
                ModelNode add = Util.createAddOperation((PathAddress)wa);
                add.get("value").set(w.asProperty().getValue());
                newAddOperations.put(wa, add);
            }
        }
    }

    private void migrateWelcomeFiles(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        ModelNode welcome = newAddOp.get("welcome-file");
        if (welcome.isDefined()) {
            for (ModelNode w : welcome.asList()) {
                PathAddress wa = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)"servlet-container", (String)"default"), PathElement.pathElement((String)"welcome-file", (String)w.asString())}), (PathElement[])new PathElement[0]);
                ModelNode add = Util.createAddOperation((PathAddress)wa);
                newAddOperations.put(wa, add);
            }
        }
    }

    private void migrateJSPConfig(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        newAddOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)"servlet-container", (String)"default"), UndertowExtension.PATH_JSP}).toModelNode());
        newAddOperations.put(PathAddress.pathAddress((ModelNode)newAddOp.get("address")), newAddOp);
    }

    private void migrateSubsystem(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        newAddOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow")}).toModelNode());
        newAddOperations.put(PathAddress.pathAddress((ModelNode)newAddOp.get("address")), newAddOp);
    }

    private void describeLegacyWebResources(OperationContext context, ModelNode legacyModelDescription) {
        ModelNode describeLegacySubsystem = Util.createOperation((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (PathAddress)context.getCurrentAddress());
        context.addStep(legacyModelDescription, describeLegacySubsystem, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
    }

    private static ModelNode findResource(PathAddress address, ModelNode legacyAddOps) {
        for (ModelNode legacyAddOp : legacyAddOps.get("result").asList()) {
            PathAddress la = PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"));
            if (!la.equals(address)) continue;
            return legacyAddOp;
        }
        return null;
    }

    private class SSLInformation {
        final String realmName;
        final ModelNode verifyClient;
        final ModelNode sessionCacheSize;
        final ModelNode sessionTimeout;
        final ModelNode sslProtocol;
        final ModelNode cipherSuites;

        private SSLInformation(String realmName, ModelNode verifyClient, ModelNode sessionCacheSize, ModelNode sessionTimeout, ModelNode sslProtocol, ModelNode cipherSuites) {
            this.realmName = realmName;
            this.verifyClient = verifyClient;
            this.sessionCacheSize = sessionCacheSize;
            this.sessionTimeout = sessionTimeout;
            this.sslProtocol = sslProtocol;
            this.cipherSuites = cipherSuites;
        }
    }
}

