/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.SynchronizationType;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.sql.DataSource;
import javax.validation.ValidatorFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.beanvalidation.BeanValidationAttachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.jpa.beanmanager.ProxyBeanManager;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.config.PersistenceProviderDeploymentHolder;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.interceptor.WebNonTxEmCloserAction;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderLoader;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.processor.PersistenceProviderAdaptorLoader;
import org.jboss.as.jpa.processor.secondLevelCache.CacheDeploymentListener;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.service.PhaseOnePersistenceUnitServiceImpl;
import org.jboss.as.jpa.subsystem.PersistenceUnitRegistryImpl;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jandex.Index;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jipijapa.plugin.spi.ManagementAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.Platform;
import org.jipijapa.plugin.spi.TwoPhaseBootstrapCapable;

public class PersistenceUnitServiceHandler {
    private static final String ENTITYMANAGERFACTORY_JNDI_PROPERTY = "jboss.entity.manager.factory.jndi.name";
    private static final String ENTITYMANAGER_JNDI_PROPERTY = "jboss.entity.manager.jndi.name";
    public static final ServiceName BEANMANAGER_NAME = ServiceName.of((String[])new String[]{"beanmanager"});
    private static final AttachmentKey<Map<String, PersistenceProviderAdaptor>> providerAdaptorMapKey = AttachmentKey.create(Map.class);
    public static final AttributeDefinition SCOPED_UNIT_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scoped-unit-name", ModelType.STRING, true).setStorageRuntime()).build();
    private static final String FIRST_PHASE = "__FIRST_PHASE__";
    private static final String EE_DEFAULT_DATASOURCE = "java:comp/DefaultDataSource";
    private static AttachmentKey<AttachmentList<PersistenceAdaptorRemoval>> REMOVAL_KEY = AttachmentKey.createList(PersistenceAdaptorRemoval.class);

    public static void deploy(DeploymentPhaseContext phaseContext, boolean startEarly, Platform platform) throws DeploymentUnitProcessingException {
        PersistenceUnitServiceHandler.handleWarDeployment(phaseContext, startEarly, platform);
        PersistenceUnitServiceHandler.handleEarDeployment(phaseContext, startEarly, platform);
        PersistenceUnitServiceHandler.handleJarDeployment(phaseContext, startEarly, platform);
        if (startEarly) {
            PersistenceUnitServiceHandler.nextPhaseDependsOnPersistenceUnit(phaseContext, platform);
        }
    }

    public static void undeploy(DeploymentUnit context) {
        List removals = context.getAttachmentList(REMOVAL_KEY);
        if (removals != null) {
            for (PersistenceAdaptorRemoval removal : removals) {
                removal.cleanup();
            }
            context.removeAttachment(REMOVAL_KEY);
        }
    }

    private static void handleJarDeployment(DeploymentPhaseContext phaseContext, boolean startEarly, Platform platform) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadataHolder holder;
        ResourceRoot deploymentRoot;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!PersistenceUnitServiceHandler.isEarDeployment(deploymentUnit) && !PersistenceUnitServiceHandler.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit) && (deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)) != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            puList.add(holder);
            JpaLogger.ROOT_LOGGER.tracef("install persistence unit definition for jar %s", deploymentRoot.getRootName());
            PersistenceUnitServiceHandler.addPuService(phaseContext, puList, startEarly, platform);
        }
    }

    private static void handleWarDeployment(DeploymentPhaseContext phaseContext, boolean startEarly, Platform platform) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitServiceHandler.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            PersistenceUnitMetadataHolder holder;
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            String deploymentRootName = null;
            if (deploymentRoot != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                puList.add(holder);
                deploymentRootName = deploymentRoot.getRootName();
            }
            List resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || (holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) == null || holder.getPersistenceUnits().size() <= 0) continue;
                puList.add(holder);
            }
            if (startEarly) {
                deploymentUnit.addToAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS, (Object)new WebNonTxEmCloserAction());
            }
            JpaLogger.ROOT_LOGGER.tracef("install persistence unit definitions for war %s", deploymentRootName);
            PersistenceUnitServiceHandler.addPuService(phaseContext, puList, startEarly, platform);
        }
    }

    private static void handleEarDeployment(DeploymentPhaseContext phaseContext, boolean startEarly, Platform platform) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitServiceHandler.isEarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            List deploymentRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
            for (ResourceRoot root : deploymentRoots) {
                PersistenceUnitMetadataHolder holder;
                if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) continue;
                ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
                if (root != null && (holder = (PersistenceUnitMetadataHolder)root.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                    puList.add(holder);
                }
                JpaLogger.ROOT_LOGGER.tracef("install persistence unit definitions for ear %s", root.getRootName());
                PersistenceUnitServiceHandler.addPuService(phaseContext, puList, startEarly, platform);
            }
        }
    }

    private static void addPuService(DeploymentPhaseContext phaseContext, ArrayList<PersistenceUnitMetadataHolder> puList, boolean startEarly, Platform platform) throws DeploymentUnitProcessingException {
        if (puList.size() > 0) {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            Collection components = eeModuleDescription.getComponentDescriptions();
            if (module == null) {
                JpaLogger.ROOT_LOGGER.failedToGetModuleAttachment(deploymentUnit);
                return;
            }
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ModuleClassLoader classLoader = module.getClassLoader();
            for (PersistenceUnitMetadataHolder holder : puList) {
                PersistenceUnitServiceHandler.setAnnotationIndexes(holder, deploymentUnit);
                for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                    boolean deployPU;
                    String jpaContainerManaged = pu.getProperties().getProperty("jboss.as.jpa.managed");
                    boolean bl = deployPU = jpaContainerManaged == null ? true : Boolean.parseBoolean(jpaContainerManaged);
                    if (deployPU) {
                        boolean allowCdiBeanManagerAccess;
                        boolean twoPhaseBootStrapCapable;
                        PersistenceProvider provider;
                        PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = PersistenceUnitServiceHandler.getPersistenceProviderDeploymentHolder(deploymentUnit);
                        PersistenceProviderAdaptor adaptor = PersistenceUnitServiceHandler.getPersistenceProviderAdaptor(pu, persistenceProviderDeploymentHolder, deploymentUnit, provider = PersistenceUnitServiceHandler.lookupProvider(pu, persistenceProviderDeploymentHolder, deploymentUnit), platform);
                        boolean bl2 = twoPhaseBootStrapCapable = adaptor instanceof TwoPhaseBootstrapCapable && Configuration.allowTwoPhaseBootstrap(pu);
                        if (startEarly) {
                            if (twoPhaseBootStrapCapable) {
                                PersistenceUnitServiceHandler.deployPersistenceUnitPhaseOne(phaseContext, deploymentUnit, eeModuleDescription, components, serviceTarget, classLoader, pu, adaptor);
                                continue;
                            }
                            if (!Configuration.needClassFileTransformer(pu)) {
                                JpaLogger.ROOT_LOGGER.tracef("persistence unit %s in deployment %s is configured to not need class transformer to be set, no class rewriting will be allowed", pu.getPersistenceUnitName(), deploymentUnit.getName());
                                continue;
                            }
                            allowCdiBeanManagerAccess = false;
                            PersistenceUnitServiceHandler.deployPersistenceUnit(phaseContext, deploymentUnit, eeModuleDescription, components, serviceTarget, classLoader, pu, startEarly, provider, adaptor, false);
                            continue;
                        }
                        if (twoPhaseBootStrapCapable) {
                            PersistenceUnitServiceHandler.deployPersistenceUnitPhaseTwo(phaseContext, deploymentUnit, eeModuleDescription, components, serviceTarget, classLoader, pu, provider, adaptor);
                            continue;
                        }
                        if (Configuration.needClassFileTransformer(pu)) continue;
                        allowCdiBeanManagerAccess = true;
                        PersistenceUnitServiceHandler.deployPersistenceUnit(phaseContext, deploymentUnit, eeModuleDescription, components, serviceTarget, classLoader, pu, startEarly, provider, adaptor, true);
                        continue;
                    }
                    JpaLogger.ROOT_LOGGER.tracef("persistence unit %s in deployment %s is not container managed (%s is set to false)", pu.getPersistenceUnitName(), deploymentUnit.getName(), "jboss.as.jpa.managed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deployPersistenceUnit(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, Collection<ComponentDescription> components, ServiceTarget serviceTarget, ModuleClassLoader classLoader, PersistenceUnitMetadata pu, boolean startEarly, PersistenceProvider provider, PersistenceProviderAdaptor adaptor, boolean allowCdiBeanManagerAccess) throws DeploymentUnitProcessingException {
        pu.setClassLoader((ClassLoader)classLoader);
        try {
            ValidatorFactory validatorFactory = null;
            HashMap properties = new HashMap();
            if (!ValidationMode.NONE.equals((Object)pu.getValidationMode())) {
                validatorFactory = (ValidatorFactory)deploymentUnit.getAttachment(BeanValidationAttachments.VALIDATOR_FACTORY);
            }
            PersistenceUnitServiceImpl service = new PersistenceUnitServiceImpl((ClassLoader)classLoader, pu, adaptor, provider, PersistenceUnitRegistryImpl.INSTANCE, deploymentUnit.getServiceName(), validatorFactory);
            deploymentUnit.addToAttachmentList(REMOVAL_KEY, (Object)new PersistenceAdaptorRemoval(pu, adaptor));
            adaptor.addProviderProperties(properties, pu);
            ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu);
            deploymentUnit.putAttachment(JpaAttachments.PERSISTENCE_UNIT_SERVICE_KEY, (Object)puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)puServiceName);
            ServiceBuilder builder = serviceTarget.addService(puServiceName, (Service)service);
            boolean useDefaultDataSource = Configuration.allowDefaultDataSourceUse(pu);
            String jtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getJtaDataSourceName());
            String nonJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getNonJtaDataSourceName());
            if (jtaDataSource != null && jtaDataSource.length() > 0) {
                if (jtaDataSource.equals(EE_DEFAULT_DATASOURCE)) {
                    useDefaultDataSource = true;
                } else {
                    builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getJtaDataSourceInjector()));
                    useDefaultDataSource = false;
                }
            }
            if (nonJtaDataSource != null && nonJtaDataSource.length() > 0) {
                builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)nonJtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getNonJtaDataSourceInjector()));
                useDefaultDataSource = false;
            }
            if (useDefaultDataSource) {
                String defaultJtaDataSource = null;
                if (eeModuleDescription != null) {
                    defaultJtaDataSource = eeModuleDescription.getDefaultResourceJndiNames().getDataSource();
                }
                if (defaultJtaDataSource == null || defaultJtaDataSource.isEmpty()) {
                    defaultJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(JPAService.getDefaultDataSourceName());
                }
                if (defaultJtaDataSource != null && !defaultJtaDataSource.isEmpty()) {
                    builder.addDependency(ContextNames.bindInfoFor((String)defaultJtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getJtaDataSourceInjector()));
                    JpaLogger.ROOT_LOGGER.tracef("%s is using the default data source '%s'", puServiceName, defaultJtaDataSource);
                }
            }
            if (allowCdiBeanManagerAccess && WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                builder.addDependency(PersistenceUnitServiceHandler.beanManagerServiceName(deploymentUnit), (Injector)new CastingInjector(service.getBeanManagerInjector(), BeanManager.class));
            }
            try {
                CacheDeploymentListener.setInternalDeploymentServiceBuilder(builder);
                adaptor.addProviderDependencies(pu);
            }
            finally {
                CacheDeploymentListener.clearInternalDeploymentServiceBuilder();
            }
            PersistenceUnitServiceHandler.entityManagerBind(eeModuleDescription, serviceTarget, pu, puServiceName);
            PersistenceUnitServiceHandler.entityManagerFactoryBind(eeModuleDescription, serviceTarget, pu, puServiceName);
            builder.setInitialMode(ServiceController.Mode.ACTIVE).addInjection(service.getPropertiesInjector(), properties);
            Services.addServerExecutorDependency((ServiceBuilder)builder, service.getExecutorInjector(), (boolean)false);
            builder.install();
            JpaLogger.ROOT_LOGGER.tracef("added PersistenceUnitService for '%s'.  PU is ready for injector action.", puServiceName);
            PersistenceUnitServiceHandler.addManagementConsole(deploymentUnit, pu, adaptor);
        }
        catch (ServiceRegistryException e) {
            throw JpaLogger.ROOT_LOGGER.failedToAddPersistenceUnit(e, pu.getPersistenceUnitName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deployPersistenceUnitPhaseOne(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, Collection<ComponentDescription> components, ServiceTarget serviceTarget, ModuleClassLoader classLoader, PersistenceUnitMetadata pu, PersistenceProviderAdaptor adaptor) throws DeploymentUnitProcessingException {
        pu.setClassLoader((ClassLoader)classLoader);
        try {
            HashMap properties = new HashMap();
            ProxyBeanManager proxyBeanManager = null;
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                proxyBeanManager = new ProxyBeanManager();
            }
            PhaseOnePersistenceUnitServiceImpl service = new PhaseOnePersistenceUnitServiceImpl((ClassLoader)classLoader, pu, adaptor, deploymentUnit.getServiceName(), proxyBeanManager);
            deploymentUnit.addToAttachmentList(REMOVAL_KEY, (Object)new PersistenceAdaptorRemoval(pu, adaptor));
            adaptor.addProviderProperties(properties, pu);
            ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu).append(new String[]{FIRST_PHASE});
            deploymentUnit.putAttachment(JpaAttachments.PERSISTENCE_UNIT_SERVICE_KEY, (Object)puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)puServiceName);
            ServiceBuilder builder = serviceTarget.addService(puServiceName, (Service)service);
            boolean useDefaultDataSource = Configuration.allowDefaultDataSourceUse(pu);
            String jtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getJtaDataSourceName());
            String nonJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getNonJtaDataSourceName());
            if (jtaDataSource != null && jtaDataSource.length() > 0) {
                if (jtaDataSource.equals(EE_DEFAULT_DATASOURCE)) {
                    useDefaultDataSource = true;
                } else {
                    builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getJtaDataSourceInjector()));
                    useDefaultDataSource = false;
                }
            }
            if (nonJtaDataSource != null && nonJtaDataSource.length() > 0) {
                builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)nonJtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getNonJtaDataSourceInjector()));
                useDefaultDataSource = false;
            }
            if (useDefaultDataSource) {
                String defaultJtaDataSource = null;
                if (eeModuleDescription != null) {
                    defaultJtaDataSource = eeModuleDescription.getDefaultResourceJndiNames().getDataSource();
                }
                if (defaultJtaDataSource == null || defaultJtaDataSource.isEmpty()) {
                    defaultJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(JPAService.getDefaultDataSourceName());
                }
                if (defaultJtaDataSource != null && !defaultJtaDataSource.isEmpty()) {
                    builder.addDependency(ContextNames.bindInfoFor((String)defaultJtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getJtaDataSourceInjector()));
                    JpaLogger.ROOT_LOGGER.tracef("%s is using the default data source '%s'", puServiceName, defaultJtaDataSource);
                }
            }
            try {
                CacheDeploymentListener.setInternalDeploymentServiceBuilder(builder);
                adaptor.addProviderDependencies(pu);
            }
            finally {
                CacheDeploymentListener.clearInternalDeploymentServiceBuilder();
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).addInjection(service.getPropertiesInjector(), properties);
            Services.addServerExecutorDependency((ServiceBuilder)builder, service.getExecutorInjector(), (boolean)false);
            builder.install();
            JpaLogger.ROOT_LOGGER.tracef("added PersistenceUnitService (phase 1 of 2) for '%s'.  PU is ready for injector action.", puServiceName);
        }
        catch (ServiceRegistryException e) {
            throw JpaLogger.ROOT_LOGGER.failedToAddPersistenceUnit(e, pu.getPersistenceUnitName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deployPersistenceUnitPhaseTwo(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, Collection<ComponentDescription> components, ServiceTarget serviceTarget, ModuleClassLoader classLoader, PersistenceUnitMetadata pu, PersistenceProvider provider, PersistenceProviderAdaptor adaptor) throws DeploymentUnitProcessingException {
        pu.setClassLoader((ClassLoader)classLoader);
        try {
            ValidatorFactory validatorFactory = null;
            HashMap properties = new HashMap();
            if (!ValidationMode.NONE.equals((Object)pu.getValidationMode())) {
                validatorFactory = (ValidatorFactory)deploymentUnit.getAttachment(BeanValidationAttachments.VALIDATOR_FACTORY);
            }
            PersistenceUnitServiceImpl service = new PersistenceUnitServiceImpl((ClassLoader)classLoader, pu, adaptor, provider, PersistenceUnitRegistryImpl.INSTANCE, deploymentUnit.getServiceName(), validatorFactory);
            deploymentUnit.addToAttachmentList(REMOVAL_KEY, (Object)new PersistenceAdaptorRemoval(pu, adaptor));
            adaptor.addProviderProperties(properties, pu);
            ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu);
            deploymentUnit.putAttachment(JpaAttachments.PERSISTENCE_UNIT_SERVICE_KEY, (Object)puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)puServiceName);
            ServiceBuilder builder = serviceTarget.addService(puServiceName, (Service)service);
            builder.addDependency(JPAServiceNames.getJPAServiceName());
            builder.addDependency(puServiceName.append(new String[]{FIRST_PHASE}), (Injector)new CastingInjector(service.getPhaseOnePersistenceUnitServiceImplInjector(), PhaseOnePersistenceUnitServiceImpl.class));
            boolean useDefaultDataSource = Configuration.allowDefaultDataSourceUse(pu);
            String jtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getJtaDataSourceName());
            String nonJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getNonJtaDataSourceName());
            if (jtaDataSource != null && jtaDataSource.length() > 0) {
                if (jtaDataSource.equals(EE_DEFAULT_DATASOURCE)) {
                    useDefaultDataSource = true;
                } else {
                    builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getJtaDataSourceInjector()));
                    useDefaultDataSource = false;
                }
            }
            if (nonJtaDataSource != null && nonJtaDataSource.length() > 0) {
                builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)nonJtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getNonJtaDataSourceInjector()));
                useDefaultDataSource = false;
            }
            if (useDefaultDataSource) {
                String defaultJtaDataSource = null;
                if (eeModuleDescription != null) {
                    defaultJtaDataSource = eeModuleDescription.getDefaultResourceJndiNames().getDataSource();
                }
                if (defaultJtaDataSource == null || defaultJtaDataSource.isEmpty()) {
                    defaultJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(JPAService.getDefaultDataSourceName());
                }
                if (defaultJtaDataSource != null && !defaultJtaDataSource.isEmpty()) {
                    builder.addDependency(ContextNames.bindInfoFor((String)defaultJtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getJtaDataSourceInjector()));
                    JpaLogger.ROOT_LOGGER.tracef("%s is using the default data source '%s'", puServiceName, defaultJtaDataSource);
                }
            }
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                builder.addDependency(PersistenceUnitServiceHandler.beanManagerServiceName(deploymentUnit), (Injector)new CastingInjector(service.getBeanManagerInjector(), BeanManager.class));
            }
            try {
                CacheDeploymentListener.setInternalDeploymentServiceBuilder(builder);
                adaptor.addProviderDependencies(pu);
            }
            finally {
                CacheDeploymentListener.clearInternalDeploymentServiceBuilder();
            }
            PersistenceUnitServiceHandler.entityManagerBind(eeModuleDescription, serviceTarget, pu, puServiceName);
            PersistenceUnitServiceHandler.entityManagerFactoryBind(eeModuleDescription, serviceTarget, pu, puServiceName);
            builder.setInitialMode(ServiceController.Mode.ACTIVE).addInjection(service.getPropertiesInjector(), properties);
            Services.addServerExecutorDependency((ServiceBuilder)builder, service.getExecutorInjector(), (boolean)false);
            builder.install();
            JpaLogger.ROOT_LOGGER.tracef("added PersistenceUnitService (phase 2 of 2) for '%s'.  PU is ready for injector action.", puServiceName);
            PersistenceUnitServiceHandler.addManagementConsole(deploymentUnit, pu, adaptor);
        }
        catch (ServiceRegistryException e) {
            throw JpaLogger.ROOT_LOGGER.failedToAddPersistenceUnit(e, pu.getPersistenceUnitName());
        }
    }

    private static void entityManagerBind(EEModuleDescription eeModuleDescription, ServiceTarget serviceTarget, final PersistenceUnitMetadata pu, ServiceName puServiceName) {
        if (pu.getProperties().containsKey(ENTITYMANAGER_JNDI_PROPERTY)) {
            String jndiName = pu.getProperties().get(ENTITYMANAGER_JNDI_PROPERTY).toString();
            ContextNames.BindInfo bindingInfo = jndiName.startsWith("java:") ? ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jndiName) : ContextNames.bindInfoFor((String)jndiName);
            JpaLogger.ROOT_LOGGER.tracef("binding the transaction scoped entity manager to jndi name '%s'", bindingInfo.getAbsoluteJndiName());
            final BinderService binderService = new BinderService(bindingInfo.getBindName());
            serviceTarget.addService(bindingInfo.getBinderServiceName(), (Service)binderService).addDependency(bindingInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addDependency(puServiceName, PersistenceUnitServiceImpl.class, (Injector)new Injector<PersistenceUnitServiceImpl>(){

                public void inject(PersistenceUnitServiceImpl value) throws InjectionException {
                    binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)new TransactionScopedEntityManager(pu.getScopedPersistenceUnitName(), Collections.emptyMap(), value.getEntityManagerFactory(), SynchronizationType.SYNCHRONIZED))));
                }

                public void uninject() {
                    binderService.getNamingStoreInjector().uninject();
                }
            }).install();
        }
    }

    private static void entityManagerFactoryBind(EEModuleDescription eeModuleDescription, ServiceTarget serviceTarget, PersistenceUnitMetadata pu, ServiceName puServiceName) {
        if (pu.getProperties().containsKey(ENTITYMANAGERFACTORY_JNDI_PROPERTY)) {
            String jndiName = pu.getProperties().get(ENTITYMANAGERFACTORY_JNDI_PROPERTY).toString();
            ContextNames.BindInfo bindingInfo = jndiName.startsWith("java:") ? ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jndiName) : ContextNames.bindInfoFor((String)jndiName);
            JpaLogger.ROOT_LOGGER.tracef("binding the entity manager factory to jndi name '%s'", bindingInfo.getAbsoluteJndiName());
            final BinderService binderService = new BinderService(bindingInfo.getBindName());
            serviceTarget.addService(bindingInfo.getBinderServiceName(), (Service)binderService).addDependency(bindingInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addDependency(puServiceName, PersistenceUnitServiceImpl.class, (Injector)new Injector<PersistenceUnitServiceImpl>(){

                public void inject(PersistenceUnitServiceImpl value) throws InjectionException {
                    binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)value.getEntityManagerFactory())));
                }

                public void uninject() {
                    binderService.getNamingStoreInjector().uninject();
                }
            }).install();
        }
    }

    private static ServiceName beanManagerServiceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(BEANMANAGER_NAME);
    }

    private static void setAnnotationIndexes(PersistenceUnitMetadataHolder puHolder, DeploymentUnit deploymentUnit) {
        HashMap<URL, Index> annotationIndexes = new HashMap<URL, Index>();
        do {
            for (ResourceRoot root : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
                Index index = (Index)root.getAttachment(Attachments.ANNOTATION_INDEX);
                if (index == null) continue;
                try {
                    JpaLogger.ROOT_LOGGER.tracef("adding '%s' to annotation index map", root.getRoot().toURL());
                    annotationIndexes.put(root.getRoot().toURL(), index);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        } while ((deploymentUnit = deploymentUnit.getParent()) != null);
        for (PersistenceUnitMetadata pu : puHolder.getPersistenceUnits()) {
            pu.setAnnotationIndex(annotationIndexes);
        }
    }

    private static String adjustJndi(String dataSourceName) {
        if (dataSourceName != null && dataSourceName.length() > 0 && !dataSourceName.startsWith("java:")) {
            if (dataSourceName.startsWith("jboss/")) {
                return "java:" + dataSourceName;
            }
            return "java:/" + dataSourceName;
        }
        return dataSourceName;
    }

    private static PersistenceProviderAdaptor getPersistenceProviderAdaptor(PersistenceUnitMetadata pu, PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder, DeploymentUnit deploymentUnit, PersistenceProvider provider, Platform platform) throws DeploymentUnitProcessingException {
        String adaptorModule;
        PersistenceProviderAdaptor adaptor;
        String adapterClass = pu.getProperties().getProperty("jboss.as.jpa.adapterClass");
        if (persistenceProviderDeploymentHolder != null && adapterClass != null) {
            List<PersistenceProviderAdaptor> persistenceProviderAdaptors = persistenceProviderDeploymentHolder.getAdapters();
            for (PersistenceProviderAdaptor persistenceProviderAdaptor : persistenceProviderAdaptors) {
                if (!adapterClass.equals(persistenceProviderAdaptor.getClass().getName())) continue;
                return persistenceProviderAdaptor;
            }
        }
        if ((adaptor = PersistenceUnitServiceHandler.getPerDeploymentSharedPersistenceProviderAdaptor(deploymentUnit, adaptorModule = pu.getProperties().getProperty("jboss.as.jpa.adapterModule"), provider)) == null) {
            try {
                adaptor = adaptorModule != null ? PersistenceProviderAdaptorLoader.loadPersistenceAdapterModule(adaptorModule, platform) : PersistenceProviderAdaptorLoader.loadPersistenceAdapter(provider, platform);
            }
            catch (ModuleLoadException e) {
                throw JpaLogger.ROOT_LOGGER.persistenceProviderAdaptorModuleLoadError(e, adaptorModule);
            }
            adaptor = PersistenceUnitServiceHandler.savePerDeploymentSharedPersistenceProviderAdaptor(deploymentUnit, adaptorModule, adaptor, provider);
        }
        if (adaptor == null) {
            throw JpaLogger.ROOT_LOGGER.failedToGetAdapter(pu.getPersistenceProviderClassName());
        }
        return adaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistenceProviderAdaptor savePerDeploymentSharedPersistenceProviderAdaptor(DeploymentUnit deploymentUnit, String adaptorModule, PersistenceProviderAdaptor adaptor, PersistenceProvider provider) {
        if (deploymentUnit.getParent() != null) {
            deploymentUnit = deploymentUnit.getParent();
        }
        DeploymentUnit deploymentUnit2 = deploymentUnit;
        synchronized (deploymentUnit2) {
            Map map = (Map)deploymentUnit.getAttachment(providerAdaptorMapKey);
            String key = adaptorModule != null ? adaptorModule : provider.getClass().getName();
            PersistenceProviderAdaptor current = (PersistenceProviderAdaptor)map.get(key);
            if (current == null) {
                map.put(key, adaptor);
                current = adaptor;
            }
            return current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistenceProviderAdaptor getPerDeploymentSharedPersistenceProviderAdaptor(DeploymentUnit deploymentUnit, String adaptorModule, PersistenceProvider provider) {
        if (deploymentUnit.getParent() != null) {
            deploymentUnit = deploymentUnit.getParent();
        }
        DeploymentUnit deploymentUnit2 = deploymentUnit;
        synchronized (deploymentUnit2) {
            HashMap map = (HashMap)deploymentUnit.getAttachment(providerAdaptorMapKey);
            if (map == null) {
                map = new HashMap();
                deploymentUnit.putAttachment(providerAdaptorMapKey, map);
            }
            String key = adaptorModule != null ? adaptorModule : provider.getClass().getName();
            return (PersistenceProviderAdaptor)map.get(key);
        }
    }

    private static PersistenceProvider lookupProvider(PersistenceUnitMetadata pu, PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        PersistenceProvider provider;
        List<PersistenceProvider> providerList;
        List<PersistenceProvider> list = providerList = persistenceProviderDeploymentHolder != null ? persistenceProviderDeploymentHolder.getProviders() : null;
        if (providerList != null) {
            for (PersistenceProvider persistenceProvider : providerList) {
                if (!persistenceProvider.getClass().getName().equals(pu.getPersistenceProviderClassName())) continue;
                JpaLogger.ROOT_LOGGER.tracef("deployment %s is using %s", deploymentUnit.getName(), pu.getPersistenceProviderClassName());
                return persistenceProvider;
            }
        }
        String configuredPersistenceProviderModule = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
        String persistenceProviderClassName = pu.getPersistenceProviderClassName();
        if (persistenceProviderClassName == null) {
            persistenceProviderClassName = "org.hibernate.jpa.HibernatePersistenceProvider";
        }
        if (configuredPersistenceProviderModule != null) {
            try {
                List<PersistenceProvider> providers = PersistenceProviderLoader.loadProviderModuleByName(configuredPersistenceProviderModule);
                PersistenceProviderDeploymentHolder.savePersistenceProviderInDeploymentUnit(deploymentUnit, providers, null);
                provider = PersistenceUnitServiceHandler.getProviderByName(pu, providers);
                if (provider != null) {
                    return provider;
                }
            }
            catch (ModuleLoadException e) {
                throw JpaLogger.ROOT_LOGGER.cannotLoadPersistenceProviderModule(e, configuredPersistenceProviderModule, persistenceProviderClassName);
            }
        }
        String providerNameDerivedFromClassName = Configuration.getProviderModuleNameFromProviderClassName(persistenceProviderClassName);
        provider = PersistenceUnitServiceHandler.getProviderByName(pu);
        if (provider == null && providerNameDerivedFromClassName != null) {
            try {
                List<PersistenceProvider> providers = PersistenceProviderLoader.loadProviderModuleByName(providerNameDerivedFromClassName);
                PersistenceProviderDeploymentHolder.savePersistenceProviderInDeploymentUnit(deploymentUnit, providers, null);
                provider = PersistenceUnitServiceHandler.getProviderByName(pu, providers);
            }
            catch (ModuleLoadException e) {
                throw JpaLogger.ROOT_LOGGER.cannotLoadPersistenceProviderModule(e, providerNameDerivedFromClassName, persistenceProviderClassName);
            }
        }
        if (provider == null) {
            throw JpaLogger.ROOT_LOGGER.persistenceProviderNotFound(persistenceProviderClassName);
        }
        return provider;
    }

    private static PersistenceProvider getProviderByName(PersistenceUnitMetadata pu) {
        return PersistenceUnitServiceHandler.getProviderByName(pu, PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders());
    }

    private static PersistenceProvider getProviderByName(PersistenceUnitMetadata pu, List<PersistenceProvider> providers) {
        String providerName = pu.getPersistenceProviderClassName();
        for (PersistenceProvider provider : providers) {
            if (providerName != null && !provider.getClass().getName().equals(providerName) && (!provider.getClass().getName().equals("org.hibernate.jpa.HibernatePersistenceProvider") || !providerName.equals("org.hibernate.ejb.HibernatePersistence"))) continue;
            return provider;
        }
        return null;
    }

    private static void nextPhaseDependsOnPersistenceUnit(DeploymentPhaseContext phaseContext, Platform platform) throws DeploymentUnitProcessingException {
        DeploymentUnit topDeploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)phaseContext.getDeploymentUnit());
        PersistenceUnitsInApplication persistenceUnitsInApplication = (PersistenceUnitsInApplication)topDeploymentUnit.getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
        for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                boolean twoPhaseBootStrapCapable;
                String jpaContainerManaged = pu.getProperties().getProperty("jboss.as.jpa.managed");
                boolean deployPU = jpaContainerManaged == null ? true : Boolean.parseBoolean(jpaContainerManaged);
                if (!deployPU) continue;
                ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu);
                PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = PersistenceUnitServiceHandler.getPersistenceProviderDeploymentHolder(phaseContext.getDeploymentUnit());
                PersistenceProvider provider = PersistenceUnitServiceHandler.lookupProvider(pu, persistenceProviderDeploymentHolder, phaseContext.getDeploymentUnit());
                PersistenceProviderAdaptor adaptor = PersistenceUnitServiceHandler.getPersistenceProviderAdaptor(pu, persistenceProviderDeploymentHolder, phaseContext.getDeploymentUnit(), provider, platform);
                boolean bl = twoPhaseBootStrapCapable = adaptor instanceof TwoPhaseBootstrapCapable && Configuration.allowTwoPhaseBootstrap(pu);
                if (!Configuration.needClassFileTransformer(pu)) continue;
                phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, (Object)(twoPhaseBootStrapCapable ? puServiceName.append(new String[]{FIRST_PHASE}) : puServiceName));
            }
        }
    }

    static boolean isEarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)context);
    }

    static boolean isWarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addManagementConsole(DeploymentUnit deploymentUnit, PersistenceUnitMetadata pu, PersistenceProviderAdaptor adaptor) {
        ManagementAdaptor managementAdaptor = adaptor.getManagementAdaptor();
        if (managementAdaptor != null && adaptor.doesScopedPersistenceUnitNameIdentifyCacheRegionName(pu)) {
            Resource subsystemResource;
            Resource deploymentResource;
            String providerLabel = managementAdaptor.getIdentificationLabel();
            String scopedPersistenceUnitName = pu.getScopedPersistenceUnitName();
            Resource providerResource = JPAService.createManagementStatisticsResource(managementAdaptor, scopedPersistenceUnitName, deploymentUnit);
            ModelNode perPuNode = providerResource.getModel();
            perPuNode.get(SCOPED_UNIT_NAME.getName()).set(pu.getScopedPersistenceUnitName());
            Resource resource = deploymentResource = (Resource)deploymentUnit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
            synchronized (resource) {
                subsystemResource = PersistenceUnitServiceHandler.getOrCreateResource(deploymentResource, PathElement.pathElement((String)"subsystem", (String)"jpa"));
            }
            resource = subsystemResource;
            synchronized (resource) {
                subsystemResource.registerChild(PathElement.pathElement((String)providerLabel, (String)scopedPersistenceUnitName), providerResource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource getOrCreateResource(Resource parent, PathElement element) {
        Resource resource = parent;
        synchronized (resource) {
            if (parent.hasChild(element)) {
                return parent.requireChild(element);
            }
            Resource resource2 = Resource.Factory.create();
            parent.registerChild(element, resource2);
            return resource2;
        }
    }

    private static PersistenceProviderDeploymentHolder getPersistenceProviderDeploymentHolder(DeploymentUnit deploymentUnit) {
        deploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit);
        return (PersistenceProviderDeploymentHolder)deploymentUnit.getAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER);
    }

    private static class PersistenceAdaptorRemoval {
        final PersistenceUnitMetadata pu;
        final PersistenceProviderAdaptor adaptor;

        public PersistenceAdaptorRemoval(PersistenceUnitMetadata pu, PersistenceProviderAdaptor adaptor) {
            this.pu = pu;
            this.adaptor = adaptor;
        }

        private void cleanup() {
            this.adaptor.cleanup(this.pu);
        }
    }

    private static class ManagedReferenceFactoryInjector
    implements Injector<ManagedReferenceFactory> {
        private volatile ManagedReference reference;
        private final Injector<DataSource> dataSourceInjector;

        public ManagedReferenceFactoryInjector(Injector<DataSource> dataSourceInjector) {
            this.dataSourceInjector = dataSourceInjector;
        }

        public void inject(ManagedReferenceFactory value) throws InjectionException {
            this.reference = value.getReference();
            this.dataSourceInjector.inject((Object)((DataSource)this.reference.getInstance()));
        }

        public void uninject() {
            this.reference.release();
            this.reference = null;
            this.dataSourceInjector.uninject();
        }
    }
}

