/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import javax.management.MBeanServer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.infinispan.spi.io.SimpleExternalizer;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.service.Builder;

public class GlobalConfigurationBuilder
implements ResourceServiceBuilder<GlobalConfiguration>,
Value<GlobalConfiguration> {
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final InjectedValue<MBeanServer> server = new InjectedValue();
    private final InjectedValue<TransportConfiguration> transport = new InjectedValue();
    private final String name;
    private volatile boolean statisticsEnabled;
    private volatile ModuleIdentifier module;

    GlobalConfigurationBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.CONFIGURATION.getServiceName(this.name);
    }

    public Builder<GlobalConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.module = ModelNodes.asModuleIdentifier((ModelNode)CacheContainerResourceDefinition.Attribute.MODULE.getDefinition().resolveModelAttribute(context, model));
        this.statisticsEnabled = CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.getDefinition().resolveModelAttribute(context, model).asBoolean();
        return this;
    }

    public GlobalConfiguration getValue() {
        org.infinispan.configuration.global.GlobalConfigurationBuilder builder = new org.infinispan.configuration.global.GlobalConfigurationBuilder();
        TransportConfiguration transport = (TransportConfiguration)this.transport.getValue();
        builder.transport().transport(transport.transport()).distributedSyncTimeout(transport.distributedSyncTimeout()).clusterName(transport.clusterName()).machineId(transport.machineId()).rackId(transport.rackId()).siteId(transport.siteId());
        ModuleLoader moduleLoader = (ModuleLoader)this.loader.getValue();
        builder.serialization().classResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader));
        try {
            ModuleClassLoader loader = moduleLoader.loadModule(this.module).getClassLoader();
            builder.classLoader((ClassLoader)loader);
            int id = 255;
            for (SimpleExternalizer externalizer : ServiceLoader.load(SimpleExternalizer.class, (ClassLoader)loader)) {
                InfinispanLogger.ROOT_LOGGER.debugf("Cache container %s will use an externalizer for %s", this.name, externalizer.getTargetClass().getName());
                builder.serialization().addAdvancedExternalizer(id++, (AdvancedExternalizer)externalizer);
            }
        }
        catch (ModuleLoadException e) {
            throw new IllegalStateException(e);
        }
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        builder.globalJmxStatistics().enabled(this.statisticsEnabled).cacheManagerName(this.name).mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider((MBeanServer)this.server.getValue())).jmxDomain(CacheContainerServiceName.CACHE_CONTAINER.getServiceName("default").getParent().getCanonicalName()).allowDuplicateDomains(Boolean.valueOf(true));
        return builder.build();
    }

    public ServiceBuilder<GlobalConfiguration> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, this.server).addDependency(CacheContainerComponent.TRANSPORT.getServiceName(this.name), TransportConfiguration.class, this.transport).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

