/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SiteConfiguration;
import org.infinispan.configuration.global.SiteConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponentBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;

public class SiteBuilder
extends CacheContainerComponentBuilder<SiteConfiguration> {
    private final InjectedValue<ChannelFactory> factory = new InjectedValue();
    private volatile String channelName = null;

    public SiteBuilder(String containerName) {
        super(CacheContainerComponent.SITE, containerName);
    }

    @Override
    public ServiceBuilder<SiteConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        if (this.channelName != null) {
            builder.addDependency(ChannelServiceName.FACTORY.getServiceName(this.channelName), ChannelFactory.class, this.factory);
        }
        return builder;
    }

    public SiteConfiguration getValue() {
        RelayConfiguration relay;
        SiteConfigurationBuilder builder = new GlobalConfigurationBuilder().site();
        ChannelFactory factory = (ChannelFactory)this.factory.getOptionalValue();
        if (factory != null && (relay = ((ChannelFactory)this.factory.getValue()).getProtocolStackConfiguration().getRelay()) != null) {
            builder.localSite(relay.getSiteName());
        }
        return builder.create();
    }

    SiteBuilder setChannelName(String channelName) {
        this.channelName = channelName;
        return this;
    }
}

