/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.util.concurrent.CountDownLatch;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class EmbeddedHostControllerBootstrap {
    private final ShutdownHook shutdownHook;
    private final ServiceContainer serviceContainer;
    private final HostControllerEnvironment environment;
    private final String authCode;
    private FutureServiceContainer futureContainer;

    public EmbeddedHostControllerBootstrap(FutureServiceContainer futureContainer, HostControllerEnvironment environment, String authCode) {
        this.environment = environment;
        this.authCode = authCode;
        this.shutdownHook = new ShutdownHook();
        this.serviceContainer = this.shutdownHook.register();
        this.futureContainer = futureContainer;
    }

    public FutureServiceContainer bootstrap() throws Exception {
        HostRunningModeControl runningModeControl = this.environment.getRunningModeControl();
        ControlledProcessState processState = new ControlledProcessState(true);
        this.shutdownHook.setControlledProcessState(processState);
        ServiceTarget target = this.serviceContainer.subTarget();
        ServiceController serviceController = ControlledProcessStateService.addService((ServiceTarget)target, (ControlledProcessState)processState);
        HostControllerService hcs = new HostControllerService(this.environment, runningModeControl, this.authCode, processState, true, this.futureContainer);
        target.addService(HostControllerService.HC_SERVICE_NAME, (Service)hcs).install();
        return this.futureContainer;
    }

    private static class ShutdownHook
    extends Thread {
        private boolean down;
        private ControlledProcessState processState;
        private ServiceContainer container;

        private ShutdownHook() {
        }

        private ServiceContainer register() {
            Runtime.getRuntime().addShutdownHook(this);
            ShutdownHook shutdownHook = this;
            synchronized (shutdownHook) {
                if (!this.down) {
                    this.container = ServiceContainer.Factory.create((String)"host-controller", (boolean)false);
                    return this.container;
                }
                throw new IllegalStateException();
            }
        }

        private synchronized void setControlledProcessState(ControlledProcessState ps) {
            this.processState = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                CountDownLatch latch;
                ControlledProcessState ps;
                ServiceContainer sc;
                ShutdownHook shutdownHook = this;
                synchronized (shutdownHook) {
                    this.down = true;
                    sc = this.container;
                    ps = this.processState;
                }
                try {
                    if (ps != null) {
                        ps.setStopping();
                    }
                    if (sc == null) break block13;
                    latch = new CountDownLatch(1);
                }
                catch (Throwable throwable) {
                    if (sc != null) {
                        CountDownLatch latch2 = new CountDownLatch(1);
                        sc.addTerminateListener(new ServiceContainer.TerminateListener(this, latch2){
                            final /* synthetic */ CountDownLatch val$latch;
                            final /* synthetic */ ShutdownHook this$0;
                            {
                                this.this$0 = this$0;
                                this.val$latch = countDownLatch;
                            }

                            public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                                this.val$latch.countDown();
                            }
                        });
                        sc.shutdown();
                        while (true) {
                            try {
                                latch2.await();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    throw throwable;
                }
                sc.addTerminateListener(new /* invalid duplicate definition of identical inner class */);
                sc.shutdown();
                while (true) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

