/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.InactiveSessionStatistics;

public class RecordableInactiveSessionStatistics
implements InactiveSessionStatistics,
Recordable<ImmutableSession> {
    private final AtomicLong expiredSessions = new AtomicLong();
    private final AtomicReference<Long> maxLifetime = new AtomicReference();
    private final AtomicReference<Map.Entry<Long, Long>> totals = new AtomicReference();

    public RecordableInactiveSessionStatistics() {
        this.reset();
    }

    public void record(ImmutableSession session) {
        long now = System.currentTimeMillis();
        long lifetime = now - session.getMetaData().getCreationTime().getTime();
        long currentMaxLifetime = this.maxLifetime.get();
        while (lifetime > currentMaxLifetime && !this.maxLifetime.compareAndSet(currentMaxLifetime, lifetime)) {
            currentMaxLifetime = this.maxLifetime.get();
        }
        Map.Entry<Long, Long> currentTotals = this.totals.get();
        Map.Entry<Long, Long> sessions = RecordableInactiveSessionStatistics.createNewTotals(currentTotals, lifetime);
        while (!this.totals.compareAndSet(currentTotals, sessions)) {
            currentTotals = this.totals.get();
            sessions = RecordableInactiveSessionStatistics.createNewTotals(currentTotals, lifetime);
        }
        if (session.getMetaData().isExpired()) {
            this.expiredSessions.incrementAndGet();
        }
    }

    private static Map.Entry<Long, Long> createNewTotals(Map.Entry<Long, Long> totals, long lifetime) {
        long totalLifetime = totals.getKey();
        long totalSessions = totals.getValue();
        return new AbstractMap.SimpleImmutableEntry<Long, Long>(totalLifetime + lifetime, totalSessions + 1L);
    }

    public long getMeanSessionLifetime(TimeUnit unit) {
        Map.Entry<Long, Long> totals = this.totals.get();
        long lifetime = totals.getKey();
        long count = totals.getValue();
        return count > 0L ? unit.convert(lifetime, TimeUnit.MILLISECONDS) / count : 0L;
    }

    public long getMaxSessionLifetime(TimeUnit unit) {
        return unit.convert(this.maxLifetime.get(), TimeUnit.MILLISECONDS);
    }

    public long getExpiredSessionCount() {
        return this.expiredSessions.get();
    }

    public void reset() {
        this.maxLifetime.set(0L);
        this.totals.set(new AbstractMap.SimpleImmutableEntry<Long, Long>(0L, 0L));
        this.expiredSessions.set(0L);
    }
}

