/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.ha;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;

public class SharedStoreSlavePolicyConfiguration
implements HAPolicyConfiguration {
    private long failbackDelay = ActiveMQDefaultConfiguration.getDefaultFailbackDelay();
    private boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean restartBackup = ActiveMQDefaultConfiguration.isDefaultRestartBackup();
    private boolean allowFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private ScaleDownConfiguration scaleDownConfiguration;

    @Override
    public HAPolicyConfiguration.TYPE getType() {
        return HAPolicyConfiguration.TYPE.SHARED_STORE_SLAVE;
    }

    public boolean isRestartBackup() {
        return this.restartBackup;
    }

    public SharedStoreSlavePolicyConfiguration setRestartBackup(boolean restartBackup) {
        this.restartBackup = restartBackup;
        return this;
    }

    public ScaleDownConfiguration getScaleDownConfiguration() {
        return this.scaleDownConfiguration;
    }

    public SharedStoreSlavePolicyConfiguration setScaleDownConfiguration(ScaleDownConfiguration scaleDownConfiguration) {
        this.scaleDownConfiguration = scaleDownConfiguration;
        return this;
    }

    public boolean isAllowFailBack() {
        return this.allowFailBack;
    }

    public SharedStoreSlavePolicyConfiguration setAllowFailBack(boolean allowFailBack) {
        this.allowFailBack = allowFailBack;
        return this;
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public SharedStoreSlavePolicyConfiguration setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        return this;
    }

    public long getFailbackDelay() {
        return this.failbackDelay;
    }

    public SharedStoreSlavePolicyConfiguration setFailbackDelay(long failbackDelay) {
        this.failbackDelay = failbackDelay;
        return this;
    }
}

