/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.server.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistry;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.AcceptorFactory;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ConnectionLifeCycleListener;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.ReusableLatch;

public class RemotingServiceImpl
implements RemotingService,
ConnectionLifeCycleListener {
    private static final boolean isTrace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    public static final long CONNECTION_TTL_CHECK_INTERVAL = 2000L;
    private volatile boolean started = false;
    private final Set<TransportConfiguration> acceptorsConfig;
    private final List<BaseInterceptor> incomingInterceptors = new CopyOnWriteArrayList<BaseInterceptor>();
    private final List<BaseInterceptor> outgoingInterceptors = new CopyOnWriteArrayList<BaseInterceptor>();
    private final Map<String, Acceptor> acceptors = new HashMap<String, Acceptor>();
    private final Map<Object, ConnectionEntry> connections = new ConcurrentHashMap<Object, ConnectionEntry>();
    private final ReusableLatch connectionCountLatch = new ReusableLatch(0);
    private final ActiveMQServer server;
    private final ManagementService managementService;
    private ExecutorService threadPool;
    private final Executor flushExecutor;
    private final ScheduledExecutorService scheduledThreadPool;
    private FailureCheckAndFlushThread failureCheckAndFlushThread;
    private final ClusterManager clusterManager;
    private final Map<String, ProtocolManager> protocolMap = new ConcurrentHashMap<String, ProtocolManager>();
    private ActiveMQPrincipal defaultInvmSecurityPrincipal;
    private ServiceRegistry serviceRegistry;

    public RemotingServiceImpl(ClusterManager clusterManager, Configuration config, ActiveMQServer server, ManagementService managementService, ScheduledExecutorService scheduledThreadPool, List<ProtocolManagerFactory> protocolManagerFactories, Executor flushExecutor, ServiceRegistry serviceRegistry) {
        ServiceLoader<ProtocolManagerFactory> serviceLoader;
        this.serviceRegistry = serviceRegistry;
        this.acceptorsConfig = config.getAcceptorConfigurations();
        this.server = server;
        this.clusterManager = clusterManager;
        this.setInterceptors(config);
        this.managementService = managementService;
        this.scheduledThreadPool = scheduledThreadPool;
        CoreProtocolManagerFactory coreProtocolManagerFactory = new CoreProtocolManagerFactory();
        this.flushExecutor = flushExecutor;
        ActiveMQServerLogger.LOGGER.addingProtocolSupport(coreProtocolManagerFactory.getProtocols()[0], coreProtocolManagerFactory.getModuleName());
        this.protocolMap.put(coreProtocolManagerFactory.getProtocols()[0], coreProtocolManagerFactory.createProtocolManager(server, coreProtocolManagerFactory.filterInterceptors(this.incomingInterceptors), coreProtocolManagerFactory.filterInterceptors(this.outgoingInterceptors)));
        if (config.isResolveProtocols() && (serviceLoader = ServiceLoader.load(ProtocolManagerFactory.class, this.getClass().getClassLoader())) != null) {
            for (ProtocolManagerFactory next : serviceLoader) {
                String[] protocols;
                String[] stringArray = protocols = next.getProtocols();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String protocol = stringArray[i];
                    ActiveMQServerLogger.LOGGER.addingProtocolSupport(protocol, next.getModuleName());
                    this.protocolMap.put(protocol, next.createProtocolManager(server, next.filterInterceptors(this.incomingInterceptors), next.filterInterceptors(this.outgoingInterceptors)));
                }
            }
        }
        if (protocolManagerFactories != null) {
            for (ProtocolManagerFactory protocolManagerFactory : protocolManagerFactories) {
                String[] protocols;
                for (String protocol : protocols = protocolManagerFactory.getProtocols()) {
                    ActiveMQServerLogger.LOGGER.addingProtocolSupport(protocol, protocolManagerFactory.getModuleName());
                    this.protocolMap.put(protocol, protocolManagerFactory.createProtocolManager(server, this.incomingInterceptors, this.outgoingInterceptors));
                }
            }
        }
    }

    private void setInterceptors(Configuration configuration) {
        this.addReflectivelyInstantiatedInterceptors(configuration.getIncomingInterceptorClassNames(), this.incomingInterceptors);
        this.addReflectivelyInstantiatedInterceptors(configuration.getOutgoingInterceptorClassNames(), this.outgoingInterceptors);
        this.incomingInterceptors.addAll(this.serviceRegistry.getIncomingInterceptors());
        this.outgoingInterceptors.addAll(this.serviceRegistry.getOutgoingInterceptors());
    }

    private void addReflectivelyInstantiatedInterceptors(List<String> classNames, List<BaseInterceptor> interceptors) {
        for (String className : classNames) {
            BaseInterceptor interceptor = (BaseInterceptor)RemotingServiceImpl.safeInitNewInstance(className);
            interceptors.add(interceptor);
        }
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        ActiveMQThreadFactory tFactory = new ActiveMQThreadFactory("ActiveMQ-remoting-threads-" + this.server.toString() + "-" + System.identityHashCode(this), false, tccl);
        this.threadPool = Executors.newCachedThreadPool((ThreadFactory)tFactory);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (TransportConfiguration info : this.acceptorsConfig) {
            try {
                String[] actualProtocols;
                String protocols;
                Class<?> clazz = loader.loadClass(info.getFactoryClassName());
                AcceptorFactory factory = (AcceptorFactory)clazz.newInstance();
                ConcurrentHashMap<String, ProtocolManager> supportedProtocols = new ConcurrentHashMap<String, ProtocolManager>();
                String protocol = ConfigurationHelper.getStringProperty((String)"protocol", null, (Map)info.getParams());
                if (protocol != null) {
                    ActiveMQServerLogger.LOGGER.warnDeprecatedProtocol();
                    ProtocolManager protocolManager = this.protocolMap.get(protocol);
                    if (protocolManager == null) {
                        throw ActiveMQMessageBundle.BUNDLE.noProtocolManagerFound(protocol);
                    }
                    supportedProtocols.put(protocol, protocolManager);
                }
                if ((protocols = ConfigurationHelper.getStringProperty((String)"protocols", null, (Map)info.getParams())) != null && (actualProtocols = protocols.split(",")) != null) {
                    for (String actualProtocol : actualProtocols) {
                        ProtocolManager protocolManager = this.protocolMap.get(actualProtocol);
                        if (protocolManager == null) {
                            throw ActiveMQMessageBundle.BUNDLE.noProtocolManagerFound(actualProtocol);
                        }
                        supportedProtocols.put(actualProtocol, protocolManager);
                    }
                }
                ClusterConnection clusterConnection = this.lookupClusterConnection(info);
                Acceptor acceptor = factory.createAcceptor(info.getName(), clusterConnection, info.getParams(), new DelegatingBufferHandler(), this, this.threadPool, this.scheduledThreadPool, supportedProtocols.isEmpty() ? this.protocolMap : supportedProtocols);
                if (this.defaultInvmSecurityPrincipal != null && acceptor.isUnsecurable()) {
                    acceptor.setDefaultActiveMQPrincipal(this.defaultInvmSecurityPrincipal);
                }
                this.acceptors.put(info.getName(), acceptor);
                if (this.managementService == null) continue;
                acceptor.setNotificationService(this.managementService);
                this.managementService.registerAcceptor(acceptor, info);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCreatingAcceptor(e, info.getFactoryClassName());
            }
        }
        this.failureCheckAndFlushThread = new FailureCheckAndFlushThread(2000L);
        this.failureCheckAndFlushThread.start();
        this.started = true;
    }

    @Override
    public synchronized void startAcceptors() throws Exception {
        if (this.isStarted()) {
            for (Acceptor a : this.acceptors.values()) {
                a.start();
            }
        }
    }

    @Override
    public synchronized void allowInvmSecurityOverride(ActiveMQPrincipal principal) {
        this.defaultInvmSecurityPrincipal = principal;
        for (Acceptor acceptor : this.acceptors.values()) {
            if (!acceptor.isUnsecurable()) continue;
            acceptor.setDefaultActiveMQPrincipal(principal);
        }
    }

    @Override
    public synchronized void pauseAcceptors() {
        if (!this.started) {
            return;
        }
        for (Acceptor acceptor : this.acceptors.values()) {
            try {
                acceptor.pause();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingAcceptor();
            }
        }
    }

    @Override
    public synchronized void freeze(String scaleDownNodeID, CoreRemotingConnection connectionToKeepOpen) {
        if (!this.started) {
            return;
        }
        this.failureCheckAndFlushThread.close(false);
        HashMap<Object, ConnectionEntry> connectionEntries = new HashMap<Object, ConnectionEntry>(this.connections);
        for (Map.Entry<Object, ConnectionEntry> entry : connectionEntries.entrySet()) {
            RemotingConnection conn = entry.getValue().connection;
            if (conn.equals(connectionToKeepOpen)) continue;
            if (ActiveMQServerLogger.LOGGER.isTraceEnabled()) {
                ActiveMQServerLogger.LOGGER.trace("Sending connection.disconnection packet to " + conn);
            }
            if (conn.isClient()) continue;
            conn.disconnect(scaleDownNodeID, false);
            this.removeConnection(entry.getKey());
        }
    }

    @Override
    public void stop(boolean criticalError) throws Exception {
        boolean bl;
        if (!this.started) {
            return;
        }
        this.failureCheckAndFlushThread.close(criticalError);
        for (Acceptor acceptor : this.acceptors.values()) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("Pausing acceptor " + acceptor);
            }
            acceptor.pause();
        }
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug("Sending disconnect on live connections");
        }
        HashSet<ConnectionEntry> connectionEntries = new HashSet<ConnectionEntry>(this.connections.values());
        for (ConnectionEntry entry : connectionEntries) {
            RemotingConnection conn = entry.connection;
            if (ActiveMQServerLogger.LOGGER.isTraceEnabled()) {
                ActiveMQServerLogger.LOGGER.trace("Sending connection.disconnection packet to " + conn);
            }
            conn.disconnect(criticalError);
        }
        for (Acceptor acceptor : this.acceptors.values()) {
            acceptor.stop();
        }
        this.acceptors.clear();
        this.connections.clear();
        this.connectionCountLatch.setCount(0);
        if (this.managementService != null) {
            this.managementService.unregisterAcceptors();
        }
        this.threadPool.shutdown();
        if (!criticalError && !(bl = this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS))) {
            ActiveMQServerLogger.LOGGER.timeoutRemotingThreadPool();
        }
        this.started = false;
    }

    @Override
    public Acceptor getAcceptor(String name) {
        return this.acceptors.get(name);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private RemotingConnection getConnection(Object remotingConnectionID) {
        ConnectionEntry entry = this.connections.get(remotingConnectionID);
        if (entry != null) {
            return entry.connection;
        }
        ActiveMQServerLogger.LOGGER.errorRemovingConnection();
        return null;
    }

    @Override
    public RemotingConnection removeConnection(Object remotingConnectionID) {
        ConnectionEntry entry = this.connections.remove(remotingConnectionID);
        if (entry != null) {
            this.connectionCountLatch.countDown();
            return entry.connection;
        }
        ActiveMQServerLogger.LOGGER.errorRemovingConnection();
        return null;
    }

    @Override
    public synchronized Set<RemotingConnection> getConnections() {
        HashSet<RemotingConnection> conns = new HashSet<RemotingConnection>(this.connections.size());
        for (ConnectionEntry entry : this.connections.values()) {
            conns.add(entry.connection);
        }
        return conns;
    }

    @Override
    public synchronized ReusableLatch getConnectionCountLatch() {
        return this.connectionCountLatch;
    }

    private ProtocolManager getProtocolManager(String protocol) {
        return this.protocolMap.get(protocol);
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, String protocol) {
        if (this.server == null) {
            throw new IllegalStateException("Unable to create connection, server hasn't finished starting up");
        }
        ProtocolManager pmgr = this.getProtocolManager(protocol.toString());
        if (pmgr == null) {
            throw ActiveMQMessageBundle.BUNDLE.unknownProtocol(protocol);
        }
        ConnectionEntry entry = pmgr.createConnectionEntry((Acceptor)component, connection);
        if (isTrace) {
            ActiveMQServerLogger.LOGGER.trace("Connection created " + connection);
        }
        this.connections.put(connection.getID(), entry);
        this.connectionCountLatch.countUp();
    }

    public void connectionDestroyed(Object connectionID) {
        ConnectionEntry conn;
        if (isTrace) {
            ActiveMQServerLogger.LOGGER.trace("Connection removed " + connectionID + " from server " + this.server, new Exception("trace"));
        }
        if ((conn = this.connections.get(connectionID)) != null) {
            List failureListeners = conn.connection.getFailureListeners();
            boolean empty = true;
            for (FailureListener listener : failureListeners) {
                if (!(listener instanceof ServerSessionImpl)) continue;
                empty = false;
                break;
            }
            if (empty) {
                this.removeConnection(connectionID);
                conn.connection.destroy();
            }
        }
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public void addIncomingInterceptor(Interceptor interceptor) {
        this.incomingInterceptors.add((BaseInterceptor)interceptor);
        this.updateProtocols();
    }

    @Override
    public boolean removeIncomingInterceptor(Interceptor interceptor) {
        if (this.incomingInterceptors.remove(interceptor)) {
            this.updateProtocols();
            return true;
        }
        return false;
    }

    @Override
    public void addOutgoingInterceptor(Interceptor interceptor) {
        this.outgoingInterceptors.add((BaseInterceptor)interceptor);
        this.updateProtocols();
    }

    @Override
    public boolean removeOutgoingInterceptor(Interceptor interceptor) {
        if (this.outgoingInterceptors.remove(interceptor)) {
            this.updateProtocols();
            return true;
        }
        return false;
    }

    private ClusterConnection lookupClusterConnection(TransportConfiguration acceptorConfig) {
        String clusterConnectionName = (String)acceptorConfig.getParams().get("clusterConnection");
        ClusterConnection clusterConnection = null;
        if (clusterConnectionName != null) {
            clusterConnection = this.clusterManager.getClusterConnection(clusterConnectionName);
        }
        if (clusterConnection == null) {
            clusterConnection = this.clusterManager.getDefaultConnection(acceptorConfig);
        }
        return clusterConnection;
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    protected void updateProtocols() {
        for (ProtocolManager protocolManager : this.protocolMap.values()) {
            protocolManager.updateInterceptors(this.incomingInterceptors, this.outgoingInterceptors);
        }
    }

    private final class FailureCheckAndFlushThread
    extends Thread {
        private final long pauseInterval;
        private volatile boolean closed;
        private final CountDownLatch latch;

        FailureCheckAndFlushThread(long pauseInterval) {
            super("activemq-failure-check-thread");
            this.latch = new CountDownLatch(1);
            this.pauseInterval = pauseInterval;
        }

        public void close(boolean criticalError) {
            this.closed = true;
            this.latch.countDown();
            if (!criticalError) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
        }

        @Override
        public void run() {
            while (!this.closed) {
                try {
                    RemotingConnection conn;
                    long now = System.currentTimeMillis();
                    HashSet<Object> idsToRemove = new HashSet<Object>();
                    for (ConnectionEntry entry : RemotingServiceImpl.this.connections.values()) {
                        conn = entry.connection;
                        boolean flush = true;
                        if (entry.ttl != -1L) {
                            if (!conn.checkDataReceived()) {
                                if (now >= entry.lastCheck + entry.ttl) {
                                    idsToRemove.add(conn.getID());
                                    flush = false;
                                }
                            } else {
                                entry.lastCheck = now;
                            }
                        }
                        if (!flush) continue;
                        RemotingServiceImpl.this.flushExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    conn.flush();
                                }
                                catch (Throwable e) {
                                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                                }
                            }
                        });
                    }
                    for (Object id : idsToRemove) {
                        conn = RemotingServiceImpl.this.getConnection(id);
                        if (conn == null) continue;
                        conn.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.clientExited(conn.getRemoteAddress()));
                        RemotingServiceImpl.this.removeConnection(id);
                    }
                    if (!this.latch.await(this.pauseInterval, TimeUnit.MILLISECONDS)) continue;
                    return;
                }
                catch (Throwable e) {
                    ActiveMQServerLogger.LOGGER.errorOnFailureCheck(e);
                }
            }
        }
    }

    private final class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            ConnectionEntry conn = (ConnectionEntry)RemotingServiceImpl.this.connections.get(connectionID);
            if (conn != null) {
                conn.connection.bufferReceived(connectionID, buffer);
            } else if (ActiveMQServerLogger.LOGGER.isTraceEnabled()) {
                ActiveMQServerLogger.LOGGER.trace("ConnectionID = " + connectionID + " was already closed, so ignoring packet");
            }
        }
    }
}

