/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ColocatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.LiveOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static ClusterConnectionConfiguration getReplicationClusterConfiguration(Configuration conf, String replicationCluster) throws ActiveMQIllegalStateException {
        if (replicationCluster == null || replicationCluster.isEmpty()) {
            return conf.getClusterConfigurations().get(0);
        }
        for (ClusterConnectionConfiguration clusterConf : conf.getClusterConfigurations()) {
            if (!replicationCluster.equals(clusterConf.getName())) continue;
            return clusterConf;
        }
        throw new ActiveMQIllegalStateException("Missing cluster-configuration for replication-clustername '" + replicationCluster + "'.");
    }

    public static HAPolicy getHAPolicy(HAPolicyConfiguration conf) throws ActiveMQIllegalStateException {
        if (conf == null) {
            return new LiveOnlyPolicy();
        }
        switch (conf.getType()) {
            case LIVE_ONLY: {
                LiveOnlyPolicyConfiguration pc = (LiveOnlyPolicyConfiguration)conf;
                return new LiveOnlyPolicy(ConfigurationUtils.getScaleDownPolicy(pc.getScaleDownConfiguration()));
            }
            case REPLICATED: {
                ReplicatedPolicyConfiguration pc = (ReplicatedPolicyConfiguration)conf;
                return new ReplicatedPolicy(pc.isCheckForLiveServer(), pc.getGroupName(), pc.getClusterName());
            }
            case REPLICA: {
                ReplicaPolicyConfiguration pc = (ReplicaPolicyConfiguration)conf;
                return new ReplicaPolicy(pc.getClusterName(), pc.getMaxSavedReplicatedJournalsSize(), pc.getGroupName(), pc.isRestartBackup(), pc.isAllowFailBack(), pc.getFailbackDelay(), ConfigurationUtils.getScaleDownPolicy(pc.getScaleDownConfiguration()));
            }
            case SHARED_STORE_MASTER: {
                SharedStoreMasterPolicyConfiguration pc = (SharedStoreMasterPolicyConfiguration)conf;
                return new SharedStoreMasterPolicy(pc.getFailbackDelay(), pc.isFailoverOnServerShutdown());
            }
            case SHARED_STORE_SLAVE: {
                SharedStoreSlavePolicyConfiguration pc = (SharedStoreSlavePolicyConfiguration)conf;
                return new SharedStoreSlavePolicy(pc.getFailbackDelay(), pc.isFailoverOnServerShutdown(), pc.isRestartBackup(), pc.isAllowFailBack(), ConfigurationUtils.getScaleDownPolicy(pc.getScaleDownConfiguration()));
            }
            case COLOCATED: {
                ColocatedPolicyConfiguration pc = (ColocatedPolicyConfiguration)conf;
                HAPolicyConfiguration backupConf = pc.getBackupConfig();
                BackupPolicy backupPolicy = backupConf == null ? new ReplicaPolicy() : (BackupPolicy)ConfigurationUtils.getHAPolicy(backupConf);
                HAPolicyConfiguration liveConf = pc.getLiveConfig();
                HAPolicy<LiveActivation> livePolicy = liveConf == null ? new ReplicatedPolicy() : ConfigurationUtils.getHAPolicy(liveConf);
                return new ColocatedPolicy(pc.isRequestBackup(), pc.getBackupRequestRetries(), pc.getBackupRequestRetryInterval(), pc.getMaxBackups(), pc.getBackupPortOffset(), pc.getExcludedConnectors(), livePolicy, backupPolicy);
            }
        }
        throw ActiveMQMessageBundle.BUNDLE.unsupportedHAPolicyConfiguration(conf);
    }

    public static ScaleDownPolicy getScaleDownPolicy(ScaleDownConfiguration scaleDownConfiguration) {
        if (scaleDownConfiguration != null) {
            if (scaleDownConfiguration.getDiscoveryGroup() != null) {
                return new ScaleDownPolicy(scaleDownConfiguration.getDiscoveryGroup(), scaleDownConfiguration.getGroupName(), scaleDownConfiguration.getClusterName(), scaleDownConfiguration.isEnabled());
            }
            return new ScaleDownPolicy(scaleDownConfiguration.getConnectors(), scaleDownConfiguration.getGroupName(), scaleDownConfiguration.getClusterName(), scaleDownConfiguration.isEnabled());
        }
        return null;
    }
}

