/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.function.Function;
import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;

public final class ReadOnlyKeyCommand<K, V, R>
extends AbstractDataCommand
implements LocalCommand {
    private Function<EntryView.ReadEntryView<K, V>, R> f;

    public ReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f) {
        super(key, null);
        this.f = f;
    }

    public ReadOnlyKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return -1;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null) {
            return null;
        }
        return this.perform(entry);
    }

    public Object perform(CacheEntry<K, V> entry) {
        Object ro = entry == null || entry.isNull() ? EntryViews.noValue(this.key) : EntryViews.readOnly(entry);
        return this.f.apply((EntryView.ReadEntryView<K, V>)ro);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadOnlyKeyCommand(ctx, this);
    }

    @Override
    public String toString() {
        return "ReadOnlyKeyCommand{f=" + this.f + '}';
    }
}

