/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.notifications.cachelistener.CacheNotifier;

@ThreadSafe
public class EvictionManagerImpl<K, V>
implements EvictionManager<K, V> {
    private CacheNotifier<K, V> cacheNotifier;

    @Inject
    public void initialize(CacheNotifier<K, V> cacheNotifier, ExpirationManager<K, V> expirationManager) {
        this.cacheNotifier = cacheNotifier;
    }

    @Override
    public void onEntryEviction(Map<? extends K, InternalCacheEntry<? extends K, ? extends V>> evicted) {
        ImmutableContext ctx = ImmutableContext.INSTANCE;
        this.cacheNotifier.notifyCacheEntriesEvicted(evicted.values(), ctx, null);
    }
}

