/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.infinispan.commons.api.functional.Param;

final class Params {
    private static final Param<?>[] DEFAULTS = new Param[]{Param.FutureMode.defaultValue()};
    final Param<?>[] params;

    private Params(Param<?>[] params) {
        this.params = params;
    }

    public boolean containsAll(Param<?> ... ps) {
        List<Param<?>> paramsToCheck = Arrays.asList(ps);
        List<Param<Param<?>>> paramsCurrent = Arrays.asList(this.params);
        return paramsCurrent.containsAll(paramsToCheck);
    }

    public Params addAll(Param<?> ... ps) {
        List<Param<?>> paramsToAdd = Arrays.asList(ps);
        Param<?>[] paramsAll = Arrays.copyOf(this.params, this.params.length);
        paramsToAdd.forEach(p -> {
            paramArray[p.id()] = p;
        });
        return new Params(paramsAll);
    }

    public <T> Param<T> get(int index) {
        return this.params[index];
    }

    public String toString() {
        return "Params=" + Arrays.toString(this.params);
    }

    public static Params create() {
        return new Params(DEFAULTS);
    }

    public static Params from(Param<?> ... ps) {
        List<Param<?>> paramsToAdd = Arrays.asList(ps);
        List<Param<Param<?>>> paramsDefaults = Arrays.asList(DEFAULTS);
        if (paramsDefaults.containsAll(paramsToAdd)) {
            return Params.create();
        }
        Param<?>[] paramsAll = Arrays.copyOf(DEFAULTS, DEFAULTS.length);
        paramsToAdd.forEach(p -> {
            paramArray[p.id()] = p;
        });
        return new Params(paramsAll);
    }

    static <T> CompletableFuture<T> withFuture(Param<Param.FutureMode> futureParam, ExecutorService asyncExec, Supplier<T> s) {
        switch ((Param.FutureMode)futureParam.get()) {
            case COMPLETED: {
                return CompletableFuture.completedFuture(s.get());
            }
            case ASYNC: {
                return CompletableFuture.supplyAsync(s, asyncExec);
            }
        }
        throw new IllegalStateException();
    }
}

