/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.config.PersistenceProviderDeploymentHolder;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jipijapa.plugin.spi.JtaManager;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.Platform;

public class PersistenceProviderHandler {
    private static final String PERSISTENCE_PROVIDER_CLASSNAME = PersistenceProvider.class.getName();

    public static void deploy(DeploymentPhaseContext phaseContext, Platform platform) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader deploymentModuleClassLoader = module.getClassLoader();
            List providerNames = servicesAttachment.getServiceImplementations(PERSISTENCE_PROVIDER_CLASSNAME);
            ArrayList<PersistenceProvider> providerList = new ArrayList<PersistenceProvider>();
            for (String providerName : providerNames) {
                try {
                    Class<PersistenceProvider> providerClass = deploymentModuleClassLoader.loadClass(providerName).asSubclass(PersistenceProvider.class);
                    Constructor<PersistenceProvider> constructor = providerClass.getConstructor(new Class[0]);
                    PersistenceProvider provider = constructor.newInstance(new Object[0]);
                    providerList.add(provider);
                    JpaLogger.ROOT_LOGGER.tracef("deployment %s is using its own copy of %s", deploymentUnit.getName(), providerName);
                }
                catch (Exception e) {
                    throw JpaLogger.ROOT_LOGGER.cannotDeployApp(e, providerName);
                }
            }
            if (providerList.size() > 0) {
                String adapterClass = (String)deploymentUnit.getAttachment(JpaAttachments.ADAPTOR_CLASS_NAME);
                if (adapterClass != null) {
                    try {
                        PersistenceProviderAdaptor adaptor = (PersistenceProviderAdaptor)deploymentModuleClassLoader.loadClass(adapterClass).newInstance();
                        adaptor.injectJtaManager((JtaManager)JtaManagerImpl.getInstance());
                        adaptor.injectPlatform(platform);
                        ArrayList<PersistenceProviderAdaptor> adaptorList = new ArrayList<PersistenceProviderAdaptor>();
                        adaptorList.add(adaptor);
                        PersistenceProviderDeploymentHolder.savePersistenceProviderInDeploymentUnit(deploymentUnit, providerList, adaptorList);
                    }
                    catch (InstantiationException e) {
                        throw JpaLogger.ROOT_LOGGER.cannotCreateAdapter(e, adapterClass);
                    }
                    catch (IllegalAccessException e) {
                        throw JpaLogger.ROOT_LOGGER.cannotCreateAdapter(e, adapterClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw JpaLogger.ROOT_LOGGER.cannotCreateAdapter(e, adapterClass);
                    }
                } else {
                    PersistenceProviderDeploymentHolder.savePersistenceProviderInDeploymentUnit(deploymentUnit, providerList, null);
                }
            }
        }
    }

    public static void finishDeploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List<PersistenceProvider> providerList;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = PersistenceProviderDeploymentHolder.getPersistenceProviderDeploymentHolder(deploymentUnit);
        List<PersistenceProvider> list = providerList = persistenceProviderDeploymentHolder != null ? persistenceProviderDeploymentHolder.getProviders() : null;
        if (providerList != null) {
            Set<ClassLoader> deploymentClassLoaders = PersistenceProviderHandler.allDeploymentModuleClassLoaders(deploymentUnit);
            for (PersistenceProvider provider : providerList) {
                PersistenceProviderResolverImpl.getInstance().addDeploymentSpecificPersistenceProvider(provider, deploymentClassLoaders);
            }
        }
    }

    public static void undeploy(DeploymentUnit deploymentUnit) {
        Set<ClassLoader> deploymentClassLoaders = PersistenceProviderHandler.allDeploymentModuleClassLoaders(deploymentUnit);
        PersistenceProviderResolverImpl.getInstance().clearCachedDeploymentSpecificProviders(deploymentClassLoaders);
    }

    private static Set<ClassLoader> allDeploymentModuleClassLoaders(DeploymentUnit deploymentUnit) {
        HashSet<ClassLoader> deploymentClassLoaders = new HashSet<ClassLoader>();
        DeploymentUnit topDeploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit);
        Module toplevelModule = (Module)topDeploymentUnit.getAttachment(Attachments.MODULE);
        if (toplevelModule != null) {
            deploymentClassLoaders.add((ClassLoader)toplevelModule.getClassLoader());
            List subDeployments = topDeploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit subDeploymentUnit : subDeployments) {
                Module subDeploymentModule = (Module)subDeploymentUnit.getAttachment(Attachments.MODULE);
                if (subDeploymentModule == null) continue;
                deploymentClassLoaders.add((ClassLoader)subDeploymentModule.getClassLoader());
            }
        }
        return deploymentClassLoaders;
    }
}

