/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.concurrent.ExecutorService;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.repository.JobRepository;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.deployment.BatchDeploymentDescriptorParser_1_0;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentMetaData;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobXmlResolver;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.jberet.services.BatchEnvironmentService;

public class BatchEnvironmentProcessor
implements DeploymentUnitProcessor {
    private final boolean rcPresent;

    public BatchEnvironmentProcessor(boolean rcPresent) {
        this.rcPresent = rcPresent;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE)) {
            DeploymentUnit parent;
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch environment.", deploymentUnit.getName());
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            JobRepository jobRepository = null;
            ExecutorService executorService = null;
            BatchEnvironmentMetaData metaData = (BatchEnvironmentMetaData)deploymentUnit.getAttachment(BatchDeploymentDescriptorParser_1_0.ATTACHMENT_KEY);
            if (metaData == null && (parent = deploymentUnit.getParent()) != null) {
                metaData = (BatchEnvironmentMetaData)parent.getAttachment(BatchDeploymentDescriptorParser_1_0.ATTACHMENT_KEY);
            }
            if (metaData != null) {
                jobRepository = metaData.getJobRepository();
                executorService = metaData.getExecutorService();
            }
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            BatchEnvironmentService service = new BatchEnvironmentService((ClassLoader)moduleClassLoader, (JobXmlResolver)WildFlyJobXmlResolver.of((ClassLoader)moduleClassLoader, deploymentUnit), deploymentUnit.getName());
            ServiceBuilder serviceBuilder = serviceTarget.addService(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit), (Service)service);
            if (executorService == null) {
                serviceBuilder.addDependency(support.getCapabilityServiceName(Capabilities.DEFAULT_THREAD_POOL_CAPABILITY.getName()), ExecutorService.class, (Injector)service.getExecutorServiceInjector());
            } else {
                service.getExecutorServiceInjector().setValue((Value)new ImmediateValue((Object)executorService));
            }
            serviceBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, (Injector)service.getTransactionManagerInjector());
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                BatchLogger.LOGGER.tracef("Adding BeanManager service dependency for deployment %s", deploymentUnit.getName());
                serviceBuilder.addDependency(BatchServiceNames.beanManagerServiceName(deploymentUnit), BeanManager.class, (Injector)service.getBeanManagerInjector());
            }
            if (jobRepository == null) {
                ServiceName defaultJobRepository = support.getCapabilityServiceName(Capabilities.DEFAULT_JOB_REPOSITORY_CAPABILITY.getName());
                serviceBuilder.addDependency(defaultJobRepository, JobRepository.class, (Injector)service.getJobRepositoryInjector());
            } else {
                service.getJobRepositoryInjector().setValue((Value)new ImmediateValue((Object)jobRepository));
            }
            if (this.rcPresent) {
                serviceBuilder.addDependency(RequestController.SERVICE_NAME, RequestController.class, (Injector)service.getRequestControllerInjector());
            }
            serviceBuilder.install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

