/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;

public class ResourceDescriptor
implements AddStepHandlerDescriptor {
    private final ResourceDescriptionResolver resolver;
    private final List<Capability> capabilities = new LinkedList<Capability>();
    private final List<AttributeDefinition> attributes = new LinkedList<AttributeDefinition>();
    private final List<AttributeDefinition> parameters = new LinkedList<AttributeDefinition>();

    public ResourceDescriptor(ResourceDescriptionResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public ResourceDescriptionResolver getDescriptionResolver() {
        return this.resolver;
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @Override
    public Collection<AttributeDefinition> getExtraParameters() {
        return this.parameters;
    }

    public <E extends Enum<E>> ResourceDescriptor addAttributes(Class<E> enumClass) {
        return this.addAttributes(EnumSet.allOf(enumClass));
    }

    public ResourceDescriptor addAttributes(Attribute ... attributes) {
        return this.addAttributes(Arrays.asList(attributes));
    }

    public ResourceDescriptor addAttributes(Iterable<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.attributes.add((AttributeDefinition)attribute.getDefinition());
        }
        return this;
    }

    public ResourceDescriptor addExtraParameters(AttributeDefinition ... parameters) {
        return this.addExtraParameters(Arrays.asList(parameters));
    }

    public ResourceDescriptor addExtraParameters(Collection<? extends AttributeDefinition> parameters) {
        this.parameters.addAll(parameters);
        return this;
    }

    public <E extends Enum<E>> ResourceDescriptor addCapabilities(Class<E> enumClass) {
        return this.addCapabilities(EnumSet.allOf(enumClass));
    }

    public ResourceDescriptor addCapabilities(Capability ... capabilities) {
        return this.addCapabilities(Arrays.asList(capabilities));
    }

    public ResourceDescriptor addCapabilities(Collection<? extends Capability> capabilities) {
        this.capabilities.addAll(capabilities);
        return this;
    }
}

