/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class ScheduledThreadPoolBuilder
extends CacheContainerComponentBuilder<ThreadPoolConfiguration>
implements ResourceServiceBuilder<ThreadPoolConfiguration> {
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ScheduledThreadPoolDefinition definition;

    ScheduledThreadPoolBuilder(ScheduledThreadPoolDefinition definition, String containerName) {
        super(definition, containerName);
        this.definition = definition;
    }

    public Builder<ThreadPoolConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final int maxThreads = ((AttributeDefinition)this.definition.getMaxThreads().getDefinition()).resolveModelAttribute(context, model).asInt();
        final long keepAliveTime = ((AttributeDefinition)this.definition.getKeepAliveTime().getDefinition()).resolveModelAttribute(context, model).asLong();
        ThreadPoolExecutorFactory<ScheduledExecutorService> factory = new ThreadPoolExecutorFactory<ScheduledExecutorService>(){

            public ScheduledExecutorService createExecutor(ThreadFactory factory) {
                ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(0);
                scheduledExecutor.setCorePoolSize(maxThreads);
                scheduledExecutor.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
                return scheduledExecutor;
            }

            public void validate() {
            }
        };
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        return this;
    }

    public ThreadPoolConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.builder.create();
    }
}

