/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LuceneBackendQueueTask
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Lock modificationLock;
    private final LuceneBackendResources resources;
    private final Iterable<LuceneWork> workList;
    private final IndexingMonitor monitor;

    LuceneBackendQueueTask(Iterable<LuceneWork> workList, LuceneBackendResources resources, IndexingMonitor monitor) {
        this.workList = workList;
        this.resources = resources;
        this.monitor = monitor;
        this.modificationLock = resources.getParallelModificationLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.modificationLock.lock();
        try {
            this.applyUpdates();
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(e);
            Thread.currentThread().interrupt();
            this.handleException(e);
        }
        catch (Exception e) {
            log.backendError(e);
            this.handleException(e);
        }
        finally {
            this.modificationLock.unlock();
        }
    }

    private void handleException(Exception e) {
        ErrorContextBuilder builder = new ErrorContextBuilder();
        builder.allWorkToBeDone(this.workList);
        builder.errorThatOccurred(e);
        this.resources.getErrorHandler().handle(builder.createErrorContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdates() throws InterruptedException, ExecutionException {
        AbstractWorkspaceImpl workspace = this.resources.getWorkspace();
        ErrorContextBuilder errorContextBuilder = new ErrorContextBuilder();
        errorContextBuilder.allWorkToBeDone(this.workList);
        IndexWriterDelegate delegate = workspace.getIndexWriterDelegate(errorContextBuilder);
        if (delegate == null) {
            log.cannotOpenIndexWriterCausePreviousError();
            return;
        }
        boolean taskExecutionSuccessful = true;
        LuceneWork currentOperation = null;
        try {
            Iterator<LuceneWork> i$ = this.workList.iterator();
            while (i$.hasNext()) {
                LuceneWork luceneWork;
                currentOperation = luceneWork = i$.next();
                LuceneBackendQueueTask.performWork(luceneWork, this.resources, delegate, this.monitor);
                errorContextBuilder.workCompleted(currentOperation);
            }
            currentOperation = null;
            workspace.optimizerPhase();
            workspace.afterTransactionApplied(!taskExecutionSuccessful, false);
        }
        catch (RuntimeException re) {
            try {
                errorContextBuilder.errorThatOccurred(re);
                if (currentOperation != null) {
                    errorContextBuilder.addWorkThatFailed(currentOperation);
                }
                this.resources.getErrorHandler().handle(errorContextBuilder.createErrorContext());
                workspace.afterTransactionApplied(!taskExecutionSuccessful, false);
            }
            catch (Throwable throwable) {
                workspace.afterTransactionApplied(!taskExecutionSuccessful, false);
                throw throwable;
            }
        }
    }

    static void performWork(LuceneWork work, LuceneBackendResources resources, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        work.acceptIndexWorkVisitor(resources.getWorkVisitor(), null).performWork(work, delegate, monitor);
    }
}

