/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.entity;

import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.entity.ReadOnlyAccess;
import org.hibernate.cache.infinispan.entity.TransactionalAccess;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.infinispan.AdvancedCache;

public class EntityRegionImpl
extends BaseTransactionalDataRegion
implements EntityRegion {
    public EntityRegionImpl(AdvancedCache cache, String name, TransactionManager transactionManager, CacheDataDescription metadata, RegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, name, transactionManager, metadata, factory, cacheKeysFactory);
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        switch (accessType) {
            case READ_ONLY: {
                return new ReadOnlyAccess(this);
            }
            case TRANSACTIONAL: {
                if (this.getCacheDataDescription().isMutable()) {
                    return new TransactionalAccess(this);
                }
                return new ReadOnlyAccess(this);
            }
        }
        throw new CacheException("Unsupported access type [" + accessType.getExternalName() + "]");
    }

    public PutFromLoadValidator getPutFromLoadValidator() {
        return new PutFromLoadValidator(this.cache);
    }
}

