/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.Arrays;
import java.util.Set;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class BeginInvalidationCommand
extends InvalidateCommand {
    private Object lockOwner;

    public BeginInvalidationCommand() {
    }

    public BeginInvalidationCommand(CacheNotifier notifier, Set<Flag> flags, Object[] keys, Object lockOwner) {
        super(notifier, flags, keys);
        this.lockOwner = lockOwner;
    }

    public Object getLockOwner() {
        return this.lockOwner;
    }

    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{0, this.lockOwner};
        }
        if (this.keys.length == 1) {
            return new Object[]{1, this.keys[0], this.lockOwner};
        }
        Object[] retval = new Object[this.keys.length + 2];
        retval[0] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 1, this.keys.length);
        return retval;
    }

    public void setParameters(int commandId, Object[] args) {
        if (commandId != 122) {
            throw new IllegalStateException("Invalid method id");
        }
        int size = (Integer)args[0];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[1];
        } else if (size > 0) {
            System.arraycopy(args, 1, this.keys, 0, size);
        }
        this.lockOwner = args[args.length - 1];
    }

    public byte getCommandId() {
        return 122;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof BeginInvalidationCommand) {
            BeginInvalidationCommand bic = (BeginInvalidationCommand)((Object)o);
            return EqualsHelper.equals((Object)this.lockOwner, (Object)bic.lockOwner);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + (this.lockOwner == null ? 0 : this.lockOwner.hashCode());
    }

    public String toString() {
        return "BeginInvalidateCommand{keys=" + Arrays.toString(this.keys) + ", lockOwner=" + this.lockOwner + '}';
    }
}

