/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jboss.aesh.console.reader.ConsoleInputSession;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.AbstractTerminal;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.util.LoggerUtil;

public class WindowsTerminal
extends AbstractTerminal {
    private PrintStream stdOut;
    private PrintStream stdErr;
    private TerminalSize size;
    private ConsoleInputSession input;
    private long ttyPropsLastFetched;
    private static long TIMEOUT_PERIOD = 2000L;
    private static final Logger LOGGER = LoggerUtil.getLogger(WindowsTerminal.class.getName());

    public WindowsTerminal() {
        super(LOGGER);
    }

    @Override
    public void init(Settings settings) {
        this.settings = settings;
        try {
            this.stdOut = new PrintStream((OutputStream)new WindowsAnsiOutputStream((OutputStream)settings.getStdOut()), true);
            this.stdErr = new PrintStream((OutputStream)new WindowsAnsiOutputStream((OutputStream)settings.getStdErr()), true);
        }
        catch (Exception ioe) {
            this.stdOut = new PrintStream((OutputStream)new AnsiOutputStream((OutputStream)settings.getStdOut()), true);
            this.stdErr = new PrintStream((OutputStream)new AnsiOutputStream((OutputStream)settings.getStdErr()), true);
        }
        if (settings.getInputStream().equals(System.in)) {
            InputStream inStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return WindowsSupport.readByte();
                }

                @Override
                public int read(byte[] in) throws IOException {
                    byte[] tmp = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(WindowsSupport.readByte()).array();
                    in[0] = tmp[0];
                    return 1;
                }

                @Override
                public void close() {
                    WindowsSupport.flushConsoleInputBuffer();
                }
            };
            this.input = new ConsoleInputSession(inStream);
        } else {
            this.input = new ConsoleInputSession(settings.getInputStream());
        }
    }

    @Override
    public int[] read() throws IOException {
        return this.input.readAll();
    }

    private int getHeight() {
        int height = WindowsSupport.getWindowsTerminalHeight();
        this.ttyPropsLastFetched = System.currentTimeMillis();
        if (height < 1) {
            if (this.settings.isLogging()) {
                LOGGER.log(Level.SEVERE, "Fetched terminal height is " + height + ", setting it to 24");
            }
            height = 24;
        }
        return height;
    }

    private int getWidth() {
        int width = WindowsSupport.getWindowsTerminalWidth();
        this.ttyPropsLastFetched = System.currentTimeMillis();
        if (width < 1) {
            if (this.settings.isLogging()) {
                LOGGER.log(Level.SEVERE, "Fetched terminal width is " + width + ", setting it to 80");
            }
            width = 80;
        }
        return width;
    }

    @Override
    public TerminalSize getSize() {
        if (this.propertiesTimedOut()) {
            if (this.size == null) {
                this.size = new TerminalSize(this.getHeight(), this.getWidth());
            } else {
                this.size.setHeight(this.getHeight());
                this.size.setWidth(this.getWidth());
            }
        }
        return this.size;
    }

    @Override
    public boolean isEchoEnabled() {
        return false;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void writeToInputStream(String data) {
        this.input.writeToInput(data);
    }

    @Override
    public void changeOutputStream(PrintStream output) {
        this.stdOut = output;
    }

    @Override
    public void close() throws IOException {
        this.input.stop();
    }

    private boolean propertiesTimedOut() {
        return System.currentTimeMillis() - this.ttyPropsLastFetched > TIMEOUT_PERIOD;
    }

    @Override
    public PrintStream err() {
        return this.stdErr;
    }

    @Override
    public PrintStream out() {
        return this.stdOut;
    }
}

