/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.uri.AbstractTransportConfigurationSchema;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class TCPTransportConfigurationSchema
extends AbstractTransportConfigurationSchema {
    private final Set<String> allowableProperties;

    public TCPTransportConfigurationSchema(Set<String> allowableProperties) {
        this.allowableProperties = allowableProperties;
    }

    public String getSchemaName() {
        return "tcp";
    }

    protected List<TransportConfiguration> internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        return TCPTransportConfigurationSchema.getTransportConfigurations(uri, query, this.allowableProperties, name, this.getFactoryName(uri));
    }

    protected URI internalNewURI(List<TransportConfiguration> bean) throws Exception {
        return null;
    }

    public static List<TransportConfiguration> getTransportConfigurations(URI uri, Map<String, String> query, Set<String> allowableProperties, String name, String factoryName) throws URISyntaxException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        URISchema.setData((URI)uri, props, allowableProperties, query);
        ArrayList<TransportConfiguration> transportConfigurations = new ArrayList<TransportConfiguration>();
        transportConfigurations.add(new TransportConfiguration(factoryName, props, name));
        String connectors = uri.getFragment();
        if (connectors != null) {
            String[] split;
            for (String s : split = connectors.split(",")) {
                URI extraUri = new URI(s);
                HashMap<String, Object> newProps = new HashMap<String, Object>();
                URISchema.setData((URI)extraUri, newProps, allowableProperties, query);
                URISchema.setData((URI)extraUri, newProps, allowableProperties, (Map)URISchema.parseQuery((String)extraUri.getQuery(), null));
                transportConfigurations.add(new TransportConfiguration(factoryName, newProps, name + ":" + extraUri.toString()));
            }
        }
        return transportConfigurations;
    }

    protected String getFactoryName(URI uri) {
        if (uri.getPath() != null && uri.getPath().contains("hornetq")) {
            return "org.hornetq.core.remoting.impl.netty.NettyConnectorFactory";
        }
        return NettyConnectorFactory.class.getName();
    }
}

