/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli;

import io.airlift.airline.Cli;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.activemq.artemis.cli.ConfigurationException;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.Create;
import org.apache.activemq.artemis.cli.commands.HelpAction;
import org.apache.activemq.artemis.cli.commands.Kill;
import org.apache.activemq.artemis.cli.commands.Run;
import org.apache.activemq.artemis.cli.commands.Stop;
import org.apache.activemq.artemis.cli.commands.tools.DecodeJournal;
import org.apache.activemq.artemis.cli.commands.tools.EncodeJournal;
import org.apache.activemq.artemis.cli.commands.tools.HelpData;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.cli.commands.tools.XmlDataExporter;
import org.apache.activemq.artemis.cli.commands.tools.XmlDataImporter;

public class Artemis {
    public static void main(String[] args) throws Exception {
        String instance = System.getProperty("artemis.instance");
        Cli.CliBuilder builder = Cli.builder((String)"artemis").withDescription("ActiveMQ Artemis Command Line").withCommand(HelpAction.class).withDefaultCommand(HelpAction.class);
        builder.withGroup("data").withDescription("data tools group (print|exp|imp|exp|encode|decode) (example ./artemis data print)").withDefaultCommand(HelpData.class).withCommands(PrintData.class, new Class[]{XmlDataExporter.class, XmlDataImporter.class, DecodeJournal.class, EncodeJournal.class});
        builder = instance != null ? builder.withCommands(Run.class, new Class[]{Stop.class, Kill.class}) : builder.withCommand(Create.class);
        Cli parser = builder.build();
        try {
            ((Action)parser.parse(args)).execute(ActionContext.system());
        }
        catch (ParseArgumentsUnexpectedException e) {
            System.err.println(e.getMessage());
            System.out.println();
            ((Action)parser.parse(new String[]{"help"})).execute(ActionContext.system());
        }
        catch (ConfigurationException configException) {
            System.err.println(configException.getMessage());
            System.out.println();
            System.out.println("Configuration should be specified as 'scheme:location'. Default configuration is 'xml:${ARTEMIS_INSTANCE}/etc/bootstrap.xml'");
        }
    }

    public static void printBanner() throws Exception {
        Artemis.copy(Artemis.class.getResourceAsStream("banner.txt"), System.out);
    }

    private static long copy(InputStream in, OutputStream out) throws Exception {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        return len;
    }
}

