/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.core.asyncio.impl.AsynchronousFileImpl;

@Command(name="create", description="creates a new broker instance")
public class Create
extends InputAbstract {
    private static final Integer DEFAULT_PORT = 61616;
    private static final Integer AMQP_PORT = 5672;
    private static final Integer STOMP_PORT = 61613;
    private static final Integer HQ_PORT = 5445;
    private static final Integer HTTP_PORT = 8161;
    public static final String BIN_ARTEMIS_CMD = "bin/artemis.cmd";
    public static final String BIN_ARTEMIS_SERVICE_EXE = "bin/artemis-service.exe";
    public static final String BIN_ARTEMIS_SERVICE_XML = "bin/artemis-service.xml";
    public static final String ETC_ARTEMIS_PROFILE_CMD = "etc/artemis.profile.cmd";
    public static final String BIN_ARTEMIS = "bin/artemis";
    public static final String BIN_ARTEMIS_SERVICE = "bin/artemis-service";
    public static final String ETC_ARTEMIS_PROFILE = "etc/artemis.profile";
    public static final String ETC_LOGGING_PROPERTIES = "etc/logging.properties";
    public static final String ETC_BOOTSTRAP_XML = "etc/bootstrap.xml";
    public static final String ETC_BROKER_XML = "etc/broker.xml";
    public static final String ETC_ARTEMIS_ROLES_PROPERTIES = "etc/artemis-roles.properties";
    public static final String ETC_ARTEMIS_USERS_PROPERTIES = "etc/artemis-users.properties";
    public static final String ETC_REPLICATED_SETTINGS_TXT = "etc/replicated-settings.txt";
    public static final String ETC_SHARED_STORE_SETTINGS_TXT = "etc/shared-store-settings.txt";
    public static final String ETC_CLUSTER_SECURITY_SETTINGS_TXT = "etc/cluster-security-settings.txt";
    public static final String ETC_CLUSTER_SETTINGS_TXT = "etc/cluster-settings.txt";
    public static final String ETC_CONNECTOR_SETTINGS_TXT = "etc/connector-settings.txt";
    public static final String ETC_BOOTSTRAP_WEB_SETTINGS_TXT = "etc/bootstrap-web-settings.txt";
    @Arguments(description="The instance directory to hold the broker's configuration and data", required=true)
    File directory;
    @Option(name={"--host"}, description="The host name of the broker (Default: 0.0.0.0 or input if clustered)")
    String host;
    @Option(name={"--port-offset"}, description="Off sets the default ports")
    int portOffset;
    @Option(name={"--force"}, description="Overwrite configuration at destination directory")
    boolean force;
    @Option(name={"--home"}, description="Directory where ActiveMQ Artemis is installed")
    File home;
    @Option(name={"--data"}, description="Directory where ActiveMQ Data is used. Path are relative to artemis.instance/bin")
    String data = "../data";
    @Option(name={"--clustered"}, description="Enable clustering")
    boolean clustered = false;
    @Option(name={"--max-hops"}, description="Number of hops on the cluster configuration")
    int maxHops = 0;
    @Option(name={"--replicated"}, description="Enable broker replication")
    boolean replicated = false;
    @Option(name={"--shared-store"}, description="Enable broker shared store")
    boolean sharedStore = false;
    @Option(name={"--cluster-user"}, description="The cluster user to use for clustering. (Default: input)")
    String clusterUser = null;
    @Option(name={"--cluster-password"}, description="The cluster password to use for clustering. (Default: input)")
    String clusterPassword = null;
    @Option(name={"--encoding"}, description="The encoding that text files should use")
    String encoding = "UTF-8";
    @Option(name={"--java-options"}, description="Extra java options to be passed to the profile")
    String javaOptions = "";
    @Option(name={"--allow-anonymous"}, description="Enables anonymous configuration on security (Default: input)")
    Boolean allowAnonymous = null;
    @Option(name={"--user"}, description="The username (Default: input)")
    String user;
    @Option(name={"--password"}, description="The user's password (Default: input)")
    String password;
    @Option(name={"--role"}, description="The name for the role created (Default: amq)")
    String role;
    @Option(name={"--no-web"}, description="This will remove the web server definition from bootstrap.xml")
    boolean noWeb;
    boolean IS_WINDOWS;
    boolean IS_CYGWIN;

    public int getMaxHops() {
        return this.maxHops;
    }

    public void setMaxHops(int maxHops) {
        this.maxHops = maxHops;
    }

    public boolean isNoWeb() {
        return this.noWeb;
    }

    public void setNoWeb(boolean noWeb) {
        this.noWeb = noWeb;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public void setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
    }

    public File getInstance() {
        return this.directory;
    }

    public void setInstance(File directory) {
        this.directory = directory;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = "0.0.0.0";
        }
        return this.host;
    }

    public String getHostForClustered() {
        if (this.getHost().equals("0.0.0.0")) {
            this.host = this.input("--host", "Host " + this.host + " is not valid for clustering, please provide a valid IP or hostname", "localhost");
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public File getHome() {
        if (this.home == null) {
            this.home = new File(System.getProperty("artemis.home"));
        }
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    public boolean isSharedStore() {
        return this.sharedStore;
    }

    public void setSharedStore(boolean sharedStore) {
        this.sharedStore = sharedStore;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getClusterUser() {
        if (this.clusterUser == null) {
            this.clusterUser = this.input("--cluster-user", "Please provide the username:", "cluster-admin");
        }
        return this.clusterUser;
    }

    public void setClusterUser(String clusterUser) {
        this.clusterUser = clusterUser;
    }

    public String getClusterPassword() {
        if (this.clusterPassword == null) {
            this.clusterPassword = this.inputPassword("--cluster-password", "Please enter the password:", "password-admin");
        }
        return this.clusterPassword;
    }

    public void setClusterPassword(String clusterPassword) {
        this.clusterPassword = clusterPassword;
    }

    public boolean isAllowAnonymous() {
        if (this.allowAnonymous == null) {
            String value = this.input("--allow-anonymous", "Allow anonymous access? (Y/N):", "Y");
            this.allowAnonymous = value.toLowerCase().equals("y");
        }
        return this.allowAnonymous;
    }

    public void setAllowAnonymous(boolean allowGuest) {
        this.allowAnonymous = allowGuest;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.inputPassword("--password", "Please provide the default password:", "admin");
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = this.input("--user", "Please provide the default username:", "admin");
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRole() {
        if (this.role == null) {
            this.role = "amq";
        }
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            return this.run(context);
        }
        catch (Throwable e) {
            e.printStackTrace(context.err);
            throw e;
        }
    }

    public InputStream openStream(String source) {
        return this.getClass().getResourceAsStream(source);
    }

    public Object run(ActionContext context) throws Exception {
        this.IS_WINDOWS = System.getProperty("os.name").toLowerCase().trim().startsWith("win");
        this.IS_CYGWIN = this.IS_WINDOWS && "cygwin".equals(System.getenv("OSTYPE"));
        context.out.println(String.format("Creating ActiveMQ Artemis instance at: %s", this.directory.getCanonicalPath()));
        HashMap<String, String> filters = new HashMap<String, String>();
        if (this.replicated) {
            this.clustered = true;
            filters.put("${replicated.settings}", this.readTextFile(ETC_REPLICATED_SETTINGS_TXT));
        } else {
            filters.put("${replicated.settings}", "");
        }
        if (this.sharedStore) {
            this.clustered = true;
            filters.put("${shared-store.settings}", this.readTextFile(ETC_SHARED_STORE_SETTINGS_TXT));
        } else {
            filters.put("${shared-store.settings}", "");
        }
        if (this.IS_WINDOWS || !AsynchronousFileImpl.isLoaded()) {
            filters.put("${journal.settings}", "NIO");
        } else {
            filters.put("${journal.settings}", "ASYNCIO");
        }
        filters.put("${user}", System.getProperty("user.name", ""));
        filters.put("${default.port}", String.valueOf(DEFAULT_PORT + this.portOffset));
        filters.put("${amqp.port}", String.valueOf(AMQP_PORT + this.portOffset));
        filters.put("${stomp.port}", String.valueOf(STOMP_PORT + this.portOffset));
        filters.put("${hq.port}", String.valueOf(HQ_PORT + this.portOffset));
        filters.put("${http.port}", String.valueOf(HTTP_PORT + this.portOffset));
        filters.put("${data.dir}", this.data);
        filters.put("${max-hops}", String.valueOf(this.maxHops));
        filters.put("${user}", this.getUser());
        filters.put("${password}", this.getPassword());
        filters.put("${role}", this.getRole());
        if (this.clustered) {
            filters.put("${host}", this.getHostForClustered());
            String connectorSettings = this.readTextFile(ETC_CONNECTOR_SETTINGS_TXT);
            connectorSettings = this.applyFilters(connectorSettings, filters);
            filters.put("${connector-config.settings}", connectorSettings);
            filters.put("${cluster-security.settings}", this.readTextFile(ETC_CLUSTER_SECURITY_SETTINGS_TXT));
            filters.put("${cluster.settings}", this.applyFilters(this.readTextFile(ETC_CLUSTER_SETTINGS_TXT), filters));
            filters.put("${cluster-user}", this.getClusterUser());
            filters.put("${cluster-password}", this.getClusterPassword());
        } else {
            filters.put("${host}", this.getHost());
            filters.put("${connector-config.settings}", "");
            filters.put("${cluster-security.settings}", "");
            filters.put("${cluster.settings}", "");
            filters.put("${cluster-user}", "");
            filters.put("${cluster-password}", "");
        }
        if (this.home != null) {
            filters.put("${home}", this.path(this.home, false));
        }
        filters.put("${artemis.home}", this.path(this.getHome().toString(), false));
        filters.put("${artemis.instance}", this.path(this.directory, false));
        filters.put("${artemis.instance.name}", this.directory.getName());
        filters.put("${java.home}", this.path(System.getProperty("java.home"), false));
        new File(this.directory, "bin").mkdirs();
        new File(this.directory, "etc").mkdirs();
        new File(this.directory, "log").mkdirs();
        new File(this.directory, "tmp").mkdirs();
        new File(this.directory, "data").mkdirs();
        if (this.javaOptions == null || this.javaOptions.length() == 0) {
            this.javaOptions = "";
        }
        filters.put("${java-opts}", this.javaOptions);
        if (this.IS_WINDOWS) {
            this.write(BIN_ARTEMIS_CMD, null, false);
            this.write(BIN_ARTEMIS_SERVICE_EXE);
            this.write(BIN_ARTEMIS_SERVICE_XML, filters, false);
            this.write(ETC_ARTEMIS_PROFILE_CMD, filters, false);
        }
        if (!this.IS_WINDOWS || this.IS_CYGWIN) {
            this.write(BIN_ARTEMIS, null, true);
            this.makeExec(BIN_ARTEMIS);
            this.write(BIN_ARTEMIS_SERVICE, null, true);
            this.makeExec(BIN_ARTEMIS_SERVICE);
            this.write(ETC_ARTEMIS_PROFILE, filters, true);
            this.makeExec(ETC_ARTEMIS_PROFILE);
        }
        this.write(ETC_LOGGING_PROPERTIES, null, false);
        if (this.isAllowAnonymous()) {
            filters.put("${bootstrap.guest}", "default-user=\"" + this.getUser() + "\"");
        } else {
            filters.put("${bootstrap.guest}", "");
        }
        if (this.noWeb) {
            filters.put("${bootstrap-web-settings}", "");
        } else {
            filters.put("${bootstrap-web-settings}", this.applyFilters(this.readTextFile(ETC_BOOTSTRAP_WEB_SETTINGS_TXT), filters));
        }
        this.write(ETC_BOOTSTRAP_XML, filters, false);
        this.write(ETC_BROKER_XML, filters, false);
        this.write(ETC_ARTEMIS_ROLES_PROPERTIES, filters, false);
        this.write(ETC_ARTEMIS_USERS_PROPERTIES, filters, false);
        context.out.println("");
        context.out.println("You can now start the broker by executing:  ");
        context.out.println("");
        context.out.println(String.format("   \"%s\" run", this.path(new File(this.directory, BIN_ARTEMIS), true)));
        File service = new File(this.directory, BIN_ARTEMIS_SERVICE);
        context.out.println("");
        if (!this.IS_WINDOWS || this.IS_CYGWIN) {
            if (new File("/etc/init.d/").isDirectory()) {
                context.out.println("Or you can setup the broker as system service and run it in the background:");
                context.out.println("");
                context.out.println(String.format(service.getCanonicalPath(), new Object[0]));
                context.out.println("   /etc/init.d/artemis-service start");
                context.out.println("");
            } else {
                context.out.println("Or you can run the broker in the background using:");
                context.out.println("");
                context.out.println(String.format("   \"%s\" start", this.path(service, true)));
                context.out.println("");
            }
        }
        if (this.IS_WINDOWS) {
            service = new File(this.directory, BIN_ARTEMIS_SERVICE_EXE);
            context.out.println("Or you can setup the broker as Windows service and run it in the background:");
            context.out.println("");
            context.out.println(String.format("   \"%s\" install", this.path(service, true)));
            context.out.println(String.format("   \"%s\" start", this.path(service, true)));
            context.out.println("");
            context.out.println("   To stop the windows service:");
            context.out.println(String.format("      \"%s\" stop", this.path(service, true)));
            context.out.println("");
            context.out.println("   To uninstall the windows service");
            context.out.println(String.format("      \"%s\" uninstall", this.path(service, true)));
        }
        return null;
    }

    private void makeExec(String path) throws IOException {
        try {
            File file = new File(this.directory, path);
            Files.setPosixFilePermissions(file.toPath(), new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    String path(String value, boolean unixPaths) throws IOException {
        return this.path(new File(value), unixPaths);
    }

    private String path(File value, boolean unixPaths) throws IOException {
        if (unixPaths && this.IS_CYGWIN) {
            return value.getCanonicalPath();
        }
        return value.getCanonicalPath();
    }

    private void write(String source, HashMap<String, String> filters, boolean unixTarget) throws IOException {
        this.write(source, new File(this.directory, source), filters, unixTarget);
    }

    private void write(String source, File target, HashMap<String, String> filters, boolean unixTarget) throws IOException {
        if (target.exists() && !this.force) {
            throw new RuntimeException(String.format("The file '%s' already exists.  Use --force to overwrite.", target));
        }
        String content = this.applyFilters(this.readTextFile(source), filters);
        String separator = unixTarget && this.IS_CYGWIN ? "\n" : System.getProperty("line.separator");
        content = content.replaceAll("\\r?\\n", Matcher.quoteReplacement(separator));
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(this.encoding));
        try (FileOutputStream fout = new FileOutputStream(target);){
            this.copy(in, fout);
        }
    }

    private String applyFilters(String content, HashMap<String, String> filters) throws IOException {
        if (filters != null) {
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                content = this.replace(content, entry.getKey(), entry.getValue());
            }
        }
        return content;
    }

    private String readTextFile(String source) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = this.openStream(source);){
            this.copy(in, out);
        }
        return new String(out.toByteArray(), "UTF-8");
    }

    private void write(String source) throws IOException {
        File target = new File(this.directory, source);
        if (target.exists() && !this.force) {
            throw new RuntimeException(String.format("The file '%s' already exists.  Use --force to overwrite.", target));
        }
        try (FileOutputStream fout = new FileOutputStream(target);
             InputStream in = this.openStream(source);){
            this.copy(in, fout);
        }
    }

    private String replace(String content, String key, String value) {
        return content.replaceAll(Pattern.quote(key), Matcher.quoteReplacement(value));
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int c = is.read(buffer);
        while (c >= 0) {
            os.write(buffer, 0, c);
            c = is.read(buffer);
        }
    }
}

