/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Option;
import java.util.Scanner;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.commands.ActionContext;

public class InputAbstract
extends ActionAbstract {
    private Scanner scanner;
    @Option(name={"--silent-input"}, description="It will disable all the inputs, and it would make a best guess for any required input")
    private boolean silentInput = false;

    public boolean isSilentInput() {
        return this.silentInput;
    }

    public void setSilentInput(boolean silentInput) {
        this.silentInput = silentInput;
    }

    protected String input(String propertyName, String prompt, String silentDefault) {
        String inputStr;
        if (this.silentInput) {
            return silentDefault;
        }
        boolean valid = false;
        System.out.println();
        do {
            this.context.out.println(propertyName + ": is mandatory with this configuration:");
            this.context.out.println(prompt);
            inputStr = this.scanner.nextLine();
            if (inputStr.trim().equals("")) {
                System.out.println("Invalid Entry!");
                continue;
            }
            valid = true;
        } while (!valid);
        return inputStr.trim();
    }

    protected String inputPassword(String propertyName, String prompt, String silentDefault) {
        String inputStr;
        if (this.silentInput) {
            return silentDefault;
        }
        boolean valid = false;
        System.out.println();
        do {
            this.context.out.println(propertyName + ": is mandatory with this configuration:");
            this.context.out.println(prompt);
            inputStr = new String(System.console().readPassword());
            if (inputStr.trim().equals("")) {
                System.out.println("Invalid Entry!");
                continue;
            }
            valid = true;
        } while (!valid);
        return inputStr.trim();
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.scanner = new Scanner(context.in);
        return null;
    }
}

