/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.XMLAttribute;
import org.jboss.as.clustering.jgroups.subsystem.XMLElement;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JGroupsSubsystemXMLReader
implements XMLElementReader<List<ModelNode>> {
    private final JGroupsSchema schema;

    JGroupsSubsystemXMLReader(JGroupsSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> result) throws XMLStreamException {
        String defaultStack;
        LinkedHashMap<PathAddress, ModelNode> operations = new LinkedHashMap<PathAddress, ModelNode>();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        if (!this.schema.since(JGroupsSchema.VERSION_3_0)) {
            defaultStack = JGroupsSubsystemXMLReader.require(reader, XMLAttribute.DEFAULT_STACK);
            JGroupsSubsystemXMLReader.setAttribute(reader, defaultStack, operation, JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK);
        }
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case CHANNELS: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0)) {
                        this.parseChannels(reader, address, operations);
                        continue block5;
                    }
                }
                case STACKS: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0)) {
                        this.parseStacks(reader, address, operations);
                        continue block5;
                    }
                }
                case STACK: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0)) break;
                    this.parseStack(reader, address, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!this.schema.since(JGroupsSchema.VERSION_4_0)) {
            defaultStack = operation.get(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK.getDefinition().getName());
            for (Map.Entry entry : operations.entrySet()) {
                ModelNode op;
                PathAddress opAddr = (PathAddress)entry.getKey();
                if (!opAddr.getLastElement().getKey().equals(ChannelResourceDefinition.WILDCARD_PATH.getKey()) || (op = (ModelNode)entry.getValue()).hasDefined(ChannelResourceDefinition.Attribute.STACK.getDefinition().getName())) continue;
                op.get(ChannelResourceDefinition.Attribute.STACK.getDefinition().getName()).set((ModelNode)defaultStack);
            }
        }
        result.addAll(operations.values());
    }

    private void parseChannels(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case CHANNEL: {
                    this.parseChannel(reader, address, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseChannel(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block8;
                }
                case STACK: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, ChannelResourceDefinition.Attribute.STACK);
                    continue block8;
                }
                case MODULE: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, ChannelResourceDefinition.Attribute.MODULE);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case FORK: {
                    this.parseFork(reader, address, operations);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFork(XMLExtendedStreamReader reader, PathAddress channelAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = channelAddress.append(new PathElement[]{ForkResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case PROTOCOL: {
                    this.parseProtocol(reader, address, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStacks(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case STACK: {
                    this.parseStack(reader, address, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStack(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, address, operations);
                    continue block5;
                }
                case PROTOCOL: {
                    this.parseProtocol(reader, address, operations);
                    continue block5;
                }
                case RELAY: {
                    if (!this.schema.since(JGroupsSchema.VERSION_2_0)) break;
                    this.parseRelay(reader, address, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String type = JGroupsSubsystemXMLReader.require(reader, XMLAttribute.TYPE);
        PathAddress address = stackAddress.append(new PathElement[]{TransportResourceDefinition.pathElement(type)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SHARED: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.Attribute.SHARED);
                    continue block11;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.Attribute.DIAGNOSTICS_SOCKET_BINDING);
                    continue block11;
                }
                case DEFAULT_EXECUTOR: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.ThreadingAttribute.DEFAULT_EXECUTOR);
                    continue block11;
                }
                case OOB_EXECUTOR: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.ThreadingAttribute.OOB_EXECUTOR);
                    continue block11;
                }
                case TIMER_EXECUTOR: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.ThreadingAttribute.TIMER_EXECUTOR);
                    continue block11;
                }
                case THREAD_FACTORY: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.ThreadingAttribute.THREAD_FACTORY);
                    continue block11;
                }
                case SITE: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1)) {
                        JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.Attribute.SITE);
                        continue block11;
                    }
                }
                case RACK: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1)) {
                        JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.Attribute.RACK);
                        continue block11;
                    }
                }
                case MACHINE: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1)) {
                        JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, TransportResourceDefinition.Attribute.MACHINE);
                        continue block11;
                    }
                }
                default: {
                    this.parseProtocolAttribute(reader, i, operation);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseProtocolElement(reader, address, operations);
        }
    }

    private void parseProtocol(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String type = JGroupsSubsystemXMLReader.require(reader, XMLAttribute.TYPE);
        PathAddress address = stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement(type)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseProtocolAttribute(reader, i, operation);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseProtocolElement(reader, address, operations);
        }
    }

    private void parseProtocolAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case TYPE: {
                break;
            }
            case SOCKET_BINDING: {
                JGroupsSubsystemXMLReader.readAttribute(reader, index, operation, ProtocolResourceDefinition.Attribute.SOCKET_BINDING);
                break;
            }
            case MODULE: {
                if (this.schema.since(JGroupsSchema.VERSION_3_0)) {
                    JGroupsSubsystemXMLReader.readAttribute(reader, index, operation, ProtocolResourceDefinition.Attribute.MODULE);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseProtocolElement(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        XMLElement element = XMLElement.forName(reader.getLocalName());
        switch (element) {
            case PROPERTY: {
                this.parseProperty(reader, address, operations);
                break;
            }
            case DEFAULT_THREAD_POOL: {
                this.parseThreadPool(ThreadPoolResourceDefinition.DEFAULT, reader, address, operations);
                break;
            }
            case INTERNAL_THREAD_POOL: {
                this.parseThreadPool(ThreadPoolResourceDefinition.INTERNAL, reader, address, operations);
                break;
            }
            case OOB_THREAD_POOL: {
                this.parseThreadPool(ThreadPoolResourceDefinition.OOB, reader, address, operations);
                break;
            }
            case TIMER_THREAD_POOL: {
                this.parseThreadPool(ThreadPoolResourceDefinition.TIMER, reader, address, operations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)XMLAttribute.NAME.getLocalName());
        JGroupsSubsystemXMLReader.readAttribute(reader, 0, operation, ProtocolResourceDefinition.Attribute.PROPERTIES);
    }

    private void parseThreadPool(ThreadPoolResourceDefinition pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{pool.getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MIN_THREADS: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMinThreads());
                    continue block6;
                }
                case MAX_THREADS: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMaxThreads());
                    continue block6;
                }
                case QUEUE_LENGTH: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, pool.getQueueLength());
                    continue block6;
                }
                case KEEPALIVE_TIME: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, pool.getKeepAliveTime());
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRelay(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, RelayResourceDefinition.Attribute.SITE);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!operation.hasDefined(RelayResourceDefinition.Attribute.SITE.getDefinition().getName())) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(XMLAttribute.SITE));
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    this.parseRemoteSite(reader, address, operations);
                    continue block8;
                }
                case PROPERTY: {
                    this.parseProperty(reader, address, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteSite(XMLExtendedStreamReader reader, PathAddress relayAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String site = JGroupsSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.pathElement(site)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        String cluster = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block6;
                }
                case STACK: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, RemoteSiteResourceDefinition.DeprecatedAttribute.STACK);
                    continue block6;
                }
                case CLUSTER: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    cluster = value;
                    continue block6;
                }
                case CHANNEL: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0)) {
                        JGroupsSubsystemXMLReader.readAttribute(reader, i, operation, RemoteSiteResourceDefinition.Attribute.CHANNEL);
                        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
                        PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement(value)});
                        ModelNode channelOperation = operations.get(channelAddress);
                        if (channelOperation == null) continue block6;
                        String stack = channelOperation.hasDefined(ChannelResourceDefinition.Attribute.STACK.getDefinition().getName()) ? channelOperation.get(ChannelResourceDefinition.Attribute.STACK.getDefinition().getName()).asString() : operations.get(subsystemAddress).get(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK.getDefinition().getName()).asString();
                        JGroupsSubsystemXMLReader.setAttribute(reader, stack, operation, RemoteSiteResourceDefinition.DeprecatedAttribute.STACK);
                        continue block6;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (this.schema.since(JGroupsSchema.VERSION_3_0)) {
            if (!operation.hasDefined(RemoteSiteResourceDefinition.Attribute.CHANNEL.getDefinition().getName())) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(XMLAttribute.CHANNEL));
            }
        } else {
            if (!operation.hasDefined(RemoteSiteResourceDefinition.DeprecatedAttribute.STACK.getDefinition().getName())) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(XMLAttribute.STACK));
            }
            String channel = cluster != null ? cluster : site;
            JGroupsSubsystemXMLReader.setAttribute(reader, channel, operation, RemoteSiteResourceDefinition.Attribute.CHANNEL);
            PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
            PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement(channel)});
            ModelNode channelOperation = Util.createAddOperation((PathAddress)channelAddress);
            String stack = operation.get(RemoteSiteResourceDefinition.DeprecatedAttribute.STACK.getDefinition().getName()).asString();
            JGroupsSubsystemXMLReader.setAttribute(reader, stack, channelOperation, ChannelResourceDefinition.Attribute.STACK);
            operations.put(channelAddress, channelOperation);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static String require(XMLExtendedStreamReader reader, XMLAttribute attribute) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getLocalName());
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
        }
        return value;
    }

    private static void readAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation, Attribute attribute) throws XMLStreamException {
        JGroupsSubsystemXMLReader.setAttribute(reader, reader.getAttributeValue(index), operation, attribute);
    }

    private static void setAttribute(XMLExtendedStreamReader reader, String value, ModelNode operation, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getParser().parseAndSetParameter((AttributeDefinition)attribute.getDefinition(), value, operation, (XMLStreamReader)reader);
    }
}

