/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.jboss.jaxb.intros.BindingCustomizationFactory;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.ws.api.binding.JAXBBindingCustomization;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class JAXBIntroDeploymentAspect
extends AbstractDeploymentAspect {
    private static final String META_INF_JAXB_INTROS_XML = "META-INF/jaxb-intros.xml";
    private static final String WEB_INF_JAXB_INTROS_XML = "WEB-INF/jaxb-intros.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Deployment deployment) {
        UnifiedVirtualFile vfs2;
        if (!(deployment instanceof ArchiveDeployment)) {
            if (Loggers.DEPLOYMENT_LOGGER.isTraceEnabled()) {
                Loggers.DEPLOYMENT_LOGGER.aspectDoesNotWorkOnDeployment(this.getClass(), deployment.getClass());
            }
            return;
        }
        ArchiveDeployment archive = (ArchiveDeployment)deployment;
        InputStream introsConfigStream = null;
        URL url = null;
        try {
            vfs2 = archive.getRootFile().findChildFailSafe(META_INF_JAXB_INTROS_XML);
            if (vfs2 != null) {
                url = vfs2.toURL();
                introsConfigStream = url.openStream();
            }
        }
        catch (Exception vfs2) {
            // empty catch block
        }
        if (null == introsConfigStream) {
            try {
                vfs2 = archive.getRootFile().findChildFailSafe(WEB_INF_JAXB_INTROS_XML);
                if (vfs2 != null) {
                    url = vfs2.toURL();
                    introsConfigStream = url.openStream();
                }
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            if (introsConfigStream != null) {
                JAXBBindingCustomization jaxbCustomizations = new JAXBBindingCustomization();
                BindingCustomizationFactory.populateBindingCustomization((InputStream)introsConfigStream, (Map)jaxbCustomizations);
                deployment.addAttachment(BindingCustomization.class, (Object)jaxbCustomizations);
                for (Endpoint endpoint : deployment.getService().getEndpoints()) {
                    endpoint.addAttachment(BindingCustomization.class, (Object)jaxbCustomizations);
                }
            }
        }
        finally {
            if (introsConfigStream != null) {
                try {
                    introsConfigStream.close();
                }
                catch (IOException e) {
                    Loggers.DEPLOYMENT_LOGGER.errorClosingJAXBIntroConf(url, e);
                }
            }
        }
    }
}

