/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.clustering.singleton.SingletonModel;
import org.wildfly.extension.clustering.singleton.SingletonResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonSchema;
import org.wildfly.extension.clustering.singleton.SingletonXMLReader;
import org.wildfly.extension.clustering.singleton.SingletonXMLWriter;

public class SingletonExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "singleton";

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, SingletonModel.CURRENT.getVersion());
        registration.registerSubsystemModel((ResourceDefinition)new SingletonResourceDefinition());
        registration.registerXMLElementWriter((XMLElementWriter)new SingletonXMLWriter());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (SingletonSchema schema : SingletonSchema.values()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new SingletonXMLReader(schema));
        }
    }
}

