/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jbossweb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Attribute;
import org.jboss.metadata.parser.jbossweb.ContainerListenerMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Element;
import org.jboss.metadata.parser.jbossweb.HttpHandlerMetaDataParser;
import org.jboss.metadata.parser.jbossweb.JBossAnnotationMetaDataParser;
import org.jboss.metadata.parser.jbossweb.JBossServletMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Location;
import org.jboss.metadata.parser.jbossweb.ReplicationConfigParser;
import org.jboss.metadata.parser.jbossweb.ValveMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Version;
import org.jboss.metadata.parser.servlet.SessionConfigMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.jboss.ContainerListenerMetaData;
import org.jboss.metadata.web.jboss.HttpHandlerMetaData;
import org.jboss.metadata.web.jboss.JBoss4xDTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50DTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50WebMetaData;
import org.jboss.metadata.web.jboss.JBoss60WebMetaData;
import org.jboss.metadata.web.jboss.JBoss70WebMetaData;
import org.jboss.metadata.web.jboss.JBoss80WebMetaData;
import org.jboss.metadata.web.jboss.JBossAnnotationsMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ValveMetaData;

public class JBossWebMetaDataParser
extends MetaDataElementParser {
    private static final Logger log = Logger.getLogger(JBossWebMetaDataParser.class);
    private static final Set<String> DEPRECATED_ELEMENTS = new HashSet<String>(Arrays.asList("passivation-config"));

    public static JBossWebMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            if (reader.getEventType() != 11) continue;
            String dtdLocation = JBossWebMetaDataParser.readDTDLocation((XMLStreamReader)reader);
            if (dtdLocation != null) {
                version = Location.getVersion(dtdLocation);
            }
            if (version != null) continue;
            version = Version.JBOSS_WEB_5_0;
        }
        String schemaLocation = JBossWebMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = Location.getVersion(schemaLocation);
        }
        if (version == null) {
            version = Version.JBOSS_WEB_6_0;
        }
        JBossWebMetaData wmd = null;
        switch (version) {
            case JBOSS_WEB_3_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_3_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_0: {
                wmd = new JBoss50DTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_1: {
                wmd = new JBoss50WebMetaData();
                break;
            }
            case JBOSS_WEB_6_0: {
                wmd = new JBoss60WebMetaData();
                break;
            }
            case JBOSS_WEB_7_0: {
                wmd = new JBoss70WebMetaData();
                break;
            }
            case JBOSS_WEB_7_1: {
                wmd = new JBoss70WebMetaData();
                break;
            }
            case JBOSS_WEB_8_0: {
                wmd = new JBoss80WebMetaData();
                break;
            }
            case JBOSS_WEB_10_0: {
                wmd = new JBoss80WebMetaData();
            }
        }
        int count = reader.getAttributeCount();
        block46: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JBossWebMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    wmd.setVersion(value);
                    continue block46;
                }
                default: {
                    throw JBossWebMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
        block47: while (reader.hasNext() && reader.nextTag() != 2) {
            if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)env, (PropertyReplacer)propertyReplacer)) {
                if (wmd.getJndiEnvironmentRefsGroup() != null) continue;
                wmd.setJndiEnvironmentRefsGroup((Environment)env);
                continue;
            }
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case CONTEXT_ROOT: {
                    wmd.setContextRoot(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case VIRTUAL_HOST: {
                    List<String> virtualHosts = wmd.getVirtualHosts();
                    if (virtualHosts == null) {
                        virtualHosts = new ArrayList<String>();
                        wmd.setVirtualHosts(virtualHosts);
                        virtualHosts.add(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                        continue block47;
                    }
                    throw JBossWebMetaDataParser.duplicateNamedElement((XMLStreamReader)reader, (String)Element.VIRTUAL_HOST.toString());
                }
                case ANNOTATION: {
                    JBossAnnotationsMetaData annotations = wmd.getAnnotations();
                    if (annotations == null) {
                        annotations = new JBossAnnotationsMetaData();
                        wmd.setAnnotations(annotations);
                    }
                    annotations.add((MappableMetaData)JBossAnnotationMetaDataParser.parse(reader, propertyReplacer));
                    continue block47;
                }
                case LISTENER: {
                    List<ContainerListenerMetaData> listeners = wmd.getContainerListeners();
                    if (listeners == null) {
                        listeners = new ArrayList<ContainerListenerMetaData>();
                        wmd.setContainerListeners(listeners);
                    }
                    listeners.add(ContainerListenerMetaDataParser.parse(reader, propertyReplacer));
                    continue block47;
                }
                case SESSION_CONFIG: {
                    wmd.setSessionConfig(SessionConfigMetaDataParser.parse(reader, propertyReplacer));
                    continue block47;
                }
                case VALVE: {
                    List<ValveMetaData> valves = wmd.getValves();
                    if (valves == null) {
                        valves = new ArrayList<ValveMetaData>();
                        wmd.setValves(valves);
                    }
                    valves.add(ValveMetaDataParser.parse(reader, propertyReplacer));
                    continue block47;
                }
                case HTTP_HANDLER: {
                    List<HttpHandlerMetaData> handlers = wmd.getHandlers();
                    if (handlers == null) {
                        handlers = new ArrayList<HttpHandlerMetaData>();
                        wmd.setHandlers(handlers);
                    }
                    handlers.add(HttpHandlerMetaDataParser.parse(reader, propertyReplacer));
                    continue block47;
                }
                case OVERLAY: {
                    List<String> overlays = wmd.getOverlays();
                    if (overlays == null) {
                        overlays = new ArrayList<String>();
                        wmd.setOverlays(overlays);
                    }
                    overlays.add(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case SECURITY_DOMAIN: {
                    wmd.setSecurityDomain(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case SECURITY_ROLE: {
                    SecurityRolesMetaData securityRoles = wmd.getSecurityRoles();
                    if (securityRoles == null) {
                        securityRoles = new SecurityRolesMetaData();
                        wmd.setSecurityRoles(securityRoles);
                    }
                    securityRoles.add((MappableMetaData)SecurityRoleMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case JACC_STAR_ROLE_ALLOW: {
                    wmd.setJaccAllStoreRole(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case JACC_CONTEXT_ID: {
                    wmd.setJaccContextID(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case DISABLE_CROSS_CONTEXT: {
                    wmd.setDisableCrossContext(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case ENABLE_WEBSOCKETS: {
                    wmd.setEnableWebSockets(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case USE_JBOSS_AUTHORIZATION: {
                    wmd.setUseJBossAuthorization(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case DISABLE_AUDIT: {
                    wmd.setDisableAudit(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case SERVLET: {
                    JBossServletsMetaData servlets = wmd.getServlets();
                    if (servlets == null) {
                        servlets = new JBossServletsMetaData();
                        wmd.setServlets(servlets);
                    }
                    servlets.add((MappableMetaData)JBossServletMetaDataParser.parse(reader, propertyReplacer));
                    continue block47;
                }
                case MAX_ACTIVE_SESSIONS: {
                    wmd.setMaxActiveSessions(Integer.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case REPLICATION_CONFIG: {
                    wmd.setReplicationConfig(ReplicationConfigParser.parse(reader, propertyReplacer));
                    continue block47;
                }
                case DISTINCT_NAME: {
                    String val = JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                    wmd.setDistinctName(val);
                    continue block47;
                }
                case SYMBOLIC_ENABLED: {
                    wmd.setSymbolicLinkingEnabled(Boolean.parseBoolean(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case SERVLET_CONTAINER: {
                    wmd.setServletContainerName(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case DEFAULT_ENCODING: {
                    wmd.setDefaultEncoding(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case SERVER_INSTANCE: {
                    wmd.setServerInstanceName(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case DENY_UNCOVERED_HTTP_METHODS: {
                    wmd.setDenyUncoveredHttpMethods(Boolean.parseBoolean(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
                case EXECUTOR_NAME: {
                    wmd.setExecutorName(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block47;
                }
                case PROACTIVE_AUTHENTICATION: {
                    wmd.setProactiveAuthentication(Boolean.parseBoolean(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block47;
                }
            }
            if (DEPRECATED_ELEMENTS.contains(localName)) {
                log.warnf("<%s/> is no longer supported and will be ignored", (Object)localName);
                while (reader.hasNext() && reader.nextTag() != 2) {
                    reader.getElementText();
                }
                continue;
            }
            throw JBossWebMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return wmd;
    }
}

