/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jberet.job.model.AbstractPropertiesBuilder;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.ExceptionClassFilter;
import org.jberet.job.model.JobBuilder;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Partition;
import org.jberet.job.model.PartitionPlan;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Step;
import org.jberet.job.model.Transition;

public final class StepBuilder
extends AbstractPropertiesBuilder<StepBuilder> {
    private final String id;
    private int startLimit;
    private boolean allowStartIfComplete;
    private String next;
    private Listeners listeners;
    private RefArtifact batchlet;
    private final Chunk chunk = new Chunk();
    private final Partition partition = new Partition();
    private final List<Transition> transitions = new ArrayList<Transition>();

    public StepBuilder(String id) {
        this.id = id;
    }

    public StepBuilder startLimit(int i) {
        this.startLimit = i;
        return this;
    }

    public StepBuilder allowStartIfComplete(boolean ... b) {
        this.allowStartIfComplete = b.length == 0 ? true : b[0];
        return this;
    }

    public StepBuilder next(String next) {
        this.next = next;
        return this;
    }

    public StepBuilder listener(String listenerRef, String[] ... pairsOfKeyValue) {
        if (this.listeners == null) {
            this.listeners = new Listeners();
        }
        this.listeners.getListeners().add(JobBuilder.createRefArtifactWithProperties(listenerRef, null, pairsOfKeyValue));
        return this;
    }

    public StepBuilder listener(String listenerRef, java.util.Properties props) {
        if (this.listeners == null) {
            this.listeners = new Listeners();
        }
        this.listeners.getListeners().add(JobBuilder.createRefArtifactWithProperties(listenerRef, props, new String[0][]));
        return this;
    }

    public StepBuilder batchlet(String batchletRef, String[] ... pairsOfKeyValue) {
        this.batchlet = JobBuilder.createRefArtifactWithProperties(batchletRef, null, pairsOfKeyValue);
        return this;
    }

    public StepBuilder batchlet(String batchletRef, java.util.Properties props) {
        this.batchlet = JobBuilder.createRefArtifactWithProperties(batchletRef, props, new String[0][]);
        return this;
    }

    public Transition.End<StepBuilder> endOn(String exitStatus) {
        Transition.End<StepBuilder> end = new Transition.End<StepBuilder>(exitStatus);
        end.enclosingBuilder = this;
        this.transitions.add(end);
        return end;
    }

    public Transition.Fail<StepBuilder> failOn(String exitStatus) {
        Transition.Fail<StepBuilder> fail = new Transition.Fail<StepBuilder>(exitStatus);
        fail.enclosingBuilder = this;
        this.transitions.add(fail);
        return fail;
    }

    public Transition.Stop<StepBuilder> stopOn(String exitStatus) {
        Transition.Stop<StepBuilder> stop = new Transition.Stop<StepBuilder>(exitStatus, null);
        stop.enclosingBuilder = this;
        this.transitions.add(stop);
        return stop;
    }

    public Transition.Next<StepBuilder> nextOn(String exitStatus) {
        Transition.Next<StepBuilder> nx = new Transition.Next<StepBuilder>(exitStatus);
        nx.enclosingBuilder = this;
        this.transitions.add(nx);
        return nx;
    }

    public StepBuilder partitionMapper(String partitionMapperRef, String[] ... pairsOfKeyValue) {
        this.partition.setMapper(JobBuilder.createRefArtifactWithProperties(partitionMapperRef, null, pairsOfKeyValue));
        return this;
    }

    public StepBuilder partitionMapper(String partitionMapperRef, java.util.Properties props) {
        this.partition.setMapper(JobBuilder.createRefArtifactWithProperties(partitionMapperRef, props, new String[0][]));
        return this;
    }

    public StepBuilder partitionCollector(String partitionCollectorRef, String[] ... pairsOfKeyValue) {
        this.partition.setCollector(JobBuilder.createRefArtifactWithProperties(partitionCollectorRef, null, pairsOfKeyValue));
        return this;
    }

    public StepBuilder partitionCollector(String partitionCollectorRef, java.util.Properties props) {
        this.partition.setCollector(JobBuilder.createRefArtifactWithProperties(partitionCollectorRef, props, new String[0][]));
        return this;
    }

    public StepBuilder partitionAnalyzer(String partitionAnalyzerRef, String[] ... pairsOfKeyValue) {
        this.partition.setAnalyzer(JobBuilder.createRefArtifactWithProperties(partitionAnalyzerRef, null, pairsOfKeyValue));
        return this;
    }

    public StepBuilder partitionAnalyzer(String partitionAnalyzerRef, java.util.Properties props) {
        this.partition.setAnalyzer(JobBuilder.createRefArtifactWithProperties(partitionAnalyzerRef, props, new String[0][]));
        return this;
    }

    public StepBuilder partitionReducer(String partitionReducerRef, String[] ... pairsOfKeyValue) {
        this.partition.setReducer(JobBuilder.createRefArtifactWithProperties(partitionReducerRef, null, pairsOfKeyValue));
        return this;
    }

    public StepBuilder partitionReducer(String partitionReducerRef, java.util.Properties props) {
        this.partition.setReducer(JobBuilder.createRefArtifactWithProperties(partitionReducerRef, props, new String[0][]));
        return this;
    }

    public StepBuilder partitionPlan(int partitionCount, int threadCount, List<java.util.Properties> listOfPartitionProps) {
        PartitionPlan plan = new PartitionPlan();
        plan.setPartitions(String.valueOf(partitionCount));
        plan.setThreads(String.valueOf(threadCount));
        if (listOfPartitionProps != null) {
            for (int i = 0; i < listOfPartitionProps.size(); ++i) {
                java.util.Properties juprops = listOfPartitionProps.get(i);
                Properties props = new Properties();
                props.setPartition(String.valueOf(i));
                for (String k : juprops.stringPropertyNames()) {
                    props.add(k, juprops.getProperty(k));
                }
                plan.addProperties(props);
            }
        }
        this.partition.setPlan(plan);
        return this;
    }

    public StepBuilder partitionPlan(int partitionCount, List<java.util.Properties> listOfPartitionProps) {
        return this.partitionPlan(partitionCount, partitionCount, listOfPartitionProps);
    }

    public StepBuilder partitionPlan(int partitionCount, int ... threadCount) {
        return this.partitionPlan(partitionCount, threadCount.length == 0 ? partitionCount : threadCount[0], null);
    }

    public StepBuilder reader(String readerRef, String[] ... pairsOfKeyValue) {
        this.chunk.reader = JobBuilder.createRefArtifactWithProperties(readerRef, null, pairsOfKeyValue);
        return this;
    }

    public StepBuilder reader(String readerRef, java.util.Properties props) {
        this.chunk.reader = JobBuilder.createRefArtifactWithProperties(readerRef, props, new String[0][]);
        return this;
    }

    public StepBuilder writer(String writerRef, String[] ... pairsOfKeyValue) {
        this.chunk.writer = JobBuilder.createRefArtifactWithProperties(writerRef, null, pairsOfKeyValue);
        return this;
    }

    public StepBuilder writer(String writerRef, java.util.Properties props) {
        this.chunk.writer = JobBuilder.createRefArtifactWithProperties(writerRef, props, new String[0][]);
        return this;
    }

    public StepBuilder processor(String processorRef, String[] ... pairsOfKeyValue) {
        this.chunk.processor = JobBuilder.createRefArtifactWithProperties(processorRef, null, pairsOfKeyValue);
        return this;
    }

    public StepBuilder processor(String processorRef, java.util.Properties props) {
        this.chunk.processor = JobBuilder.createRefArtifactWithProperties(processorRef, props, new String[0][]);
        return this;
    }

    public StepBuilder checkpointAlgorithm(String checkpointAlgorithmRef, String[] ... pairsOfKeyValue) {
        this.chunk.checkpointAlgorithm = JobBuilder.createRefArtifactWithProperties(checkpointAlgorithmRef, null, pairsOfKeyValue);
        return this;
    }

    public StepBuilder checkpointAlgorithm(String checkpointAlgorithmRef, java.util.Properties props) {
        this.chunk.checkpointAlgorithm = JobBuilder.createRefArtifactWithProperties(checkpointAlgorithmRef, props, new String[0][]);
        return this;
    }

    public StepBuilder checkpointPolicy(String checkpointPolicy) {
        this.chunk.checkpointPolicy = checkpointPolicy;
        return this;
    }

    public StepBuilder itemCount(int itemCount) {
        this.chunk.itemCount = String.valueOf(itemCount);
        return this;
    }

    public StepBuilder timeLimit(int timeLimit, TimeUnit ... timeUnit) {
        this.chunk.timeLimit = timeUnit.length == 0 ? String.valueOf(timeLimit) : String.valueOf(TimeUnit.SECONDS.convert(timeLimit, timeUnit[0]));
        return this;
    }

    public StepBuilder skipLimit(int skipLimit) {
        this.chunk.skipLimit = String.valueOf(skipLimit);
        return this;
    }

    public StepBuilder retryLimit(int retryLimit) {
        this.chunk.retryLimit = String.valueOf(retryLimit);
        return this;
    }

    public StepBuilder skippableExceptionsInclude(Class<? extends Exception> ... exceptionClasses) {
        if (this.chunk.skippableExceptionClasses == null) {
            this.chunk.skippableExceptionClasses = new ExceptionClassFilter();
        }
        for (Class<? extends Exception> cl : exceptionClasses) {
            this.chunk.skippableExceptionClasses.include.add(cl.getName());
        }
        return this;
    }

    public StepBuilder skippableExceptionsExclude(Class<? extends Exception> ... exceptionClasses) {
        if (this.chunk.skippableExceptionClasses == null) {
            this.chunk.skippableExceptionClasses = new ExceptionClassFilter();
        }
        for (Class<? extends Exception> cl : exceptionClasses) {
            this.chunk.skippableExceptionClasses.exclude.add(cl.getName());
        }
        return this;
    }

    public StepBuilder retryableExceptionsInclude(Class<? extends Exception> ... exceptionClasses) {
        if (this.chunk.retryableExceptionClasses == null) {
            this.chunk.retryableExceptionClasses = new ExceptionClassFilter();
        }
        for (Class<? extends Exception> cl : exceptionClasses) {
            this.chunk.retryableExceptionClasses.include.add(cl.getName());
        }
        return this;
    }

    public StepBuilder retryableExceptionsExclude(Class<? extends Exception> ... exceptionClasses) {
        if (this.chunk.retryableExceptionClasses == null) {
            this.chunk.retryableExceptionClasses = new ExceptionClassFilter();
        }
        for (Class<? extends Exception> cl : exceptionClasses) {
            this.chunk.retryableExceptionClasses.exclude.add(cl.getName());
        }
        return this;
    }

    public StepBuilder noRollbackExceptionsInclude(Class<? extends Exception> ... exceptionClasses) {
        if (this.chunk.noRollbackExceptionClasses == null) {
            this.chunk.noRollbackExceptionClasses = new ExceptionClassFilter();
        }
        for (Class<? extends Exception> cl : exceptionClasses) {
            this.chunk.noRollbackExceptionClasses.include.add(cl.getName());
        }
        return this;
    }

    public StepBuilder noRollbackExceptionsExclude(Class<? extends Exception> ... exceptionClasses) {
        if (this.chunk.noRollbackExceptionClasses == null) {
            this.chunk.noRollbackExceptionClasses = new ExceptionClassFilter();
        }
        for (Class<? extends Exception> cl : exceptionClasses) {
            this.chunk.noRollbackExceptionClasses.exclude.add(cl.getName());
        }
        return this;
    }

    public Step build() {
        Step step = new Step(this.id);
        step.startLimit = String.valueOf(this.startLimit);
        step.allowStartIfComplete = String.valueOf(this.allowStartIfComplete);
        step.next = this.next;
        step.setListeners(this.listeners);
        if (this.nameValues.size() > 0) {
            step.setProperties(this.nameValuesToProperties(this.nameValues));
        }
        if (this.chunk.reader != null) {
            step.chunk = this.chunk;
        }
        step.batchlet = this.batchlet;
        if (this.partition.getPlan() != null || this.partition.getMapper() != null) {
            step.partition = this.partition;
        }
        step.getTransitionElements().addAll(this.transitions);
        return step;
    }
}

