/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;

public final class WriteOnlyKeyCommand<K, V>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 54;
    private Consumer<EntryView.WriteEntryView<V>> f;

    public WriteOnlyKeyCommand(K key, Consumer<EntryView.WriteEntryView<V>> f, CommandInvocationId id) {
        super(key, f.getClass().getAnnotation(SerializeWith.class), id);
        this.f = f;
    }

    public WriteOnlyKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return 54;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 54) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.f = (Consumer)parameters[1];
        this.valueMatcher = (ValueMatcher)((Object)parameters[2]);
        this.flags = (Set)parameters[3];
        this.commandInvocationId = (CommandInvocationId)parameters[4];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.f, this.valueMatcher, Flag.copyWithoutRemotableFlags(this.flags), this.commandInvocationId};
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyKeyCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        this.f.accept(EntryViews.writeOnly(e));
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }
}

