/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.impl.RemovableCloseableIterator;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.LocalKeyCacheStream;
import org.infinispan.stream.impl.local.LocalValueCacheStream;

public class LocalEntryCacheStream<K, V>
extends AbstractLocalCacheStream<CacheEntry<K, V>, K, V> {
    private final Cache<K, V> cache;

    public LocalEntryCacheStream(Cache<K, V> cache, boolean parallel, ConsistentHash hash, Supplier<Stream<CacheEntry<K, V>>> supplier, ComponentRegistry registry) {
        super(parallel, hash, supplier, registry);
        this.cache = cache;
    }

    @Override
    protected Stream<CacheEntry<K, V>> getStream() {
        Stream<CacheEntry> stream;
        if (this.keysToFilter != null) {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            this.log.tracef("Applying key filtering %s", this.keysToFilter);
            stream = (this.parallel ? this.keysToFilter.parallelStream() : this.keysToFilter.stream()).map((? super T k) -> advancedCache.getCacheEntry(k)).filter((? super T e) -> e != null);
        } else {
            stream = (Stream<CacheEntry>)this.supplier.get();
        }
        if (this.segmentsToFilter != null && this.hash != null) {
            this.log.tracef("Applying segment filter %s", this.segmentsToFilter);
            stream = stream.filter((? super T k) -> this.segmentsToFilter.contains(this.hash.getSegment(k.getKey())));
        }
        return stream;
    }

    @Override
    protected CloseableIterator<CacheEntry<K, V>> removableIterator(CloseableIterator<CacheEntry<K, V>> realIterator) {
        return new RemovableCloseableIterator<Object, CacheEntry>(realIterator, this.cache, CacheEntry::getKey);
    }

    LocalValueCacheStream<K, V> toLocalValueCacheStream() {
        return new LocalValueCacheStream<K, V>(this.cache, this.parallel, this.hash, this.supplier, this.registry);
    }

    LocalKeyCacheStream<K, V> toLocalKeyCacheStream() {
        return new LocalKeyCacheStream<K, V>(this.cache, this.parallel, this.hash, this.supplier, this.registry);
    }
}

