/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class BinaryKeyedJDBCStoreResourceDefinition
extends JDBCStoreResourceDefinition {
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)"binary-keyed-jdbc-store", (String)"BINARY_KEYED_JDBC_STORE");
    static final PathElement PATH = BinaryKeyedJDBCStoreResourceDefinition.pathElement("binary-jdbc");
    static final OperationStepHandler LEGACY_READ_TABLE_HANDLER = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress().append(new PathElement[]{BinaryTableResourceDefinition.PATH});
            ModelNode readResourceOperation = Util.createOperation((String)"read-resource", (PathAddress)address);
            operation.get("attributes-only").set(true);
            context.addStep(readResourceOperation, (OperationStepHandler)new ReadResourceHandler(), context.getCurrentStage());
        }
    };
    static final OperationStepHandler LEGACY_WRITE_TABLE_HANDLER = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress().append(new PathElement[]{BinaryTableResourceDefinition.PATH});
            ModelNode table = Operations.getAttributeValue((ModelNode)operation);
            for (Class attributeClass : Arrays.asList(BinaryTableResourceDefinition.Attribute.class, TableResourceDefinition.Attribute.class)) {
                for (Attribute attribute : (Attribute[])attributeClass.getEnumConstants()) {
                    ModelNode writeAttributeOperation = Operations.createWriteAttributeOperation((PathAddress)address, (Attribute)attribute, (ModelNode)table.get(((AttributeDefinition)attribute.getDefinition()).getName()));
                    context.addStep(writeAttributeOperation, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new Attribute[]{attribute}), context.getCurrentStage());
                }
            }
        }
    };

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildResource(PATH) : parent.addChildRedirection(PATH, LEGACY_PATH);
        JDBCStoreResourceDefinition.buildTransformation(version, builder);
        BinaryTableResourceDefinition.buildTransformation(version, builder);
    }

    BinaryKeyedJDBCStoreResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(PATH, new InfinispanResourceDescriptionResolver(PATH, BinaryKeyedJDBCStoreResourceDefinition.pathElement("jdbc"), WILDCARD_PATH), allowRuntimeOnlyRegistration);
    }

    public void registerOperations(final ManagementResourceRegistration registration) {
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(JDBCStoreResourceDefinition.Attribute.class).addAttributes(StoreResourceDefinition.Attribute.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new BinaryKeyedJDBCStoreBuilderFactory());
        new AddStepHandler((AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                super.execute(context, operation);
                if (operation.hasDefined(DeprecatedAttribute.TABLE.getDefinition().getName())) {
                    ModelNode addTableOperation = Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{BinaryTableResourceDefinition.PATH}));
                    ModelNode parameters = operation.get(DeprecatedAttribute.TABLE.getDefinition().getName());
                    for (Property parameter : parameters.asPropertyList()) {
                        addTableOperation.get(parameter.getName()).set(parameter.getValue());
                    }
                    context.addStep(addTableOperation, registration.getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{BinaryTableResourceDefinition.PATH}), "add"), context.getCurrentStage());
                }
            }
        }.register(registration);
        new RemoveStepHandler((RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    @Override
    public void registerChildren(ManagementResourceRegistration registration) {
        super.registerChildren(registration);
        new BinaryTableResourceDefinition().register(registration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        registration.registerReadWriteAttribute(DeprecatedAttribute.TABLE.getDefinition(), LEGACY_READ_TABLE_HANDLER, LEGACY_WRITE_TABLE_HANDLER);
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry(registration.registerSubModel((ResourceDefinition)this)));
    }

    @Deprecated
    static enum DeprecatedAttribute implements Attribute
    {
        TABLE("binary-keyed-table", BinaryTableResourceDefinition.Attribute.values(), TableResourceDefinition.Attribute.values(), TableResourceDefinition.ColumnAttribute.values());

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, Attribute[] ... attributeSets) {
            int size = 0;
            for (Attribute[] attributes : attributeSets) {
                size += attributes.length;
            }
            ArrayList<Object> definitions = new ArrayList<Object>(size);
            Attribute[][] attributeArray = attributeSets;
            int n2 = attributeArray.length;
            for (int i = 0; i < n2; ++i) {
                Attribute[] attributes;
                for (Attribute attribute : attributes = attributeArray[i]) {
                    definitions.add(attribute.getDefinition());
                }
            }
            this.definition = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)name, (AttributeDefinition[])definitions.toArray(new AttributeDefinition[size])).setAllowNull(true).setDeprecated(InfinispanModel.VERSION_4_0_0.getVersion())).setSuffix("table").build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

