/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.dispatcher.CommandResponseMarshaller;
import org.wildfly.clustering.server.dispatcher.LocalCommandDispatcher;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;

public class ChannelCommandDispatcherFactory
implements CommandDispatcherFactory,
RequestHandler,
AutoCloseable,
Group,
MembershipListener {
    final Map<Object, AtomicReference<Object>> contexts = new ConcurrentHashMap<Object, AtomicReference<Object>>();
    final MarshallingContext marshallingContext;
    private final List<Group.Listener> listeners = new CopyOnWriteArrayList<Group.Listener>();
    private final AtomicReference<View> view = new AtomicReference();
    private final MessageDispatcher dispatcher;
    private final JGroupsNodeFactory nodeFactory;
    private final long timeout;

    public ChannelCommandDispatcherFactory(ChannelCommandDispatcherFactoryConfiguration config) {
        this.nodeFactory = config.getNodeFactory();
        this.marshallingContext = config.getMarshallingContext();
        this.timeout = config.getTimeout();
        final CommandResponseMarshaller marshaller = new CommandResponseMarshaller(config);
        this.dispatcher = new MessageDispatcher(){

            protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address localAddr) {
                RequestCorrelator correlator = super.createRequestCorrelator(transport, handler, localAddr);
                correlator.setMarshaller(marshaller);
                return correlator;
            }
        };
        Channel channel = config.getChannel();
        this.dispatcher.setChannel(channel);
        this.dispatcher.setRequestHandler((RequestHandler)this);
        this.dispatcher.setMembershipListener((MembershipListener)this);
        this.dispatcher.start();
        this.view.compareAndSet(null, channel.getView());
    }

    @Override
    public void close() {
        this.dispatcher.stop();
    }

    /*
     * Exception decompiling
     */
    public Object handle(Message message) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Group getGroup() {
        return this;
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(final Object id, C context) {
        final int version = this.marshallingContext.getCurrentVersion();
        CommandMarshaller marshaller = new CommandMarshaller<C>(){

            @Override
            public <R> byte[] marshal(Command<R, C> command) throws IOException {
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    output.write(version);
                    try (Marshaller marshaller = ChannelCommandDispatcherFactory.this.marshallingContext.createMarshaller(version);){
                        marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                        marshaller.writeObject(id);
                        marshaller.writeObject(command);
                        marshaller.flush();
                    }
                    byte[] byArray = output.toByteArray();
                    return byArray;
                }
            }
        };
        this.contexts.put(id, new AtomicReference<C>(context));
        final LocalCommandDispatcher<C> localDispatcher = new LocalCommandDispatcher<C>(this.getLocalNode(), context);
        return new ChannelCommandDispatcher<C>(this.dispatcher, marshaller, this.nodeFactory, this.timeout, localDispatcher){

            public void close() {
                localDispatcher.close();
                ChannelCommandDispatcherFactory.this.contexts.remove(id);
            }
        };
    }

    public void addListener(Group.Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Group.Listener listener) {
        this.listeners.remove(listener);
    }

    public String getName() {
        return this.dispatcher.getChannel().getClusterName();
    }

    public boolean isCoordinator() {
        return this.dispatcher.getChannel().getAddress().equals(this.getCoordinatorAddress());
    }

    public Node getLocalNode() {
        return this.nodeFactory.createNode(this.dispatcher.getChannel().getAddress());
    }

    public Node getCoordinatorNode() {
        return this.nodeFactory.createNode(this.getCoordinatorAddress());
    }

    public List<Node> getNodes() {
        return this.getNodes(this.view.get());
    }

    private Address getCoordinatorAddress() {
        List members = this.view.get().getMembers();
        return !members.isEmpty() ? (Address)members.get(0) : null;
    }

    private List<Node> getNodes(View view) {
        return view != null ? this.getNodes(view.getMembers()) : Collections.emptyList();
    }

    private List<Node> getNodes(List<Address> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.nodeFactory.createNode(address));
        }
        return nodes;
    }

    public void viewAccepted(View view) {
        View oldView = this.view.getAndSet(view);
        if (oldView != null) {
            List<Node> oldNodes = this.getNodes(oldView);
            List<Node> newNodes = this.getNodes(view);
            List leftMembers = View.leftMembers((View)oldView, (View)view);
            if (leftMembers != null) {
                this.nodeFactory.invalidate(leftMembers);
            }
            for (Group.Listener listener : this.listeners) {
                listener.membershipChanged(oldNodes, newNodes, view instanceof MergeView);
            }
        }
    }

    public void suspect(Address member) {
    }

    public void block() {
    }

    public void unblock() {
    }
}

