/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.BitSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class IterationStartOperation
extends RetryOnFailureOperation<IterationStartResponse> {
    private static final Log log = LogFactory.getLog(IterationStartOperation.class);
    private final String filterConverterFactory;
    private final Set<Integer> segments;
    private final int batchSize;
    private final TransportFactory transportFactory;

    protected IterationStartOperation(Codec codec, Flag[] flags, byte[] cacheName, AtomicInteger topologyId, String filterConverterFactory, Set<Integer> segments, int batchSize, TransportFactory transportFactory) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.filterConverterFactory = filterConverterFactory;
        this.segments = segments;
        this.batchSize = batchSize;
        this.transportFactory = transportFactory;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    @Override
    protected IterationStartResponse executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)49);
        if (this.segments == null) {
            transport.writeSignedVInt(-1);
        } else {
            BitSet bitSet = new BitSet();
            this.segments.stream().forEach(bitSet::set);
            transport.writeOptionalArray(bitSet.toByteArray());
        }
        transport.writeOptionalString(this.filterConverterFactory);
        transport.writeVInt(this.batchSize);
        transport.flush();
        this.readHeaderAndValidate(transport, params);
        return new IterationStartResponse(transport.readString(), (SegmentConsistentHash)this.transportFactory.getConsistentHash(this.cacheName), this.topologyId.get(), transport);
    }

    @Override
    protected void releaseTransport(Transport transport) {
    }
}

