/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAProperties;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.ra.recovery.RecoveryManager;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import org.jgroups.JChannel;

public class ActiveMQResourceAdapter
implements ResourceAdapter,
Serializable {
    private static final long serialVersionUID = 4756893709825838770L;
    public static final String PRODUCT_NAME = "ActiveMQ Artemis";
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private BootstrapContext ctx;
    private final ActiveMQRAProperties raProperties;
    private String unparsedProperties;
    private String unparsedConnectors;
    private final AtomicBoolean configured;
    private final Map<ActivationSpec, ActiveMQActivation> activations;
    private ActiveMQConnectionFactory defaultActiveMQConnectionFactory;
    private ActiveMQConnectionFactory recoveryActiveMQConnectionFactory;
    private TransactionManager tm;
    private String unparsedJndiParams;
    private final RecoveryManager recoveryManager;
    private boolean useAutoRecovery = true;
    private final List<ActiveMQRAManagedConnectionFactory> managedConnectionFactories = new ArrayList<ActiveMQRAManagedConnectionFactory>();
    private String entries;

    public ActiveMQResourceAdapter() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
        this.raProperties = new ActiveMQRAProperties();
        this.configured = new AtomicBoolean(false);
        this.activations = new ConcurrentHashMap<ActivationSpec, ActiveMQActivation>();
        this.recoveryManager = new RecoveryManager();
    }

    public TransactionManager getTM() {
        return this.tm;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (spec == null) {
            throw ActiveMQRABundle.BUNDLE.noActivationSpec();
        }
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("endpointActivation(" + endpointFactory + ", " + spec + ")");
        }
        ActiveMQActivation activation = new ActiveMQActivation(this, endpointFactory, (ActiveMQActivationSpec)spec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        ActiveMQActivation activation;
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("endpointDeactivation(" + endpointFactory + ", " + spec + ")");
        }
        if ((activation = this.activations.remove(spec)) != null) {
            activation.stop();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getXAResources(" + Arrays.toString(specs) + ")");
        }
        if (this.useAutoRecovery) {
            return null;
        }
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        for (ActivationSpec spec : specs) {
            ActiveMQActivation activation = this.activations.get(spec);
            if (activation == null) continue;
            xaresources.addAll(activation.getXAResources());
        }
        return xaresources.toArray(new XAResource[xaresources.size()]);
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("start(" + ctx + ")");
        }
        this.tm = ServiceUtils.getTransactionManager();
        this.recoveryManager.start(this.useAutoRecovery);
        this.ctx = ctx;
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceAdapterInternalException("Unable to create activation", (Throwable)e);
            }
        }
        ActiveMQRALogger.LOGGER.info("Resource adaptor started");
    }

    public void stop() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("stop()");
        }
        for (Map.Entry<ActivationSpec, ActiveMQActivation> entry : this.activations.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (Exception ignored) {
                ActiveMQRALogger.LOGGER.debug("Ignored", ignored);
            }
        }
        this.activations.clear();
        for (ActiveMQRAManagedConnectionFactory managedConnectionFactory : this.managedConnectionFactories) {
            managedConnectionFactory.stop();
        }
        this.managedConnectionFactories.clear();
        if (this.defaultActiveMQConnectionFactory != null) {
            this.defaultActiveMQConnectionFactory.close();
        }
        if (this.recoveryActiveMQConnectionFactory != null) {
            this.recoveryActiveMQConnectionFactory.close();
        }
        this.recoveryManager.stop();
        ActiveMQRALogger.LOGGER.raStopped();
    }

    public void setUseAutoRecovery(Boolean useAutoRecovery) {
        this.useAutoRecovery = useAutoRecovery;
    }

    public Boolean isUseAutoRecovery() {
        return this.useAutoRecovery;
    }

    public Boolean isUseMaskedPassword() {
        return this.raProperties.isUseMaskedPassword();
    }

    public void setUseMaskedPassword(Boolean useMaskedPassword) {
        this.raProperties.setUseMaskedPassword(useMaskedPassword);
    }

    public void setPasswordCodec(String passwordCodec) {
        this.raProperties.setPasswordCodec(passwordCodec);
    }

    public String getPasswordCodec() {
        return this.raProperties.getPasswordCodec();
    }

    public void setConnectorClassName(String connectorClassName) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setTransportType(" + connectorClassName + ")");
        }
        this.unparsedConnectors = connectorClassName;
        this.raProperties.setParsedConnectorClassNames(ActiveMQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectorClassName() {
        return this.unparsedConnectors;
    }

    public String getConnectionParameters() {
        return this.unparsedProperties;
    }

    public void setConnectionParameters(String config) {
        if (config != null) {
            this.unparsedProperties = config;
            this.raProperties.setParsedConnectionParameters(ActiveMQRaUtils.parseConfig(config));
        }
    }

    public Boolean getHA() {
        return this.raProperties.isHA();
    }

    public void setHA(Boolean ha) {
        this.raProperties.setHA(ha);
    }

    public String getEntries() {
        return this.entries;
    }

    public String getJndiName() {
        Matcher m;
        if (this.entries != null && !this.entries.isEmpty() && (m = Pattern.compile("\"(.*?)\"").matcher(this.entries)).find()) {
            return m.group(1);
        }
        return null;
    }

    public void setEntries(String entries) {
        this.entries = entries;
    }

    public String getDiscoveryAddress() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryGroupAddress()");
        }
        return this.raProperties.getDiscoveryAddress();
    }

    public void setJgroupsFile(String jgroupsFile) {
        this.raProperties.setJgroupsFile(jgroupsFile);
    }

    public String getJgroupsFile() {
        return this.raProperties.getJgroupsFile();
    }

    public String getJgroupsChannelName() {
        return this.raProperties.getJgroupsChannelName();
    }

    public void setJgroupsChannelName(String jgroupsChannelName) {
        this.raProperties.setJgroupsChannelName(jgroupsChannelName);
    }

    public void setDiscoveryAddress(String dgn) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryGroupAddress(" + dgn + ")");
        }
        this.raProperties.setDiscoveryAddress(dgn);
    }

    public Integer getDiscoveryPort() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryGroupPort()");
        }
        return this.raProperties.getDiscoveryPort();
    }

    public void setDiscoveryLocalBindAddress(String discoveryLocalBindAddress) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryLocalBindAddress(" + discoveryLocalBindAddress + ")");
        }
        this.raProperties.setDiscoveryLocalBindAddress(discoveryLocalBindAddress);
    }

    public String getDiscoveryLocalBindAddress() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryLocalBindAddress()");
        }
        return this.raProperties.getDiscoveryLocalBindAddress();
    }

    public void setDiscoveryPort(Integer dgp) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryGroupPort(" + dgp + ")");
        }
        this.raProperties.setDiscoveryPort(dgp);
    }

    public Long getDiscoveryRefreshTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryRefreshTimeout()");
        }
        return this.raProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryRefreshTimeout(" + discoveryRefreshTimeout + ")");
        }
        this.raProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryInitialWaitTimeout()");
        }
        return this.raProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryInitialWaitTimeout(" + discoveryInitialWaitTimeout + ")");
        }
        this.raProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public Long getClientFailureCheckPeriod() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getClientFailureCheckPeriod()");
        }
        return this.raProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setClientFailureCheckPeriod(" + clientFailureCheckPeriod + ")");
        }
        this.raProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConnectionTTL()");
        }
        return this.raProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConnectionTTL(" + connectionTTL + ")");
        }
        this.raProperties.setConnectionTTL(connectionTTL);
    }

    public Boolean isCacheLargeMessagesClient() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isCacheLargeMessagesClient()");
        }
        return this.raProperties.isCacheLargeMessagesClient();
    }

    public void setCacheLargeMessagesClient(Boolean cacheLargeMessagesClient) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setCacheLargeMessagesClient(" + cacheLargeMessagesClient + ")");
        }
        this.raProperties.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public Boolean isCompressLargeMessage() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isCompressLargeMessage()");
        }
        return this.raProperties.isCompressLargeMessage();
    }

    public void setFailoverOnInitialConnection(Boolean failoverOnInitialConnection) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setFailoverOnInitialConnection(" + failoverOnInitialConnection + ")");
        }
        this.raProperties.setFailoverOnInitialConnection(failoverOnInitialConnection);
    }

    public Boolean isFailoverOnInitialConnection() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isFailoverOnInitialConnection()");
        }
        return this.raProperties.isFailoverOnInitialConnection();
    }

    public void setCompressLargeMessage(Boolean compressLargeMessage) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setCompressLargeMessage(" + compressLargeMessage + ")");
        }
        this.raProperties.setCompressLargeMessage(compressLargeMessage);
    }

    public Long getCallTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getCallTimeout()");
        }
        return this.raProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setCallTimeout(" + callTimeout + ")");
        }
        this.raProperties.setCallTimeout(callTimeout);
    }

    public Long getCallFailoverTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getCallFailoverTimeout()");
        }
        return this.raProperties.getCallFailoverTimeout();
    }

    public void setCallFailoverTimeout(Long callFailoverTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setCallFailoverTimeout(" + callFailoverTimeout + ")");
        }
        this.raProperties.setCallFailoverTimeout(callFailoverTimeout);
    }

    public Integer getDupsOKBatchSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDupsOKBatchSize()");
        }
        return this.raProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDupsOKBatchSize(" + dupsOKBatchSize + ")");
        }
        this.raProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getTransactionBatchSize()");
        }
        return this.raProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setTransactionBatchSize(" + transactionBatchSize + ")");
        }
        this.raProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Integer getConsumerWindowSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConsumerWindowSize()");
        }
        return this.raProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConsumerWindowSize(" + consumerWindowSize + ")");
        }
        this.raProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConsumerMaxRate()");
        }
        return this.raProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConsumerMaxRate(" + consumerMaxRate + ")");
        }
        this.raProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getConfirmationWindowSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConfirmationWindowSize()");
        }
        return this.raProperties.getConfirmationWindowSize();
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConfirmationWindowSize(" + confirmationWindowSize + ")");
        }
        this.raProperties.setConfirmationWindowSize(confirmationWindowSize);
    }

    public Integer getProducerMaxRate() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getProducerMaxRate()");
        }
        return this.raProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setProducerMaxRate(" + producerMaxRate + ")");
        }
        this.raProperties.setProducerMaxRate(producerMaxRate);
    }

    public Integer getProducerWindowSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getProducerWindowSize()");
        }
        return this.raProperties.getProducerWindowSize();
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setProducerWindowSize(" + producerWindowSize + ")");
        }
        this.raProperties.setProducerWindowSize(producerWindowSize);
    }

    public Integer getMinLargeMessageSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMinLargeMessageSize()");
        }
        return this.raProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setMinLargeMessageSize(" + minLargeMessageSize + ")");
        }
        this.raProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean getBlockOnAcknowledge() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getBlockOnAcknowledge()");
        }
        return this.raProperties.isBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setBlockOnAcknowledge(" + blockOnAcknowledge + ")");
        }
        this.raProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean getBlockOnNonDurableSend() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getBlockOnNonDurableSend()");
        }
        return this.raProperties.isBlockOnNonDurableSend();
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setBlockOnNonDurableSend(" + blockOnNonDurableSend + ")");
        }
        this.raProperties.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public Boolean getBlockOnDurableSend() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getBlockOnDurableSend()");
        }
        return this.raProperties.isBlockOnDurableSend();
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setBlockOnDurableSend(" + blockOnDurableSend + ")");
        }
        this.raProperties.setBlockOnDurableSend(blockOnDurableSend);
    }

    public Boolean getAutoGroup() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getAutoGroup()");
        }
        return this.raProperties.isAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setAutoGroup(" + autoGroup + ")");
        }
        this.raProperties.setAutoGroup(autoGroup);
    }

    public Boolean getPreAcknowledge() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getPreAcknowledge()");
        }
        return this.raProperties.isPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setPreAcknowledge(" + preAcknowledge + ")");
        }
        this.raProperties.setPreAcknowledge(preAcknowledge);
    }

    public Integer getInitialConnectAttempts() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getInitialConnectAttempts()");
        }
        return this.raProperties.getInitialConnectAttempts();
    }

    public void setInitialConnectAttempts(Integer initialConnectAttempts) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setInitialConnectionAttempts(" + initialConnectAttempts + ")");
        }
        this.raProperties.setInitialConnectAttempts(initialConnectAttempts);
    }

    public Integer getInitialMessagePacketSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getInitialMessagePacketSize()");
        }
        return this.raProperties.getInitialMessagePacketSize();
    }

    public void setInitialMessagePacketSize(Integer initialMessagePacketSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setInitialMessagePacketSize(" + initialMessagePacketSize + ")");
        }
        this.raProperties.setInitialMessagePacketSize(initialMessagePacketSize);
    }

    public Long getRetryInterval() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getRetryInterval()");
        }
        return this.raProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setRetryInterval(" + retryInterval + ")");
        }
        this.raProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getRetryIntervalMultiplier()");
        }
        return this.raProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setRetryIntervalMultiplier(" + retryIntervalMultiplier + ")");
        }
        this.raProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Long getMaxRetryInterval() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMaxRetryInterval()");
        }
        return this.raProperties.getMaxRetryInterval();
    }

    public void setMaxRetryInterval(Long maxRetryInterval) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setMaxRetryInterval(" + maxRetryInterval + ")");
        }
        this.raProperties.setMaxRetryInterval(maxRetryInterval);
    }

    public Integer getReconnectAttempts() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getReconnectAttempts()");
        }
        return this.raProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setReconnectAttempts(" + reconnectAttempts + ")");
        }
        this.raProperties.setReconnectAttempts(reconnectAttempts);
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.raProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + connectionLoadBalancingPolicyClassName + ")");
        }
        this.raProperties.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.raProperties.getScheduledThreadPoolMaxSize();
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + scheduledThreadPoolMaxSize + ")");
        }
        this.raProperties.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public Integer getThreadPoolMaxSize() {
        return this.raProperties.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + threadPoolMaxSize + ")");
        }
        this.raProperties.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public Boolean getUseGlobalPools() {
        return this.raProperties.isUseGlobalPools();
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + useGlobalPools + ")");
        }
        this.raProperties.setUseGlobalPools(useGlobalPools);
    }

    public String getUserName() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getUserName()");
        }
        return this.raProperties.getUserName();
    }

    public void setUserName(String userName) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.raProperties.setUserName(userName);
    }

    public String getPassword() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getPassword()");
        }
        return this.raProperties.getPassword();
    }

    public void setPassword(String password) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.raProperties.setPassword(password);
    }

    public boolean isUseJNDI() {
        return this.raProperties.isUseJNDI();
    }

    public void setUseJNDI(Boolean value) {
        this.raProperties.setUseJNDI(value);
    }

    public String getJndiParams() {
        return this.unparsedJndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.unparsedJndiParams = jndiParams;
        this.raProperties.setParsedJndiParams(ActiveMQRaUtils.parseHashtableConfig(jndiParams));
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        return this.raProperties.getParsedJndiParams();
    }

    public String getClientID() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getClientID()");
        }
        return this.raProperties.getClientID();
    }

    public void setClientID(String clientID) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setClientID(" + clientID + ")");
        }
        this.raProperties.setClientID(clientID);
    }

    public String getGroupID() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getGroupID()");
        }
        return this.raProperties.getGroupID();
    }

    public void setGroupID(String groupID) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setGroupID(" + groupID + ")");
        }
        this.raProperties.setGroupID(groupID);
    }

    public Boolean getUseLocalTx() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getUseLocalTx()");
        }
        return this.raProperties.getUseLocalTx();
    }

    public void setUseLocalTx(Boolean localTx) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setUseXA(" + localTx + ")");
        }
        this.raProperties.setUseLocalTx(localTx);
    }

    public int getSetupAttempts() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getSetupAttempts()");
        }
        return this.raProperties.getSetupAttempts();
    }

    public void setSetupAttempts(Integer setupAttempts) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setSetupAttempts(" + setupAttempts + ")");
        }
        this.raProperties.setSetupAttempts(setupAttempts);
    }

    public long getSetupInterval() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getSetupInterval()");
        }
        return this.raProperties.getSetupInterval();
    }

    public void setSetupInterval(Long interval) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setSetupInterval(" + interval + ")");
        }
        this.raProperties.setSetupInterval(interval);
    }

    public boolean equals(Object obj) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("equals(" + obj + ")");
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActiveMQResourceAdapter) {
            return this.raProperties.equals(((ActiveMQResourceAdapter)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("hashCode()");
        }
        return this.raProperties.hashCode();
    }

    public WorkManager getWorkManager() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getWorkManager()");
        }
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.getWorkManager();
    }

    public ClientSession createSession(ClientSessionFactory parameterFactory, int ackMode, String user, String pass, Boolean preAck, Integer dupsOkBatchSize, Integer transactionBatchSize, boolean deliveryTransacted, boolean useLocalTx, Integer txTimeout) throws Exception {
        ClientSession result;
        if (deliveryTransacted || useLocalTx) {
            result = useLocalTx ? parameterFactory.createSession(user, pass, false, false, false, false, 0) : parameterFactory.createSession(user, pass, true, false, false, false, 0);
        } else if (preAck != null && preAck.booleanValue()) {
            result = parameterFactory.createSession(user, pass, false, true, true, true, -1);
        } else {
            switch (ackMode) {
                case 1: {
                    result = parameterFactory.createSession(user, pass, false, true, true, false, 0);
                    break;
                }
                case 3: {
                    int actDupsOkBatchSize = dupsOkBatchSize != null ? dupsOkBatchSize : 0x100000;
                    result = parameterFactory.createSession(user, pass, false, true, true, false, actDupsOkBatchSize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ackmode: " + ackMode);
                }
            }
        }
        ActiveMQRALogger.LOGGER.debug("Using queue connection " + result);
        return result;
    }

    public RecoveryManager getRecoveryManager() {
        return this.recoveryManager;
    }

    protected ActiveMQRAProperties getProperties() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getProperties()");
        }
        return this.raProperties;
    }

    protected void setup() throws ActiveMQException {
        this.raProperties.init();
        this.defaultActiveMQConnectionFactory = this.createActiveMQConnectionFactory(this.raProperties);
        this.recoveryActiveMQConnectionFactory = this.createRecoveryActiveMQConnectionFactory(this.raProperties);
        this.recoveryManager.register(this.recoveryActiveMQConnectionFactory, this.raProperties.getUserName(), this.raProperties.getPassword());
    }

    public Map<ActivationSpec, ActiveMQActivation> getActivations() {
        return this.activations;
    }

    public ActiveMQConnectionFactory getDefaultActiveMQConnectionFactory() throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        return this.defaultActiveMQConnectionFactory;
    }

    public String getJgroupsChannelLocatorClass() {
        return this.raProperties.getJgroupsChannelLocatorClass();
    }

    public void setJgroupsChannelLocatorClass(String jgroupsChannelLocatorClass) {
        this.raProperties.setJgroupsChannelLocatorClass(jgroupsChannelLocatorClass);
    }

    public String getJgroupsChannelRefName() {
        return this.raProperties.getJgroupsChannelRefName();
    }

    public void setJgroupsChannelRefName(String jgroupsChannelRefName) {
        this.raProperties.setJgroupsChannelRefName(jgroupsChannelRefName);
    }

    public ActiveMQConnectionFactory createActiveMQConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        List<String> connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        String discoveryAddress = overrideProperties.getDiscoveryAddress() != null ? overrideProperties.getDiscoveryAddress() : this.getDiscoveryAddress();
        Boolean ha = overrideProperties.isHA() != null ? overrideProperties.isHA() : this.getHA();
        String jgroupsFileName = overrideProperties.getJgroupsFile() != null ? overrideProperties.getJgroupsFile() : this.getJgroupsFile();
        String jgroupsChannel = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        String jgroupsLocatorClassName = this.raProperties.getJgroupsChannelLocatorClass();
        if (ha == null) {
            ha = false;
        }
        if (discoveryAddress != null || jgroupsFileName != null || jgroupsLocatorClassName != null) {
            Long initialTimeout;
            Long refreshTimeout;
            JGroupsFileBroadcastEndpointFactory endpointFactory = null;
            if (jgroupsLocatorClassName != null) {
                String jchannelRefName = this.raProperties.getJgroupsChannelRefName();
                JChannel jchannel = ActiveMQRaUtils.locateJGroupsChannel(jgroupsLocatorClassName, jchannelRefName);
                endpointFactory = new ChannelBroadcastEndpointFactory(jchannel, jgroupsChannel);
            } else if (discoveryAddress != null) {
                Integer discoveryPort;
                Integer n = discoveryPort = overrideProperties.getDiscoveryPort() != null ? overrideProperties.getDiscoveryPort() : this.getDiscoveryPort();
                if (discoveryPort == null) {
                    discoveryPort = 9876;
                }
                String localBindAddress = overrideProperties.getDiscoveryLocalBindAddress() != null ? overrideProperties.getDiscoveryLocalBindAddress() : this.raProperties.getDiscoveryLocalBindAddress();
                endpointFactory = new UDPBroadcastEndpointFactory().setGroupAddress(discoveryAddress).setGroupPort(discoveryPort.intValue()).setLocalBindAddress(localBindAddress).setLocalBindPort(-1);
            } else if (jgroupsFileName != null) {
                endpointFactory = new JGroupsFileBroadcastEndpointFactory().setChannelName(jgroupsChannel).setFile(jgroupsFileName);
            }
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setRefreshTimeout(refreshTimeout.longValue()).setDiscoveryInitialWaitTimeout(initialTimeout.longValue()).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Connection Factory on the resource adapter for discovery=" + groupConfiguration + " with ha=" + ha);
            }
            cf = ha.booleanValue() ? ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else if (connectorClassName != null) {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    ActiveMQRALogger.LOGGER.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Connection Factory on the resource adapter for transport=" + Arrays.toString(transportConfigurations) + " with ha=" + ha);
            }
            cf = ha.booleanValue() ? ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        } else {
            throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for ResourceAdapter Connection Factory");
        }
        this.setParams(cf, overrideProperties);
        return cf;
    }

    public ActiveMQConnectionFactory createRecoveryActiveMQConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        String jgroupsChannel;
        List<String> connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        String discoveryAddress = overrideProperties.getDiscoveryAddress() != null ? overrideProperties.getDiscoveryAddress() : this.getDiscoveryAddress();
        String jgroupsFileName = overrideProperties.getJgroupsFile() != null ? overrideProperties.getJgroupsFile() : this.getJgroupsFile();
        String string = jgroupsChannel = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        if (connectorClassName == null) {
            Long initialTimeout;
            Long refreshTimeout;
            JGroupsFileBroadcastEndpointFactory endpointFactory = null;
            if (discoveryAddress != null) {
                Integer discoveryPort;
                Integer n = discoveryPort = overrideProperties.getDiscoveryPort() != null ? overrideProperties.getDiscoveryPort() : this.getDiscoveryPort();
                if (discoveryPort == null) {
                    discoveryPort = 9876;
                }
                String localBindAddress = overrideProperties.getDiscoveryLocalBindAddress() != null ? overrideProperties.getDiscoveryLocalBindAddress() : this.raProperties.getDiscoveryLocalBindAddress();
                endpointFactory = new UDPBroadcastEndpointFactory().setGroupAddress(discoveryAddress).setGroupPort(discoveryPort.intValue()).setLocalBindAddress(localBindAddress).setLocalBindPort(-1);
            } else if (jgroupsFileName != null) {
                endpointFactory = new JGroupsFileBroadcastEndpointFactory().setChannelName(jgroupsChannel).setFile(jgroupsFileName);
            } else {
                String jgroupsLocatorClass = this.raProperties.getJgroupsChannelLocatorClass();
                if (jgroupsLocatorClass != null) {
                    String jgroupsChannelRefName = this.raProperties.getJgroupsChannelRefName();
                    JChannel jchannel = ActiveMQRaUtils.locateJGroupsChannel(jgroupsLocatorClass, jgroupsChannelRefName);
                    endpointFactory = new ChannelBroadcastEndpointFactory(jchannel, jgroupsChannel);
                }
                if (endpointFactory == null) {
                    throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for ResourceAdapter Connection Factory");
                }
            }
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setRefreshTimeout(refreshTimeout.longValue()).setDiscoveryInitialWaitTimeout(initialTimeout.longValue()).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
            groupConfiguration.setRefreshTimeout(refreshTimeout.longValue());
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Recovery Connection Factory on the resource adapter for discovery=" + groupConfiguration);
            }
            cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    ActiveMQRALogger.LOGGER.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Recovery Connection Factory on the resource adapter for transport=" + Arrays.toString(transportConfigurations));
            }
            cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        }
        this.setParams(cf, overrideProperties);
        cf.setReconnectAttempts(0);
        cf.setInitialConnectAttempts(0);
        return cf;
    }

    public Map<String, Object> overrideConnectionParameters(Map<String, Object> connectionParams, Map<String, Object> overrideConnectionParams) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (connectionParams != null) {
            map.putAll(connectionParams);
        }
        if (overrideConnectionParams != null) {
            for (Map.Entry<String, Object> stringObjectEntry : overrideConnectionParams.entrySet()) {
                map.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
        }
        return map;
    }

    private void setParams(ActiveMQConnectionFactory cf, ConnectionFactoryProperties overrideProperties) {
        String val5;
        Double val4;
        Long val3;
        Integer val2;
        Boolean val;
        Boolean bl = val = overrideProperties.isAutoGroup() != null ? overrideProperties.isAutoGroup() : this.raProperties.isAutoGroup();
        if (val != null) {
            cf.setAutoGroup(val.booleanValue());
        }
        Boolean bl2 = val = overrideProperties.isBlockOnAcknowledge() != null ? overrideProperties.isBlockOnAcknowledge() : this.raProperties.isBlockOnAcknowledge();
        if (val != null) {
            cf.setBlockOnAcknowledge(val.booleanValue());
        }
        Boolean bl3 = val = overrideProperties.isBlockOnNonDurableSend() != null ? overrideProperties.isBlockOnNonDurableSend() : this.raProperties.isBlockOnNonDurableSend();
        if (val != null) {
            cf.setBlockOnNonDurableSend(val.booleanValue());
        }
        Boolean bl4 = val = overrideProperties.isBlockOnDurableSend() != null ? overrideProperties.isBlockOnDurableSend() : this.raProperties.isBlockOnDurableSend();
        if (val != null) {
            cf.setBlockOnDurableSend(val.booleanValue());
        }
        Boolean bl5 = val = overrideProperties.isPreAcknowledge() != null ? overrideProperties.isPreAcknowledge() : this.raProperties.isPreAcknowledge();
        if (val != null) {
            cf.setPreAcknowledge(val.booleanValue());
        }
        Boolean bl6 = val = overrideProperties.isUseGlobalPools() != null ? overrideProperties.isUseGlobalPools() : this.raProperties.isUseGlobalPools();
        if (val != null) {
            cf.setUseGlobalPools(val.booleanValue());
        }
        Boolean bl7 = val = overrideProperties.isCacheLargeMessagesClient() != null ? overrideProperties.isCacheLargeMessagesClient() : this.raProperties.isCacheLargeMessagesClient();
        if (val != null) {
            cf.setCacheLargeMessagesClient(val.booleanValue());
        }
        Boolean bl8 = val = overrideProperties.isCompressLargeMessage() != null ? overrideProperties.isCompressLargeMessage() : this.raProperties.isCompressLargeMessage();
        if (val != null) {
            cf.setCompressLargeMessage(val.booleanValue());
        }
        Boolean bl9 = val = overrideProperties.isFailoverOnInitialConnection() != null ? overrideProperties.isFailoverOnInitialConnection() : this.raProperties.isFailoverOnInitialConnection();
        if (val != null) {
            cf.setFailoverOnInitialConnection(val.booleanValue());
        }
        Integer n = val2 = overrideProperties.getConsumerMaxRate() != null ? overrideProperties.getConsumerMaxRate() : this.raProperties.getConsumerMaxRate();
        if (val2 != null) {
            cf.setConsumerMaxRate(val2.intValue());
        }
        Integer n2 = val2 = overrideProperties.getConsumerWindowSize() != null ? overrideProperties.getConsumerWindowSize() : this.raProperties.getConsumerWindowSize();
        if (val2 != null) {
            cf.setConsumerWindowSize(val2.intValue());
        }
        Integer n3 = val2 = overrideProperties.getDupsOKBatchSize() != null ? overrideProperties.getDupsOKBatchSize() : this.raProperties.getDupsOKBatchSize();
        if (val2 != null) {
            cf.setDupsOKBatchSize(val2.intValue());
        }
        Integer n4 = val2 = overrideProperties.getMinLargeMessageSize() != null ? overrideProperties.getMinLargeMessageSize() : this.raProperties.getMinLargeMessageSize();
        if (val2 != null) {
            cf.setMinLargeMessageSize(val2.intValue());
        }
        Integer n5 = val2 = overrideProperties.getProducerMaxRate() != null ? overrideProperties.getProducerMaxRate() : this.raProperties.getProducerMaxRate();
        if (val2 != null) {
            cf.setProducerMaxRate(val2.intValue());
        }
        Integer n6 = val2 = overrideProperties.getProducerWindowSize() != null ? overrideProperties.getProducerWindowSize() : this.raProperties.getProducerWindowSize();
        if (val2 != null) {
            cf.setProducerWindowSize(val2.intValue());
        }
        Integer n7 = val2 = overrideProperties.getConfirmationWindowSize() != null ? overrideProperties.getConfirmationWindowSize() : this.raProperties.getConfirmationWindowSize();
        if (val2 != null) {
            cf.setConfirmationWindowSize(val2.intValue());
        }
        Integer n8 = val2 = overrideProperties.getReconnectAttempts() != null ? overrideProperties.getReconnectAttempts() : this.raProperties.getReconnectAttempts();
        if (val2 != null) {
            cf.setReconnectAttempts(val2.intValue());
        } else {
            cf.setReconnectAttempts(-1);
        }
        Integer n9 = val2 = overrideProperties.getThreadPoolMaxSize() != null ? overrideProperties.getThreadPoolMaxSize() : this.raProperties.getThreadPoolMaxSize();
        if (val2 != null) {
            cf.setThreadPoolMaxSize(val2.intValue());
        }
        Integer n10 = val2 = overrideProperties.getScheduledThreadPoolMaxSize() != null ? overrideProperties.getScheduledThreadPoolMaxSize() : this.raProperties.getScheduledThreadPoolMaxSize();
        if (val2 != null) {
            cf.setScheduledThreadPoolMaxSize(val2.intValue());
        }
        Integer n11 = val2 = overrideProperties.getTransactionBatchSize() != null ? overrideProperties.getTransactionBatchSize() : this.raProperties.getTransactionBatchSize();
        if (val2 != null) {
            cf.setTransactionBatchSize(val2.intValue());
        }
        Integer n12 = val2 = overrideProperties.getInitialConnectAttempts() != null ? overrideProperties.getInitialConnectAttempts() : this.raProperties.getInitialConnectAttempts();
        if (val2 != null) {
            cf.setInitialConnectAttempts(val2.intValue());
        }
        Integer n13 = val2 = overrideProperties.getInitialMessagePacketSize() != null ? overrideProperties.getInitialMessagePacketSize() : this.raProperties.getInitialMessagePacketSize();
        if (val2 != null) {
            cf.setInitialMessagePacketSize(val2.intValue());
        }
        Long l = val3 = overrideProperties.getClientFailureCheckPeriod() != null ? overrideProperties.getClientFailureCheckPeriod() : this.raProperties.getClientFailureCheckPeriod();
        if (val3 != null) {
            cf.setClientFailureCheckPeriod(val3.longValue());
        }
        Long l2 = val3 = overrideProperties.getCallTimeout() != null ? overrideProperties.getCallTimeout() : this.raProperties.getCallTimeout();
        if (val3 != null) {
            cf.setCallTimeout(val3.longValue());
        }
        Long l3 = val3 = overrideProperties.getCallFailoverTimeout() != null ? overrideProperties.getCallFailoverTimeout() : this.raProperties.getCallFailoverTimeout();
        if (val3 != null) {
            cf.setCallFailoverTimeout(val3.longValue());
        }
        Long l4 = val3 = overrideProperties.getConnectionTTL() != null ? overrideProperties.getConnectionTTL() : this.raProperties.getConnectionTTL();
        if (val3 != null) {
            cf.setConnectionTTL(val3.longValue());
        }
        Long l5 = val3 = overrideProperties.getRetryInterval() != null ? overrideProperties.getRetryInterval() : this.raProperties.getRetryInterval();
        if (val3 != null) {
            cf.setRetryInterval(val3.longValue());
        }
        Long l6 = val3 = overrideProperties.getMaxRetryInterval() != null ? overrideProperties.getMaxRetryInterval() : this.raProperties.getMaxRetryInterval();
        if (val3 != null) {
            cf.setMaxRetryInterval(val3.longValue());
        }
        Double d = val4 = overrideProperties.getRetryIntervalMultiplier() != null ? overrideProperties.getRetryIntervalMultiplier() : this.raProperties.getRetryIntervalMultiplier();
        if (val4 != null) {
            cf.setRetryIntervalMultiplier(val4.doubleValue());
        }
        String string = val5 = overrideProperties.getClientID() != null ? overrideProperties.getClientID() : this.raProperties.getClientID();
        if (val5 != null) {
            cf.setClientID(val5);
        }
        String string2 = val5 = overrideProperties.getConnectionLoadBalancingPolicyClassName() != null ? overrideProperties.getConnectionLoadBalancingPolicyClassName() : this.raProperties.getConnectionLoadBalancingPolicyClassName();
        if (val5 != null) {
            cf.setConnectionLoadBalancingPolicyClassName(val5);
        }
    }

    public void setManagedConnectionFactory(ActiveMQRAManagedConnectionFactory activeMQRAManagedConnectionFactory) {
        this.managedConnectionFactories.add(activeMQRAManagedConnectionFactory);
    }

    public SensitiveDataCodec<String> getCodecInstance() {
        return this.raProperties.getCodecInstance();
    }
}

