/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.invm;

import io.netty.channel.ChannelFutureListener;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class InVMConnection
implements Connection {
    private static final boolean isTrace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final String id;
    private boolean closed;
    private static boolean flushEnabled = true;
    private final int serverID;
    private final Executor executor;
    private volatile boolean closing;
    private final ActiveMQPrincipal defaultActiveMQPrincipal;
    private RemotingConnection protocolConnection;

    public InVMConnection(int serverID, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this(serverID, UUIDGenerator.getInstance().generateSimpleStringUUID().toString(), handler, listener, executor);
    }

    public InVMConnection(int serverID, String id, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this(serverID, id, handler, listener, executor, null);
    }

    public InVMConnection(int serverID, String id, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor, ActiveMQPrincipal defaultActiveMQPrincipal) {
        this.serverID = serverID;
        this.handler = handler;
        this.listener = listener;
        this.id = id;
        this.executor = executor;
        this.defaultActiveMQPrincipal = defaultActiveMQPrincipal;
    }

    public void forceClose() {
    }

    public RemotingConnection getProtocolConnection() {
        return this.protocolConnection;
    }

    public void setProtocolConnection(RemotingConnection connection) {
        this.protocolConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        InVMConnection inVMConnection = this;
        synchronized (inVMConnection) {
            if (!this.closed) {
                this.listener.connectionDestroyed((Object)this.id);
                this.closed = true;
            }
        }
    }

    public ActiveMQBuffer createTransportBuffer(int size) {
        return ActiveMQBuffers.dynamicBuffer((int)size);
    }

    public Object getID() {
        return this.id;
    }

    public void checkFlushBatchBuffer() {
    }

    public void write(ActiveMQBuffer buffer) {
        this.write(buffer, false, false, null);
    }

    public void write(ActiveMQBuffer buffer, boolean flush, boolean batch) {
        this.write(buffer, flush, batch, null);
    }

    public void write(ActiveMQBuffer buffer, boolean flush, boolean batch, final ChannelFutureListener futureListener) {
        block5: {
            final ActiveMQBuffer copied = buffer.copy(0, buffer.capacity());
            copied.setIndex(buffer.readerIndex(), buffer.writerIndex());
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!InVMConnection.this.closed) {
                                copied.readInt();
                                if (isTrace) {
                                    ActiveMQServerLogger.LOGGER.trace(InVMConnection.this + "::Sending inVM packet");
                                }
                                InVMConnection.this.handler.bufferReceived((Object)InVMConnection.this.id, copied);
                                if (futureListener != null) {
                                    futureListener.operationComplete(null);
                                }
                            }
                        }
                        catch (Exception e) {
                            String msg = "Failed to write to handler on connector " + this;
                            ActiveMQServerLogger.LOGGER.errorWritingToInvmConnector(e, this);
                            throw new IllegalStateException(msg, e);
                        }
                        finally {
                            if (isTrace) {
                                ActiveMQServerLogger.LOGGER.trace(InVMConnection.this + "::packet sent done");
                            }
                        }
                    }
                });
                if (!flush || !flushEnabled) break block5;
                final CountDownLatch latch = new CountDownLatch(1);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
                try {
                    if (!latch.await(10L, TimeUnit.SECONDS)) {
                        ActiveMQServerLogger.LOGGER.timedOutFlushingInvmChannel();
                    }
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
    }

    public String getRemoteAddress() {
        return "invm:" + this.serverID;
    }

    public int getBatchingBufferSize() {
        return -1;
    }

    public void addReadyListener(ReadyListener listener) {
    }

    public void removeReadyListener(ReadyListener listener) {
    }

    public boolean isUsingProtocolHandling() {
        return false;
    }

    public ActiveMQPrincipal getDefaultActiveMQPrincipal() {
        return this.defaultActiveMQPrincipal;
    }

    public static void setFlushEnabled(boolean enable) {
        flushEnabled = enable;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public TransportConfiguration getConnectorConfig() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("serverId", this.serverID);
        return new TransportConfiguration(InVMConnectorFactory.class.getName(), params);
    }

    public String toString() {
        return "InVMConnection [serverID=" + this.serverID + ", id=" + this.id + "]";
    }
}

