/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.access.TransactionalAccessDelegate;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.engine.spi.SessionImplementor;

public class TxTransactionalAccessDelegate
extends TransactionalAccessDelegate {
    public TxTransactionalAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        super(region, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.beginInvalidatingKey(session, key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.put(key, value);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        if (!this.putValidator.beginInvalidatingKey(session, key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.put(key, value);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }
}

