/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class Externalizers {
    public static final int UUID = 1200;
    public static final AdvancedExternalizer[] ALL_EXTERNALIZERS = new AdvancedExternalizer[]{new UUIDExternalizer()};

    public static class UUIDExternalizer
    implements AdvancedExternalizer<UUID> {
        public Set<Class<? extends UUID>> getTypeClasses() {
            return Collections.singleton(UUID.class);
        }

        public Integer getId() {
            return 1200;
        }

        public void writeObject(ObjectOutput output, UUID uuid) throws IOException {
            output.writeLong(uuid.getMostSignificantBits());
            output.writeLong(uuid.getLeastSignificantBits());
        }

        public UUID readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new UUID(input.readLong(), input.readLong());
        }
    }
}

