/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem30Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.MdbDeliveryGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem31Parser
extends EJB3Subsystem30Parser {
    public static final EJB3Subsystem31Parser INSTANCE = new EJB3Subsystem31Parser();

    protected EJB3Subsystem31Parser() {
    }

    @Override
    protected EJB3SubsystemNamespace getExpectedNamespace() {
        return EJB3SubsystemNamespace.EJB3_3_1;
    }

    @Override
    protected void parseMDB(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case RESOURCE_ADAPTER_REF: {
                    String resourceAdapterName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.parseAndSetParameter(resourceAdapterName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case DELIVERY_GROUPS: {
                    this.parseDeliveryGroups(reader, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseDeliveryGroups(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case DELIVERY_GROUP: {
                    int count = reader.getAttributeCount();
                    String groupName = null;
                    ModelNode operation = Util.createAddOperation();
                    block8: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                groupName = value;
                                continue block8;
                            }
                            case ACTIVE: {
                                MdbDeliveryGroupResourceDefinition.ACTIVE.parseAndSetParameter(reader.getAttributeValue(i), operation, (XMLStreamReader)reader);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    if (groupName == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
                    }
                    PathAddress address = SUBSYSTEM_PATH.append("mdb-delivery-group", groupName);
                    operation.get("address").set(address.toModelNode());
                    operations.add(operation);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

